/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SdkInfoDialog
extends Dialog {
    private ISDK sdk;

    public SdkInfoDialog(Shell parentShell, ISDK sdk) {
        super(parentShell);
        this.sdk = sdk;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("SDK Info");
        shell.setMinimumSize(300, 100);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        Composite contents = new Composite(composite, 0);
        contents.setLayout((Layout)new GridLayout(1, false));
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createBaseInformationGroup(contents);
        this.createEnvironmentGroup(contents);
        this.createFilterOptionsGroup(contents);
        this.createExtendedParametersGroup(contents);
        SdkInfoDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void createBaseInformationGroup(Composite contents) {
        Group group = this.createInfoGroup(contents, "Base information");
        this.createInfoElement((Composite)group, Messages.SDKDialog_name_label_text, this.sdk.getName());
        this.createInfoElement((Composite)group, Messages.SDKDialog_version_label_text, this.sdk.getVersion());
        this.createInfoElement((Composite)group, "Type:", this.sdk.getType().toString());
        this.createInfoElement((Composite)group, "ID:", this.sdk.getId());
        String sdkDescription = this.sdk.getDescription();
        if (sdkDescription != null && !sdkDescription.isEmpty()) {
            this.createInfoElement((Composite)group, Messages.SDKDialog_description_label_text, sdkDescription);
        }
        this.createLinkInfoElement((Composite)group, Messages.SDKDialog_location_label_text, this.sdk.getHeader().getBasePath());
    }

    private void createEnvironmentGroup(Composite contents) {
        IEnvironment environment = this.sdk.getEnv();
        if (environment != null) {
            Group group = this.createInfoGroup(contents, Messages.SDKDialog_env_variable_group_text);
            this.createInfoElement((Composite)group, Messages.SDKDialog_name_label_text, environment.getName());
            String value = environment.getValue();
            this.createLinkInfoElement((Composite)group, "Value:", value != null ? value : "");
        }
    }

    private void createFilterOptionsGroup(Composite contents) {
        IFilterOptions filterOptions = this.sdk.getFilterOptions();
        if (filterOptions != null && !filterOptions.equals(FilterOptions.EMPTY_FILTER)) {
            IFilterOptions.ELang langs;
            String[] hardwareParams;
            Group optionsGroup = this.createInfoGroup(contents, "Filter options");
            IToolChain[] toolChains = filterOptions.getToolChains();
            if (toolChains != null && toolChains.length > 0) {
                StringBuilder sb = new StringBuilder();
                Arrays.stream(toolChains).map(IBuildObject::getId).forEach(tcId -> {
                    StringBuilder stringBuilder2 = sb.append((String)tcId).append('\n');
                });
                sb.deleteCharAt(sb.length() - 1);
                this.createInfoElement((Composite)optionsGroup, "Toolchains:", sb.toString());
            }
            if ((hardwareParams = filterOptions.getCores()) != null && hardwareParams.length > 0) {
                StringBuilder sb = new StringBuilder();
                Arrays.stream(hardwareParams).forEach(hwpId -> {
                    StringBuilder stringBuilder2 = sb.append((String)hwpId).append('\n');
                });
                sb.deleteCharAt(sb.length() - 1);
                this.createInfoElement((Composite)optionsGroup, "Hardware params:", sb.toString());
            }
            if ((langs = filterOptions.getLang()) != null && IFilterOptions.ELang.UNKNOWN != langs) {
                this.createInfoElement((Composite)optionsGroup, "Languages:", langs.toString());
            }
            String platformTarget = filterOptions.getPlatform();
            String platformHost = filterOptions.getHost();
            if (!platformTarget.isEmpty() || !platformHost.isEmpty()) {
                Group platformGroup = this.createInfoGroup((Composite)optionsGroup, "Platform");
                this.createInfoElement((Composite)platformGroup, "Target:", platformTarget);
                this.createInfoElement((Composite)platformGroup, "Host:", platformHost);
            }
        }
    }

    private void createExtendedParametersGroup(Composite contents) {
        boolean isShowTags = false;
        Set<String> tags = this.sdk.getTags();
        if (tags != null && !tags.isEmpty()) {
            isShowTags = true;
        }
        boolean isShowTargetProjectTemplate = false;
        String targetProjectTemplate = this.sdk.getTargetProjectTemplate();
        if (targetProjectTemplate != null && !targetProjectTemplate.isEmpty()) {
            isShowTargetProjectTemplate = true;
        }
        boolean isShowTargetFolderName = false;
        String targetFolderName = this.sdk.getHeader().getTargetFolderName();
        if (targetFolderName != null && !targetFolderName.isEmpty() && !targetFolderName.equals(this.sdk.getName())) {
            isShowTargetFolderName = true;
        }
        boolean isShowExternalId = false;
        String externalId = this.sdk.getExternalId();
        if (externalId != null && !externalId.isEmpty()) {
            isShowExternalId = true;
        }
        if (isShowTags || isShowTargetProjectTemplate || isShowTargetFolderName || isShowExternalId) {
            Group extendedParamsGroup = this.createInfoGroup(contents, "Extended parameters");
            if (isShowTags) {
                StringBuilder sb = new StringBuilder();
                tags.forEach(tag -> {
                    StringBuilder stringBuilder2 = sb.append((String)tag).append('\n');
                });
                sb.deleteCharAt(sb.length() - 1);
                this.createInfoElement((Composite)extendedParamsGroup, "Tags:", sb.toString());
            }
            if (isShowTargetProjectTemplate) {
                this.createInfoElement((Composite)extendedParamsGroup, "Project template:", targetProjectTemplate);
            }
            if (isShowTargetFolderName) {
                this.createInfoElement((Composite)extendedParamsGroup, Messages.SDKDialog_target_folder_name_label_text, targetFolderName);
            }
            if (isShowExternalId) {
                this.createInfoElement((Composite)extendedParamsGroup, "External ID:", externalId);
            }
        }
    }

    private Group createInfoGroup(Composite parent, String label) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(label);
        return group;
    }

    private void createInfoElement(Composite parent, String label, String text) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(label);
        this.createTextField(parent, text);
    }

    private void createLinkInfoElement(Composite parent, String label, String text) {
        final String path = SDKSupportPlugin.performStringSubstitution(text, null);
        File dir = new File(path);
        ControlDecoration decoration = null;
        String errorMessage = null;
        if (path.isEmpty()) {
            errorMessage = "Invalid location: empty";
        } else if (!dir.exists()) {
            errorMessage = "Invalid location: not exists";
        } else if (!dir.isDirectory()) {
            errorMessage = "Invalid location: is not directory";
        }
        Link nameLink = new Link(parent, 0);
        if (errorMessage != null) {
            decoration = this.createErrorDecoration((Control)nameLink, errorMessage, parent);
            decoration.show();
        } else {
            label = "<a>" + label + "</a>";
        }
        nameLink.setText(label);
        nameLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)path);
            }
        });
        this.createTextField(parent, text);
    }

    private void createTextField(Composite parent, String text) {
        Text valueTextField = new Text(parent, 2058);
        valueTextField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        valueTextField.setText(text);
    }

    private ControlDecoration createErrorDecoration(Control control, String message, Composite parent) {
        ControlDecoration decoration = new ControlDecoration(control, 16512, parent);
        decoration.setDescriptionText(message);
        decoration.setMarginWidth(1);
        decoration.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR").createImage());
        return decoration;
    }
}

