/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageContentProvider;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageLabelProvider;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class SDKTableViewerHolder {
    public static final int[] COLUMN_SIZES = new int[]{50, 150, 70, 150, 300};
    public static final int STATIC_COLUMNS = 3;
    private static final int TABLE_VIEWER_STYLE = 67586;
    private static final SDKSorter SDK_SORTER = new SDKSorter();

    public static CheckboxTableViewer newCheckList(Composite composite) {
        CheckboxTableViewer v = CheckboxTableViewer.newCheckList((Composite)composite, (int)67586);
        v.setContentProvider((IContentProvider)SDKPageContentProvider.getStructuredContentProvider());
        SDKTableViewerHolder.setup(composite, (TableViewer)v, null, null);
        return v;
    }

    public static TableViewer newSelList(Composite composite, IProject prj, Map<String, List<IStatus>> data) {
        TableViewer v = new TableViewer(composite, 268503042);
        v.setContentProvider((IContentProvider)SDKPageContentProvider.getLazyContentProvider(v));
        v.setUseHashlookup(true);
        SDKTableViewerHolder.setup(composite, v, prj, data);
        return v;
    }

    public static TableViewer newList(Composite composite) {
        TableViewer v = new TableViewer(composite, 268503042);
        v.setContentProvider((IContentProvider)SDKPageContentProvider.getLazyContentProvider(v));
        v.setUseHashlookup(true);
        SDKTableViewerHolder.setup(composite, v, null, null);
        return v;
    }

    private static void setup(Composite tableComposite, final TableViewer viewer, IProject prj, Map<String, List<IStatus>> data) {
        SDKTableViewerHolder.setupTable(viewer);
        TableViewerColumn name = new TableViewerColumn(viewer, 0);
        name.getColumn().setText(Messages.SDKTableViewerHolder_name_column_text);
        name.getColumn().setWidth(COLUMN_SIZES[1]);
        name.setLabelProvider(SDKPageLabelProvider.getNameLabelProvider());
        TableViewerColumn version = new TableViewerColumn(viewer, 0);
        version.getColumn().setText(Messages.SDKTableViewerHolder_version_column_text);
        version.getColumn().setWidth(COLUMN_SIZES[2]);
        version.setLabelProvider(SDKPageLabelProvider.getVersionLabelProvider());
        TableViewerColumn status = new TableViewerColumn(viewer, 0);
        status.getColumn().setText(Messages.SDKTableViewerHolder_status_column_text);
        status.getColumn().setWidth(COLUMN_SIZES[3]);
        status.setLabelProvider(SDKPageLabelProvider.getStatusLabelProvider());
        TableViewerColumn[] cols = null;
        if (prj != null) {
            IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)prj).getManagedProject().getConfigurations();
            cols = new TableViewerColumn[cfgs.length];
            int i = 0;
            while (i < cfgs.length) {
                String cname = cfgs[i].getName();
                cols[i] = new TableViewerColumn(viewer, 0);
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)cols[i].getViewer());
                cols[i].getColumn().setText(cname);
                cols[i].getColumn().setToolTipText(cname);
                cols[i].getColumn().setWidth(COLUMN_SIZES[0]);
                cols[i].setLabelProvider(SDKPageLabelProvider.getCfgCellLabelProvider(i, data));
                ++i;
            }
        }
        TableViewerColumn desc = new TableViewerColumn(viewer, 0);
        desc.getColumn().setText(Messages.SDKTableViewerHolder_description_column_text);
        desc.getColumn().setWidth(COLUMN_SIZES[4]);
        desc.setLabelProvider(SDKPageLabelProvider.getDescriptionLabelProvider());
        SelectionAdapter selListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int n = (Integer)event.widget.getData();
                SDK_SORTER.setSortParams(n--);
                viewer.getTable().setSortColumn(viewer.getTable().getColumn(n < 3 ? n : viewer.getTable().getColumnCount() - 1));
                viewer.getTable().setSortDirection(SDK_SORTER.direction == 1 ? 1024 : 128);
                List sdks = (List)viewer.getInput();
                sdks.sort(SDK_SORTER);
                viewer.setInput((Object)sdks);
                viewer.refresh();
            }
        };
        name.getColumn().addSelectionListener((SelectionListener)selListener);
        name.getColumn().setData((Object)new Integer(1));
        version.getColumn().addSelectionListener((SelectionListener)selListener);
        version.getColumn().setData((Object)new Integer(2));
        status.getColumn().addSelectionListener((SelectionListener)selListener);
        status.getColumn().setData((Object)new Integer(3));
        desc.getColumn().addSelectionListener((SelectionListener)selListener);
        desc.getColumn().setData((Object)new Integer(4));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[1]));
        tableLayout.setColumnData((Widget)version.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[2]));
        tableLayout.setColumnData((Widget)status.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[3]));
        if (cols != null) {
            TableViewerColumn[] tableViewerColumnArray = cols;
            int n = cols.length;
            int n2 = 0;
            while (n2 < n) {
                TableViewerColumn col = tableViewerColumnArray[n2];
                tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[0]));
                ++n2;
            }
        }
        tableLayout.setColumnData((Widget)desc.getColumn(), (ColumnLayoutData)new ColumnWeightData(COLUMN_SIZES[4]));
    }

    private static void setupTable(TableViewer viewer) {
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    private static class SDKSorter
    implements Comparator<ISDK> {
        private int column;
        private int direction;

        private SDKSorter() {
        }

        private void setSortParams(int column) {
            if (this.column == column) {
                this.direction = 1 - this.direction;
            } else {
                this.column = column;
                this.direction = 0;
            }
        }

        @Override
        public int compare(ISDK o1, ISDK o2) {
            int result = 0;
            switch (this.column) {
                case 1: {
                    result = o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                    break;
                }
                case 2: {
                    result = o1.getHeader().getVersion().compareTo(o2.getHeader().getVersion());
                    break;
                }
                case 3: {
                    result = o1.getStatus().toString().compareTo(o2.getStatus().toString());
                    break;
                }
                case 4: {
                    result = o1.getDescription().toLowerCase().compareTo(o2.getDescription().toLowerCase());
                }
            }
            return this.direction == 0 ? result : -result;
        }
    }
}

