/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SDKShowDialog
extends TitleAreaDialog {
    private static final int NAME_WIDTH = 150;
    private static final int CFGS_WIDTH = 350;
    private static final int DEFAULT_TABLE_HEIGHT = 150;
    private static final String CONFIGS_DELIMITER = " | ";
    private static final String CONTEXT_HELP_ID = "com.freescale.s32ds.cross.sdk.support.SDK_SHOW_ATTACHED_context";
    private List<ISDK> sdkList;
    private ISDK selectedSdk;
    private ComboViewer comboViewer;
    private Table table;
    private Shell shell;
    private static final Comparator<IProject> NAME_SORTER = new Comparator<IProject>(){

        @Override
        public int compare(IProject o1, IProject o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public SDKShowDialog(Shell parentShell, ISDK selectedSdk) {
        super(parentShell);
        this.selectedSdk = selectedSdk;
        this.loadSDKList();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SDKShowDialog_title);
        this.setMessage(Messages.SDKShowDialog_message_default);
        Composite body = new Composite(content, 0);
        body.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().applyTo((Control)body);
        this.setupCombo(body);
        this.setupTable(body);
        if (this.selectedSdk != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection(this.selectedSdk){});
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)content, CONTEXT_HELP_ID);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.shell = shell;
        this.shell.setText(Messages.SDKShowDialog_title);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 1) {
            return null;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    private void setupCombo(Composite body) {
        Label label = new Label(body, 0);
        label.setText(Messages.SDKShowDialog_SDK);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
        Combo combo = new Combo(body, 12);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)combo);
        this.comboViewer = new ComboViewer(combo);
        this.comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return SDKShowDialog.this.sdkList.toArray();
            }
        });
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ISDK) {
                    ISDK sdk = (ISDK)element;
                    return SDKShowDialog.this.getSdkBriefInfo(sdk);
                }
                return "";
            }
        });
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    SDKShowDialog.this.selectedSdk = (ISDK)sel.getFirstElement();
                }
                SDKShowDialog.this.setMessage(NLS.bind((String)Messages.SDKShowDialog_attached, (Object)SDKShowDialog.this.getSdkBriefInfo(SDKShowDialog.this.selectedSdk)));
                SDKShowDialog.this.update();
            }
        });
        this.comboViewer.setInput(this.sdkList);
        this.comboViewer.refresh();
    }

    private String getSdkBriefInfo(ISDK sdk) {
        return NLS.bind((String)"{0} v {1} ({2})", (Object[])new String[]{sdk.getName(), sdk.getVersion(), sdk.getStatusText()});
    }

    private void loadSDKList() {
        this.sdkList = SDKUtils.filter(SDKUtils.NO_FILTER).stream().filter(s -> ISDK.TYPE.INTERNAL != s.getType()).filter(s -> s instanceof ProjectLocalSDK ? ((ProjectLocalSDK)s).getProject().isAccessible() : true).sorted((sdk1, sdk2) -> {
            if (sdk1.getType() == sdk2.getType()) {
                if (sdk1.getName().equals(sdk2.getName())) {
                    return sdk1.getVersion().compareToIgnoreCase(sdk2.getVersion());
                }
                return sdk1.getName().compareToIgnoreCase(sdk2.getName());
            }
            return sdk1.getType().name().compareTo(sdk2.getType().name());
        }).collect(Collectors.toList());
    }

    private void setColumn(String title, int width) {
        TableColumn tc = new TableColumn(this.table, 16388);
        tc.setText(title);
        tc.setWidth(width);
    }

    private void setupTable(Composite body) {
        this.table = new Table(body, 2052);
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).hint(-1, 150).minSize(-1, 150).grab(true, true).applyTo((Control)this.table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.setColumn(Messages.SDKShowDialog_project, 150);
        this.setColumn(Messages.SDKShowDialog_config, 350);
        this.update();
    }

    private void update() {
        this.table.removeAll();
        if (this.selectedSdk == null) {
            return;
        }
        TreeSet<IProject> projects = new TreeSet<IProject>(NAME_SORTER);
        projects.addAll(SDKUtils.listProjects());
        for (IProject p : projects) {
            String name = p.getName();
            boolean isProjectAttachedToSdk = false;
            StringBuilder sb = new StringBuilder();
            IManagedBuildInfo projectBuildInfo = ManagedBuildManager.getBuildInfo((IResource)p);
            if (projectBuildInfo == null) continue;
            IConfiguration[] iConfigurationArray = projectBuildInfo.getManagedProject().getConfigurations();
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration cfg = iConfigurationArray[n2];
                if (SDKAttach.isAttached(name, cfg.getName(), this.selectedSdk.getId())) {
                    isProjectAttachedToSdk = true;
                    sb.append(cfg.getName()).append(CONFIGS_DELIMITER);
                }
                ++n2;
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - CONFIGS_DELIMITER.length());
            }
            if (!isProjectAttachedToSdk) continue;
            TableItem ti = new TableItem(this.table, 0);
            ti.setText(0, name);
            ti.setText(1, sb.toString());
        }
    }
}

