/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.property.SDKWizardPropertyPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SDKSelectDialog
extends Dialog {
    private final SDKWizardPropertyPage wpp;
    private Object[] selection;
    private final Object[] initial;
    private Label message;

    public SDKSelectDialog(Shell parentShell, ISDKFilterInfo info, Object initial) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initial = this.checkNullAndCastToArray(initial);
        this.wpp = new SDKWizardPropertyPage(info, this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.SDKDialog_select_dialog_title, null));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.message = new Label(composite, 4);
        this.message.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selection = this.checkNullAndCastToArray(this.initial);
        this.wpp.createControl(composite);
        this.wpp.setSelected(this.selection);
        return composite;
    }

    protected void okPressed() {
        this.selection = this.wpp.getSelectedToAttach().toArray();
        this.wpp.cancelSelectedToAttach();
        this.wpp.saveSDKVersionFilterPreference();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.wpp.cancelSelectedToAttach();
        super.cancelPressed();
    }

    public Object[] get() {
        return this.selection;
    }

    private Object[] checkNullAndCastToArray(Object value) {
        return value != null ? (Object[])value : new Object[]{};
    }

    public Button getOK() {
        return this.getButton(0);
    }

    public void setMessage(String msg) {
        this.message.setText(msg);
    }
}

