/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public abstract class SDKPageLabelProvider
extends CellLabelProvider {
    public static CellLabelProvider getNameLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getName());
                }
            }
        };
    }

    public static CellLabelProvider getVersionLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getVersion());
                }
            }
        };
    }

    public static CellLabelProvider getDescriptionLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getDescription());
                }
            }
        };
    }

    public static CellLabelProvider getStatusLabelProvider() {
        return new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    cell.setText(((ISDK)element).getStatusText());
                }
            }
        };
    }

    public static CellLabelProvider getCfgCellLabelProvider(int idx, Map<String, List<IStatus>> data) {
        return new CfgCellLabelProvider(idx, data);
    }

    public static EditingSupport getCfgEditingSupport(ColumnViewer viewer, int num, Map<String, List<IStatus>> data) {
        return new CfgEditingSupport(viewer, num, data);
    }

    private static class CfgCellLabelProvider
    extends CellLabelProvider {
        private static final Map<IStatus, String> IMAGES_MAP = new HashMap<IStatus, String>();
        private final Map<String, List<IStatus>> data;
        private final int idx;

        private CfgCellLabelProvider(int idx, Map<String, List<IStatus>> data) {
            IMAGES_MAP.put(ISDKAttachStatuses.OK_SDK_NOT_ATTACHED, "BLANK_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.OK_SDK_ATTACHED, "PLUS_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_SDK_PROCESSOR_CORE, "CHIP_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_PROJECT_FOLDER_EXIST, "DUPL_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_PROJECT_ROOT_FILE_CONFLICT, "FILE_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_SDK_LANGUAGE, "FONT_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_SDK_TOOLCHAIN, "TOOL_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_SDK_LOCATION, "NONE_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_SDK_PLATFORM, "ERROR_PLATFORM_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_NO_MODULES_TO_ATTACH, "CROSS_ICON");
            IMAGES_MAP.put(ISDKAttachStatuses.ERROR_UNKNOWN, "ERROR_ICON");
            this.idx = idx;
            this.data = data;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof ISDK) {
                ISDK sdk = (ISDK)element;
                List<IStatus> statuses = this.data.get(sdk.getId());
                if (statuses == null) {
                    cell.setImage(this.getImage(ISDKAttachStatuses.OK_SDK_NOT_ATTACHED));
                } else {
                    cell.setImage(this.getImage(statuses.get(this.idx)));
                }
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof ISDK) {
                ISDK sdk = (ISDK)element;
                IStatus status = this.data.get(sdk.getId()).get(this.idx);
                return status.getMessage();
            }
            return element.toString();
        }

        public boolean useNativeToolTip(Object element) {
            return true;
        }

        private Image getImage(IStatus status) {
            return SDKSupportPlugin.getDefault().getImageRegistry().get(IMAGES_MAP.get(status));
        }
    }

    private static class CfgEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor = new CheckboxCellEditor();
        final int number;
        final Map<String, List<IStatus>> data;

        public CfgEditingSupport(ColumnViewer viewer, int num, Map<String, List<IStatus>> map) {
            super(viewer);
            this.number = num;
            this.data = map;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return this.getValue(element);
        }

        protected Boolean getValue(Object element) {
            if (!(element instanceof ISDK)) {
                return false;
            }
            String sdkId = ((ISDK)element).getId();
            List<IStatus> statuses = this.data.get(sdkId);
            if (statuses == null || this.number >= statuses.size()) {
                return false;
            }
            IStatus status = statuses.get(this.number);
            return status != null ? status.isOK() : false;
        }

        protected void setValue(Object element, Object value) {
            if (this.getValue(element).booleanValue()) {
                String sdkId = ((ISDK)element).getId();
                List<IStatus> statuses = this.data.get(sdkId);
                IStatus currentStatus = statuses.get(this.number);
                if (currentStatus == null) {
                    return;
                }
                statuses.set(this.number, this.getChangedAttachStatus(currentStatus));
                this.data.put(sdkId, statuses);
                this.getViewer().refresh();
            }
        }

        private IStatus getChangedAttachStatus(IStatus status) {
            if (status != null) {
                if (status.equals(ISDKAttachStatuses.OK_SDK_ATTACHED)) {
                    return ISDKAttachStatuses.OK_SDK_NOT_ATTACHED;
                }
                if (status.equals(ISDKAttachStatuses.OK_SDK_NOT_ATTACHED)) {
                    return ISDKAttachStatuses.OK_SDK_ATTACHED;
                }
            }
            return status;
        }
    }
}

