/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import java.io.File;
import org.eclipse.cdt.utils.ui.controls.RadioButtonsArea;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SDKImportPathResolveDialog
extends TitleAreaDialog {
    private static final String HELP_CONTEXT = "com.freescale.s32ds.cross.sdk.support.SDK_import_resolve_context";
    private RadioButtonsArea radio;
    private final String standardMessage;
    private final String[][] values;
    private String defaultLocation;
    private String selectedLocation;
    private Text locationText;
    private Label resolvedLocationLabel;
    private Label resolvedLocationPath;
    private SDKHeader sdkHeader;
    private boolean isDefaultLocation;

    public SDKImportPathResolveDialog(Shell parent, String defaultLocation, SDKHeader sdkHeader) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.defaultLocation = defaultLocation;
        this.sdkHeader = sdkHeader;
        this.selectedLocation = defaultLocation;
        this.values = new String[][]{{"Default (SDK folder)", "A"}, {"SDK Base Path", "B"}};
        this.standardMessage = String.format("Select path to SDK %s source files", sdkHeader.getName());
        this.isDefaultLocation = true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SDKDialog_import_dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        return contents;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().hint(500, -1).applyTo((Control)composite);
        this.radio = new RadioButtonsArea(composite, "Select path", 2, this.values);
        GridDataFactory.fillDefaults().grab(true, false).hint(500, -1).span(2, 0).applyTo((Control)this.radio);
        this.radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SDKImportPathResolveDialog.this.isDefaultLocation = SDKImportPathResolveDialog.this.radio.getSeletedIndex() == 0;
                SDKImportPathResolveDialog.this.toggle(SDKImportPathResolveDialog.this.isDefaultLocation);
            }
        });
        this.radio.setSelectedButton(0);
        Label locationLabel = new Label(composite, 0);
        locationLabel.setText("Location:");
        this.locationText = new Text(composite, 18498);
        this.locationText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.locationText.setText(this.defaultLocation);
        this.locationText.setEnabled(false);
        this.setTitle("Select path to SDK source files");
        this.setMessage(this.standardMessage);
        this.resolvedLocationLabel = new Label(composite, 0);
        this.resolvedLocationLabel.setText("Resolved location:");
        this.resolvedLocationLabel.setVisible(false);
        this.resolvedLocationPath = new Label(composite, 64);
        this.resolvedLocationPath.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.resolvedLocationPath.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, HELP_CONTEXT);
        return composite;
    }

    private void toggle(boolean isDefaultLocation) {
        this.selectedLocation = isDefaultLocation ? this.defaultLocation : this.sdkHeader.getBasePath();
        this.locationText.setText(this.selectedLocation);
        this.showResolvedLocation();
    }

    private void showResolvedLocation() {
        this.resolvedLocationLabel.setVisible(false);
        this.resolvedLocationPath.setVisible(false);
        this.setErrorMessage(null);
        if (!this.selectedLocation.isEmpty()) {
            String name = this.sdkHeader.getEnv() == null ? null : this.sdkHeader.getEnv().getName();
            File f = new File(SDKSupportPlugin.performStringSubstitution(this.selectedLocation, name));
            String aPath = f.getAbsolutePath();
            this.getButton(0).setEnabled(f.exists());
            if (!f.exists()) {
                this.setErrorMessage("Path does not exist: " + aPath);
            }
            if (!aPath.equals(this.selectedLocation)) {
                this.resolvedLocationLabel.setVisible(true);
                this.resolvedLocationPath.setText(aPath);
                this.resolvedLocationPath.setVisible(true);
            }
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public String getDefaultLocation() {
        return this.defaultLocation;
    }

    public String getSelectedLocation() {
        return this.selectedLocation;
    }

    public boolean isDefaultLocation() {
        return this.isDefaultLocation;
    }
}

