/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKNameValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKVersionValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SdkTargetFolderNameValidator;
import com.freescale.s32ds.cross.sdk.ui.internal.CustomTreeViewer;
import com.freescale.s32ds.cross.sdk.ui.internal.HeaderFilesTreeViewer;
import com.freescale.s32ds.cross.sdk.ui.internal.LibraryFilesControl;
import com.freescale.s32ds.cross.sdk.ui.internal.LocationEditDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.SymbolsControl;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKEditDialogHandler;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModulesHolder;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbol;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.io.File;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SDKEditDialog
extends TitleAreaDialog {
    public static final String ANY = "<ANY>";
    private static final String EMPTY_PATH = "";
    public static final int NEW = 1;
    public static final int EDIT = 2;
    public static final int VIEW = 3;
    private final int type;
    private static final String[] CONTEXTS = new String[]{"", ".SDK_NEW_context", ".SDK_EDIT_context", ".SDK_VIEW_context"};
    private static final String[] HEADERS = new String[]{"", Messages.SDKDialog_new_dialog_header_text, Messages.SDKDialog_edit_dialog_header_text, Messages.SDKDialog_view_dialog_header_text};
    private static final String[] TITLES = new String[]{"", Messages.SDKDialog_new_dialog_title, Messages.SDKDialog_edit_dialog_title, Messages.SDKDialog_view_dialog_title};
    private static final String NAME_CTX = ".SDK_NAME_context";
    private static final String VERS_CTX = ".SDK_VERS_context";
    private static final String TARGET_FOLDER_NAME_CTX = ".TARGET_FOLDER_NAME_context";
    private static final String DESC_CTX = ".SDK_DESC_context";
    private static final String TABL_CTX = ".SDK_TABLE_context";
    public static final String NEW_VAR_CTX = ".SDK_NEW_VAR_context";
    public static final String SYS_VAR_CTX = ".SDK_SYS_VAR_context";
    public static final String LOC_CTX = ".SDK_LOC_context";
    private static final int DEFAULT = 2052;
    private static final int BUTTON_SIZE = 80;
    private Button okButton;
    private Text sdkNameField;
    private Text sdkVersionField;
    private Text sdkTargetFolderNameField;
    private Text sdkDescField;
    private Text sdkEnvField;
    private Text sdkEnvType;
    private Text sdkPathField;
    private Button changeButton;
    private Group environmentGroup;
    private Label reslovedLocationLabel;
    private Label resolvedLocationText;
    private CustomTreeViewer sdkSourcesTree;
    private HeaderFilesTreeViewer sdkHeadersTree;
    private LibraryFilesControl sdkLibraryFilesControl;
    private CustomTreeViewer sdkOthersTree;
    private CustomTreeViewer sdkLDTree;
    private String[][] heads = CustomTreeViewer.DEFAULT_HEADS;
    private String sdkName;
    private String sdkVersion;
    private String sdkTargetFolderName;
    private String sdkDescription;
    private String oldSdkName;
    private String oldSdkVersion;
    private IFilterOptions sdkFilter;
    private String gitPath = "";
    private String gitBranch = "";
    private IEnvironment sdkEnv;
    private volatile IExtendedPath[][] sdkSources = new IExtendedPath[1][0];
    private volatile IExtendedPath[][] sdkHeaders = new IExtendedPath[1][0];
    private volatile IExtendedPath[][] sdkBinaries = new IExtendedPath[1][0];
    private volatile IExtendedPath[][] sdkOthers = new IExtendedPath[1][0];
    private volatile IExtendedPath[][] sdkLDs = new IExtendedPath[1][0];
    private Map<String, List<IExtendedPath>> sdkIncludedFiles;
    private EnvironmetBackupData sdkEnvBackup;
    private SDKEditDialogHandler handler;
    private IProject project;
    private Map<String, SdkSymbolsHolder> symbolHoldersMap;
    private Map<String, TCHolder> toolChainHolders;
    private TCHolder rootToolChainHolder;
    private SdkModulesHolder modulesHolder;
    private SDKNameValidator nameValidator = new SDKNameValidator();
    private SDKVersionValidator versionValidator = new SDKVersionValidator();
    private SdkTargetFolderNameValidator targetFolderNameValidator = new SdkTargetFolderNameValidator();

    public SDKEditDialog(Shell parentShell, int type, IFilterOptions fo, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.type = type == 1 || type == 2 || type == 3 ? type : 3;
        this.sdkFilter = fo;
        this.handler = new SDKEditDialogHandler(this, project);
        this.project = project;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(TITLES[this.type]);
        shell.setSize(500, 700);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(-1, -1).grab(true, false).applyTo((Control)contents);
        this.setTitle(TITLES[this.type]);
        this.setMessage(HEADERS[this.type]);
        this.createNames(contents);
        this.createEnv(contents);
        this.createTabs(parentComposite);
        this.fillEnvData(this.type == 1);
        String value = this.sdkEnv != null ? this.sdkEnv.getValue() : EMPTY_PATH;
        this.sdkEnvBackup = new EnvironmetBackupData(this.sdkEnv, value);
        Dialog.applyDialogFont((Control)parentComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.freescale.s32ds.cross.sdk.support" + CONTEXTS[this.type]);
        return contents;
    }

    protected void okPressed() {
        if (this.type != 3) {
            this.sdkSources = new IExtendedPath[1][0];
            this.sdkSources[0] = this.sdkSourcesTree.getChecked();
            this.sdkHeaders = new IExtendedPath[1][0];
            this.sdkHeaders[0] = this.sdkHeadersTree.getChecked();
            this.sdkBinaries = new IExtendedPath[1][0];
            this.sdkBinaries[0] = this.sdkLibraryFilesControl.getChecked();
            this.sdkOthers = new IExtendedPath[1][0];
            this.sdkOthers[0] = this.sdkOthersTree.getChecked();
            this.sdkLDs = new IExtendedPath[1][0];
            this.sdkLDs[0] = this.sdkLDTree.getChecked();
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.rollbackEnvironmentChanges();
        super.cancelPressed();
    }

    protected void handleShellCloseEvent() {
        this.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    private void createNames(Composite contents) {
        this.sdkNameField = this.fieldWithLabel(contents, Messages.SDKDialog_name_label_text, this.getSDKName(), 2052, Id.NAME, NAME_CTX);
        this.sdkVersionField = this.fieldWithLabel(contents, Messages.SDKDialog_version_label_text, this.getSDKVersion(), 2052, Id.VERSION, VERS_CTX);
        this.sdkTargetFolderNameField = this.fieldWithLabel(contents, Messages.SDKDialog_target_folder_name_label_text, this.getSdkTargetFolderName(), 2052, Id.TARGET_FOLDER_NAME, TARGET_FOLDER_NAME_CTX);
        this.sdkDescField = this.fieldWithLabel(contents, Messages.SDKDialog_description_label_text, this.getSDKDescription(), 2116, Id.DESCRIPTION, DESC_CTX);
    }

    private void createEnv(Composite contents) {
        String envName = this.sdkEnv != null ? this.sdkEnv.getName() : EMPTY_PATH;
        this.environmentGroup = new Group(contents, 0);
        this.environmentGroup.setText(Messages.SDKDialog_env_variable_group_text);
        this.environmentGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.environmentGroup.setLayout((Layout)new GridLayout(3, false));
        this.sdkEnvField = this.fieldReadOnly((Composite)this.environmentGroup, Messages.SDKEditDialog_Variable, envName, 2052, NEW_VAR_CTX);
        this.sdkEnvType = this.fieldReadOnly((Composite)this.environmentGroup, null, EMPTY_PATH, 2052, NEW_VAR_CTX);
        this.sdkPathField = this.fieldReadOnly((Composite)this.environmentGroup, Messages.SDKDialog_location_label_text, this.getSDKPath(), 18498, LOC_CTX);
        this.sdkEnvType.setEnabled(false);
        File path = new File(SDKSupportPlugin.performStringSubstitution(this.getSDKPath(), this.getSDKName()));
        if (!path.exists()) {
            this.setMessage(String.valueOf(Messages.SDKDialog_path_not_exists_error_text) + path, 2);
        }
        this.changeButton = new Button((Composite)this.environmentGroup, 8);
        this.changeButton.setText(Messages.SDKEditDialog_Change);
        GridDataFactory.fillDefaults().hint(80, -1).align(131072, 0x1000000).applyTo((Control)this.changeButton);
        this.changeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String def = SDKEditDialog.this.sdkEnv != null && SDKEditDialog.this.sdkEnv.isSystem() ? SDKSupportPlugin.getEnvironment(SDKEditDialog.emptyIfNull(SDKEditDialog.this.sdkName), SDKEditDialog.emptyIfNull(SDKEditDialog.this.sdkVersion)).getName() : SDKEditDialog.this.sdkEnvField.getText();
                LocationEditDialog led = new LocationEditDialog(SDKEditDialog.this.getShell(), SDKEditDialog.this.sdkEnv, def, SDKEditDialog.this.sdkDescField.getText(), SDKEditDialog.this.project);
                if (led.open() == 0) {
                    SDKEditDialog.this.sdkEnv = led.getEnv();
                    if (led.isSDKLocationChanged()) {
                        SDKEditDialog.this.clearSelectedComponentsOnChangeSDKLocation();
                    }
                    SDKEditDialog.this.fillEnvData(!SDKEditDialog.this.sdkEnvField.getText().equals(SDKEditDialog.this.sdkEnv.getValue()));
                }
            }
        });
        this.setButtonLayoutData(this.changeButton);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.changeButton, "com.freescale.s32ds.cross.sdk.support.SDK_LOC_context");
    }

    private void createTabs(Composite contents) {
        TabFolder filesComposite = new TabFolder(contents, 0);
        filesComposite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.sdkSourcesTree = this.setupViewer(filesComposite, Messages.SDKDialog_sources_label_text, SDKSupportPlugin.sourcesMatcher, this.type != 3, false, this.getSourcePaths(), "S", this.heads);
        this.sdkHeadersTree = this.setupHeaderFilesViewer(filesComposite, Messages.SDKDialog_headers_label_text, this.type != 3, this.getHeaderPaths(), this.sdkIncludedFiles);
        this.sdkLibraryFilesControl = this.setupLibraryFilesControl(filesComposite, Messages.SDKDialog_binaries_label_text, this.type != 3, false, this.getBinaryPaths(), this.heads);
        this.sdkOthersTree = this.setupViewer(filesComposite, Messages.SDKDialog_others_label_text, SDKSupportPlugin.othersMatcher, this.type != 3, false, this.getOtherPaths(), "O", this.heads);
        this.sdkLDTree = this.setupViewer(filesComposite, Messages.SDKEditDialog_linker_ld_files, SDKSupportPlugin.ldMatcher, this.type != 3, false, this.getLDPaths(), "L", this.heads);
        new SymbolsTab().create(filesComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)filesComposite, "com.freescale.s32ds.cross.sdk.support.SDK_TABLE_context");
    }

    private HeaderFilesTreeViewer setupHeaderFilesViewer(TabFolder parent, String label, boolean isEditable, IExtendedPath[][] paths, Map<String, List<IExtendedPath>> includedFiles) {
        TabItem item = this.createPathsControlTabItem(parent, label);
        Composite holder = (Composite)item.getControl();
        HeaderFilesTreeViewer viewer = new HeaderFilesTreeViewer(holder, isEditable, this.heads, this.rootToolChainHolder);
        if (this.sdkPathField.getText() != null) {
            viewer.setIncludedFiles(includedFiles);
        }
        this.setViewerInput(viewer, paths, isEditable);
        return viewer;
    }

    private LibraryFilesControl setupLibraryFilesControl(TabFolder parent, String label, boolean isEditable, boolean isSelectSiblings, IExtendedPath[][] paths, String[][] heads) {
        TabItem item = this.createPathsControlTabItem(parent, label);
        Composite holder = (Composite)item.getControl();
        LibraryFilesControl viewer = new LibraryFilesControl(holder, isEditable, isSelectSiblings, heads);
        this.setViewerInput(viewer, paths, isEditable);
        return viewer;
    }

    private CustomTreeViewer setupViewer(TabFolder parent, String label, PathMatcher matcher, boolean isEditable, boolean selectSiblings, IExtendedPath[][] paths, String suffix, String[][] heads) {
        TabItem item = this.createPathsControlTabItem(parent, label);
        Composite holder = (Composite)item.getControl();
        CustomTreeViewer viewer = new CustomTreeViewer(holder, matcher, isEditable, selectSiblings, suffix, heads);
        this.setViewerInput(viewer, paths, isEditable);
        return viewer;
    }

    private TabItem createPathsControlTabItem(TabFolder parent, String label) {
        TabItem item = new TabItem(parent, 0);
        item.setText(label);
        Composite group = new Composite((Composite)parent, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        item.setControl((Control)group);
        return item;
    }

    private void setViewerInput(CustomTreeViewer viewer, IExtendedPath[][] paths, boolean isEditable) {
        String rootPath = this.sdkPathField.getText();
        if (rootPath == null) {
            return;
        }
        if (isEditable) {
            viewer.setInput(this.getInputWrapper(rootPath), paths[0], false);
        } else {
            this.setViewerInput(viewer, rootPath, paths, false);
        }
    }

    private void setViewerInput(CustomTreeViewer viewer, String rootPath, IExtendedPath[][] paths, boolean expand) {
        if (rootPath == null) {
            return;
        }
        viewer.setInput(this.getInputWrapper(rootPath), paths, expand);
    }

    private CustomTreeViewer.InputWrapper getInputWrapper(String rootPath) {
        CustomTreeViewer.SdkDataHolder sdkDataHolder = new CustomTreeViewer.SdkDataHolder();
        sdkDataHolder.setRootPath(rootPath);
        if (this.modulesHolder != null) {
            sdkDataHolder.setModulesHolder(this.modulesHolder);
        }
        return CustomTreeViewer.wrap(sdkDataHolder);
    }

    private Text fieldOnly(Composite parent, String fieldText, int fieldStyle, Id validationId, GridData fieldLayoutData, String context) {
        int readOnlyStyle = this.type != 3 ? 0 : 8;
        Text field = new Text(parent, fieldStyle | readOnlyStyle);
        field.setText(fieldText);
        field.setLayoutData((Object)(fieldLayoutData != null ? fieldLayoutData : new GridData(4, 0x1000000, true, false, 2, 1)));
        field.addModifyListener((ModifyListener)new ValidatingModificationListener(validationId));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)field, "com.freescale.s32ds.cross.sdk.support" + context);
        return field;
    }

    private Text fieldReadOnly(Composite parent, String labelText, String fieldText, int fieldStyle, String context) {
        if (labelText != null) {
            Label label = new Label(parent, 16384);
            label.setText(labelText);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        }
        return this.fieldOnly(parent, fieldText, fieldStyle | 8, null, new GridData(4, 0x1000000, labelText != null, false), context);
    }

    private Text fieldWithLabel(Composite parent, String labelText, String fieldText, int fieldStyle, Id validationId, String context) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return this.fieldOnly(parent, fieldText, fieldStyle, validationId, null, context);
    }

    private boolean validate() {
        this.setErrorMessage(null);
        boolean isOk = true;
        IStatus status = this.nameValidator.validate(this.sdkName);
        if (status.isOK()) {
            status = this.versionValidator.validate(this.sdkVersion);
        }
        if (!status.isOK()) {
            isOk = false;
            this.setErrorMessage(status.getMessage());
        }
        if (!(!isOk || this.type != 1 && (this.type != 2 || this.sdkName.equals(this.oldSdkName) && this.sdkVersion.equals(this.oldSdkVersion)))) {
            isOk &= this.handler.validateExists(this.sdkName, this.sdkVersion);
        }
        boolean isNameVersionValid = isOk;
        String envName = this.sdkEnvField.getText();
        if (isOk && !(status = this.targetFolderNameValidator.validate(this.sdkTargetFolderName)).isOK()) {
            isOk = false;
            this.setErrorMessage(status.getMessage());
        }
        if (isOk) {
            isOk &= this.handler.validateEnvText(envName);
        }
        if (isOk) {
            isOk &= this.handler.validateEnv(envName, this.sdkEnv != null ? this.sdkEnv.isSystem() : false);
        }
        String location = this.sdkPathField.getText();
        if (isOk) {
            isOk &= this.handler.validatePathText(location);
        }
        if (isOk) {
            isOk &= this.handler.validatePath(location, envName, true);
        }
        if (isOk) {
            this.setErrorMessage(null);
            this.setMessage(HEADERS[this.type]);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(isOk);
        }
        if (this.changeButton != null) {
            this.changeButton.setEnabled(isNameVersionValid && this.type != 3);
        }
        this.showResolvedLocation(this.getErrorMessage() == null);
        return isOk;
    }

    private static String emptyIfNull(String s) {
        return s != null ? s : EMPTY_PATH;
    }

    public String getSDKName() {
        return SDKEditDialog.emptyIfNull(this.sdkName);
    }

    private void setSDKName(String sdkName) {
        this.oldSdkName = sdkName;
        this.sdkName = sdkName;
    }

    private String getSDKVersion() {
        return SDKEditDialog.emptyIfNull(this.sdkVersion).trim();
    }

    private void setSDKVersion(String sdkVersion) {
        this.oldSdkVersion = sdkVersion;
        this.sdkVersion = sdkVersion;
    }

    public String getSdkTargetFolderName() {
        return SDKEditDialog.emptyIfNull(this.sdkTargetFolderName);
    }

    private void setSdkTargetFolderName(String sdkTargetFolderName) {
        this.sdkTargetFolderName = sdkTargetFolderName;
    }

    public String getSDKDescription() {
        return SDKEditDialog.emptyIfNull(this.sdkDescription);
    }

    private void setSDKDescription(String sdkDescription) {
        this.sdkDescription = sdkDescription;
    }

    public String getSDKPath() {
        return this.sdkEnv == null ? EMPTY_PATH : SDKEditDialog.emptyIfNull(this.sdkEnv.getValue());
    }

    public String getGitPath() {
        return SDKEditDialog.emptyIfNull(this.gitPath);
    }

    public void setGitPath(String path) {
        this.gitPath = path;
    }

    public String getGitBranch() {
        return SDKEditDialog.emptyIfNull(this.gitBranch);
    }

    public void setGitBranch(String b) {
        this.gitBranch = b;
    }

    public IEnvironment getSDKEnv() {
        return this.sdkEnv;
    }

    private void setSdkEnvironment(IEnvironment sdkEnv) {
        this.sdkEnv = sdkEnv;
    }

    public IFilterOptions getFilter() {
        return this.sdkFilter == null ? FilterOptions.EMPTY_FILTER : this.sdkFilter;
    }

    public void setFilter(IFilterOptions filter) {
        this.sdkFilter = filter;
    }

    public IExtendedPath[][] getSourcePaths() {
        return this.sdkSources;
    }

    public void setSourcePaths(IExtendedPath[][] sources) {
        this.sdkSources = this.copy(sources);
    }

    public void setHeaderPaths(IExtendedPath[][] headers) {
        this.sdkHeaders = this.copy(headers);
    }

    public IExtendedPath[][] getHeaderPaths() {
        return this.sdkHeaders;
    }

    public Map<String, List<IExtendedPath>> getIncludedFiles() {
        return this.sdkHeadersTree != null ? this.sdkHeadersTree.getIncludeFiles() : Collections.emptyMap();
    }

    public void setIncludedFiles(Map<String, List<IExtendedPath>> includeFiles) {
        this.sdkIncludedFiles = includeFiles;
    }

    public IExtendedPath[][] getBinaryPaths() {
        return this.sdkBinaries;
    }

    public void setBinaryPaths(IExtendedPath[][] binaries) {
        this.sdkBinaries = this.copy(binaries);
    }

    public IExtendedPath[][] getOtherPaths() {
        return this.sdkOthers;
    }

    public IExtendedPath[][] getLDPaths() {
        return this.sdkLDs;
    }

    public void setOtherPaths(IExtendedPath[][] others) {
        this.sdkOthers = this.copy(others);
    }

    public void setLDPaths(IExtendedPath[][] lds) {
        this.sdkLDs = this.copy(lds);
    }

    public Map<String, SdkSymbolsHolder> getSymbolHolders() {
        return this.symbolHoldersMap != null ? this.symbolHoldersMap : Collections.emptyMap();
    }

    public void setSymbolHolders(Map<String, SdkSymbolsHolder> symbolHolders) {
        this.symbolHoldersMap = symbolHolders;
    }

    public void setToolChainHolders(TCHolder[] toolChainHolders) {
        this.toolChainHolders = new LinkedHashMap<String, TCHolder>();
        if (toolChainHolders == null) {
            return;
        }
        Arrays.stream(toolChainHolders).forEach(tch -> {
            TCHolder tCHolder = this.toolChainHolders.put(tch.getTCId(), (TCHolder)tch);
        });
    }

    public void setRootToolchainHolder(TCHolder rootToolChainHolder) {
        this.rootToolChainHolder = rootToolChainHolder;
    }

    public void setHeads(String[] heads, String[] ids) {
        this.heads = new String[2][];
        this.heads[0] = heads;
        this.heads[1] = ids;
    }

    public void setSdkHeaderParameters(SDKHeader.SdkHeaderParameters parameters) {
        this.setSDKName(parameters.getName());
        this.setSDKVersion(parameters.getVersion());
        this.setSDKDescription(parameters.getDescription());
        this.setSdkTargetFolderName(parameters.getTargetFolderName());
        this.setSdkEnvironment(parameters.getEnvironment());
    }

    public SDKHeader.SdkHeaderParameters getSdkHeaderParameters() {
        SDKHeader.SdkHeaderParameters parameters = SDKHeader.newSdkHeaderParameters();
        parameters.setName(this.getSDKName());
        parameters.setVersion(this.getSDKVersion());
        parameters.setDescription(this.getSDKDescription());
        parameters.setTargetFolderName(this.getSdkTargetFolderName());
        parameters.setSdkPath(this.getSDKPath());
        return parameters;
    }

    public void setModulesHolder(SdkModulesHolder modulesHolder) {
        this.modulesHolder = modulesHolder;
    }

    private IExtendedPath[][] copy(IExtendedPath[][] src) {
        IExtendedPath[][] res = new IExtendedPath[src.length][0];
        int i = 0;
        while (i < src.length) {
            res[i] = new IExtendedPath[src[i].length];
            System.arraycopy(src[i], 0, res[i], 0, src[i].length);
            ++i;
        }
        return res;
    }

    private void fillEnvData(boolean update) {
        if (this.sdkEnv != null) {
            this.sdkEnvField.setText(this.sdkEnv.getName());
            this.sdkEnvType.setText(this.sdkEnv.isSystem() ? Messages.SDKEditDialog_system : Messages.SDKEditDialog_users);
            this.sdkPathField.setText(this.sdkEnv.getValue());
            boolean expand = false;
            String sdkPath = this.sdkPathField.getText();
            if (update) {
                ExtendedPath.setSilentMode(true);
                this.setViewerInput(this.sdkSourcesTree, sdkPath, new IExtendedPath[1][0], expand);
                this.setViewerInput(this.sdkHeadersTree, sdkPath, new IExtendedPath[1][0], expand);
                this.setViewerInput(this.sdkLibraryFilesControl, sdkPath, new IExtendedPath[1][0], expand);
                this.setViewerInput(this.sdkOthersTree, sdkPath, new IExtendedPath[1][0], expand);
                this.setViewerInput(this.sdkLDTree, sdkPath, new IExtendedPath[1][0], expand);
                ExtendedPath.setSilentMode(false);
            }
        } else {
            this.sdkEnvField.setText(EMPTY_PATH);
            this.sdkEnvType.setText(Messages.SDKEditDialog_not_set);
            this.sdkPathField.setText(EMPTY_PATH);
            this.clearSelectedComponentsOnChangeSDKLocation();
        }
    }

    private void clearSelectedComponentsOnChangeSDKLocation() {
        this.sdkSourcesTree.clearSelected();
        this.sdkLibraryFilesControl.clearSelected();
        this.sdkHeadersTree.clearSelected();
        this.sdkLDTree.clearSelected();
        this.sdkOthersTree.clearSelected();
    }

    private void rollbackEnvironmentChanges() {
        switch (this.type) {
            case 1: {
                SDKUtils.removeSDKEnv(this.sdkEnv);
                break;
            }
            case 2: {
                if (this.sdkEnvBackup == null || !this.sdkEnvBackup.isValid() || this.sdkEnv == null || !this.sdkEnvBackup.hasChanged(this.sdkEnv)) break;
                SDKUtils.removeSDKEnv(this.sdkEnv);
                this.sdkEnv = SDKSupportPlugin.createEnvironment(this.sdkEnvBackup.name, this.sdkEnvBackup.isSystem, false, this.sdkEnvBackup.value, EMPTY_PATH);
            }
        }
    }

    private void showResolvedLocation(boolean isShow) {
        String pathVariable;
        if (this.reslovedLocationLabel != null && !this.reslovedLocationLabel.isDisposed()) {
            this.reslovedLocationLabel.dispose();
        }
        if (this.resolvedLocationText != null && !this.resolvedLocationText.isDisposed()) {
            this.resolvedLocationText.dispose();
        }
        String name = EMPTY_PATH;
        if (this.sdkEnv != null && this.sdkEnv.getName() != null) {
            name = this.sdkEnv.getName();
        }
        if (!(pathVariable = SDKSupportPlugin.performStringSubstitution(this.getSDKPath(), name)).isEmpty()) {
            String aPath = new File(pathVariable).getAbsolutePath();
            if (isShow && !this.getSDKPath().isEmpty() && !aPath.equals(this.getSDKPath())) {
                this.reslovedLocationLabel = new Label((Composite)this.environmentGroup, 0);
                this.reslovedLocationLabel.setText(Messages.SDKDialog_resolved_location_label);
                this.resolvedLocationText = new Label((Composite)this.environmentGroup, 64);
                this.resolvedLocationText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                this.resolvedLocationText.setText(aPath);
            }
            this.environmentGroup.requestLayout();
        }
    }

    private class EnvironmetBackupData {
        private final String name;
        private final boolean isSystem;
        private final String value;

        private EnvironmetBackupData(IEnvironment env, String envValue) {
            this.name = env != null ? env.getName() : SDKEditDialog.EMPTY_PATH;
            this.isSystem = env != null ? env.isSystem() : false;
            this.value = envValue;
        }

        private boolean hasChanged(IEnvironment env) {
            return !env.getName().equals(this.name) || env.isSystem() != this.isSystem || !env.getValue().equals(this.value);
        }

        private boolean isValid() {
            return !this.name.isEmpty() && !this.value.isEmpty();
        }
    }

    static enum Id {
        NAME,
        VERSION,
        DESCRIPTION,
        TARGET_FOLDER_NAME;

    }

    class SymbolsHolderWrapper {
        private SdkSymbolsHolder holder;
        private TCHolder toolChainHolder;
        private boolean isRoot = false;

        SymbolsHolderWrapper() {
            this.holder = new SdkSymbolsHolder(SDKEditDialog.this.rootToolChainHolder.getTCId());
            this.toolChainHolder = SDKEditDialog.this.rootToolChainHolder;
            this.isRoot = true;
        }

        SymbolsHolderWrapper(SdkSymbolsHolder holder, TCHolder toolChainHolder, boolean isRoot) {
            this.holder = holder;
            this.toolChainHolder = toolChainHolder;
            this.isRoot = isRoot;
        }

        List<SdkSymbol> getSymbolsByType(SdkSymbolTypes type) {
            return this.holder.getSymbolsByType(type);
        }

        SdkSymbolsHolder getHolder() {
            return this.holder;
        }

        TCHolder getToolChainHolder() {
            return this.toolChainHolder != null ? this.toolChainHolder : SDKEditDialog.this.rootToolChainHolder;
        }

        boolean isRoot() {
            return this.isRoot;
        }
    }

    private class SymbolsTab {
        private SymbolsTab() {
        }

        private void create(TabFolder parent) {
            TabItem item = new TabItem(parent, 0);
            item.setText(Messages.SDKEditDialog_symbols_tab_label);
            Composite group = new Composite((Composite)parent, 0);
            group.setLayout((Layout)new GridLayout(1, true));
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            Map<String, SymbolsHolderWrapper> symbolsHoldersWrapper = this.wrapSymbolHoldersMap();
            new SymbolsControl(group, SDKEditDialog.this.type != 3, symbolsHoldersWrapper);
            item.setControl((Control)group);
        }

        private Map<String, SymbolsHolderWrapper> wrapSymbolHoldersMap() {
            if (SDKEditDialog.this.symbolHoldersMap == null) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, SymbolsHolderWrapper> result = new LinkedHashMap<String, SymbolsHolderWrapper>();
            for (Map.Entry e : SDKEditDialog.this.symbolHoldersMap.entrySet()) {
                String toolChainId = (String)e.getKey();
                TCHolder toolChainHolder = (TCHolder)SDKEditDialog.this.toolChainHolders.get(toolChainId);
                if (toolChainHolder == null) {
                    result.put(toolChainId, new SymbolsHolderWrapper((SdkSymbolsHolder)e.getValue(), SDKEditDialog.this.rootToolChainHolder, true));
                    continue;
                }
                result.put(toolChainId, new SymbolsHolderWrapper((SdkSymbolsHolder)e.getValue(), (TCHolder)SDKEditDialog.this.toolChainHolders.get(toolChainId), false));
            }
            return result;
        }
    }

    final class ValidatingModificationListener
    implements ModifyListener {
        private final Id fieldId;

        public ValidatingModificationListener(Id fieldId) {
            this.fieldId = fieldId;
        }

        public void modifyText(ModifyEvent e) {
            if (this.fieldId != null) {
                this.modifyField();
            }
            if (SDKEditDialog.this.validate()) {
                this.reCreateVariable();
            }
        }

        private void modifyField() {
            switch (this.fieldId) {
                case NAME: {
                    SDKEditDialog.this.sdkName = SDKEditDialog.this.sdkNameField.getText().trim();
                    this.updateEnvName();
                    break;
                }
                case VERSION: {
                    SDKEditDialog.this.sdkVersion = SDKEditDialog.this.sdkVersionField.getText().trim();
                    this.updateEnvName();
                    break;
                }
                case TARGET_FOLDER_NAME: {
                    SDKEditDialog.this.sdkTargetFolderName = SDKEditDialog.this.sdkTargetFolderNameField.getText().trim();
                    break;
                }
                case DESCRIPTION: {
                    SDKEditDialog.this.sdkDescription = SDKEditDialog.this.sdkDescField.getText();
                }
            }
        }

        private void updateEnvName() {
            if (SDKEditDialog.this.sdkEnv == null || !SDKEditDialog.this.sdkEnv.isSystem()) {
                SDKEditDialog.this.sdkEnvField.setText(SDKSupportPlugin.getEnvironment(SDKEditDialog.emptyIfNull(SDKEditDialog.this.sdkName), SDKEditDialog.emptyIfNull(SDKEditDialog.this.sdkVersion)).getName());
            }
        }

        private void reCreateVariable() {
            if (SDKEditDialog.this.sdkEnv != null && !SDKEditDialog.this.sdkEnv.isSystem()) {
                String location = SDKEditDialog.this.sdkEnv.getValue();
                SDKUtils.removeSDKEnv(SDKEditDialog.this.sdkEnv);
                SDKEditDialog.this.sdkEnv = SDKSupportPlugin.createEnvironment(SDKEditDialog.this.sdkEnvField.getText(), false, false, location, SDKEditDialog.emptyIfNull(SDKEditDialog.this.sdkDescription));
            }
        }
    }
}

