/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.ConflictedFilesTreeViewer;
import com.freescale.s32ds.cross.sdk.ui.internal.CustomTreeViewer;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SDKConflictedFilesDialog
extends TitleAreaDialog {
    private static final String HELP_CONTEXT_ID = "com.freescale.s32ds.cross.sdk.support.SDK_conflicted_files_context";
    private ISDK sdk;
    private IProject project;
    private Map<String, Set<IExtendedPath>> conflictedFiles;
    private Map<String, Set<IExtendedPath>> filesToOverride;
    private boolean isBackupFiles;
    private ConflictedFilesTreeViewer tree;

    public SDKConflictedFilesDialog(Shell parentShell, ISDK sdk, IProject project, Map<String, Set<IExtendedPath>> conflictedFiles) {
        super(parentShell);
        this.sdk = Objects.requireNonNull(sdk, "SDK must not be null");
        this.project = Objects.requireNonNull(project, "Project must not be null");
        this.conflictedFiles = Objects.requireNonNull(conflictedFiles);
        this.filesToOverride = new HashMap<String, Set<IExtendedPath>>();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SDKConflictedFilesDialog_text);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        this.setupViewer(contents, "Conflicted files:", this.createPathMatcher());
        return contents;
    }

    private PathMatcher createPathMatcher() {
        StringBuilder sb = new StringBuilder("{");
        this.conflictedFiles.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).forEach(p -> {
            StringBuilder stringBuilder2 = sb.append(p.toPortableString()).append(',');
        });
        sb.append("}");
        return FileSystems.getDefault().getPathMatcher("glob:" + sb.toString());
    }

    private Composite createComposite(Composite parentComposite) {
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayout((Layout)new GridLayout(3, false));
        GridData data = new GridData(1808);
        data.widthHint = 500;
        data.heightHint = 600;
        contents.setLayoutData((Object)data);
        this.setTitle(Messages.SDKConflictedFilesDialog_message_title);
        this.setMessage(String.format(Messages.SDKConflictedFilesDialog_message_head, this.project.getName()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)contents, HELP_CONTEXT_ID);
        return contents;
    }

    private CustomTreeViewer setupViewer(Composite parent, String label, PathMatcher matcher) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        String rootPath = this.sdk.getEnv().getValue();
        if (rootPath != null) {
            CustomTreeViewer.SdkDataHolder sdkDataHolder = new CustomTreeViewer.SdkDataHolder();
            sdkDataHolder.setRootPath(rootPath);
            sdkDataHolder.setModulesHolder(this.sdk.getModules());
            this.tree = new ConflictedFilesTreeViewer(group, matcher);
            this.tree.setConflictedFiles(this.conflictedFiles);
            this.tree.setInput(CustomTreeViewer.wrap(sdkDataHolder), this.conflictedFiles.entrySet().stream().flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet()), true);
        }
        return this.tree;
    }

    public Map<String, Set<IExtendedPath>> getFilesToOverride() {
        return this.filesToOverride;
    }

    public boolean isBackupFiles() {
        return this.isBackupFiles;
    }

    protected void okPressed() {
        IExtendedPath[] iExtendedPathArray = this.tree.getChecked();
        int n = iExtendedPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath ep = iExtendedPathArray[n2];
            this.conflictedFiles.entrySet().stream().filter(e -> ((Set)e.getValue()).contains(ep)).map(Map.Entry::getKey).forEach(sdkId -> {
                boolean bl = this.filesToOverride.computeIfAbsent((String)sdkId, s -> new LinkedHashSet()).add(ep);
            });
            ++n2;
        }
        this.isBackupFiles = this.tree.isBackupFiles();
        super.okPressed();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        MessageDialog.openWarning((Shell)this.getShell(), (String)"Warning", (String)String.format(Messages.SDKAttach_Not_attached_to_prj, this.sdk.getId(), this.project.getName()));
    }
}

