/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageContentProvider;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKPageLabelProvider;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SDKAttachConfigurationsDialog
extends TitleAreaDialog {
    private static final int MAX_VISIBLE_ROWS_NUMBER = 5;
    private final List<ISDK> selectedSDKs;
    private final IProject project;
    private final Map<String, List<IStatus>> selectedConfigs;
    private Shell shell;
    private TableViewer tableViewer;

    public SDKAttachConfigurationsDialog(Shell parentShell, List<ISDK> selectedSDKs, IProject project, Map<String, List<IStatus>> selectedConfigs) {
        super(parentShell);
        this.selectedSDKs = selectedSDKs;
        this.project = project;
        this.selectedConfigs = selectedConfigs;
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.SDKAttachConfigurationsDialog_text);
        this.setMessage(Messages.SDKAttachConfigurationsDialog_message);
        Composite body = new Composite(content, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().applyTo((Control)body);
        this.tableViewer = new TableViewer(body, 68096);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.setupTable(body);
        GridData data = new GridData(4, 4, true, false);
        data.heightHint = 7 * this.tableViewer.getTable().getItemHeight();
        body.setLayoutData((Object)data);
        this.setHelpAvailable(false);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.shell = shell;
        this.shell.setText(Messages.SDKAttachConfigurationsDialog_title);
    }

    private void setupTable(Composite body) {
        TableViewerColumn name = new TableViewerColumn(this.tableViewer, 0);
        name.getColumn().setText(Messages.SDKAttachConfigurationsDialog_name_column_title);
        name.getColumn().setWidth(150);
        name.setLabelProvider((CellLabelProvider)new SDKPageLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof ISDK) {
                    ISDK sdk = (ISDK)element;
                    cell.setText(NLS.bind((String)"{0} v {1} ({2})", (Object[])new String[]{sdk.getName(), sdk.getVersion(), sdk.getStatusText()}));
                }
            }
        });
        TableViewerColumn[] cols = null;
        if (this.project != null) {
            IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)this.project).getManagedProject().getConfigurations();
            cols = new TableViewerColumn[cfgs.length];
            int i = 0;
            while (i < cfgs.length) {
                String cname = cfgs[i].getName();
                cols[i] = new TableViewerColumn(this.tableViewer, 0);
                cols[i].getColumn().setText(cname);
                cols[i].getColumn().setToolTipText(cname);
                cols[i].getColumn().setWidth(50);
                cols[i].setLabelProvider(SDKPageLabelProvider.getCfgCellLabelProvider(i, this.selectedConfigs));
                cols[i].setEditingSupport(SDKPageLabelProvider.getCfgEditingSupport((ColumnViewer)this.tableViewer, i, this.selectedConfigs));
                ++i;
            }
        }
        TableColumnLayout tableLayout = new TableColumnLayout();
        body.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)name.getColumn(), (ColumnLayoutData)new ColumnWeightData(150));
        if (cols != null) {
            TableViewerColumn[] tableViewerColumnArray = cols;
            int n = cols.length;
            int n2 = 0;
            while (n2 < n) {
                TableViewerColumn col = tableViewerColumnArray[n2];
                tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(50));
                ++n2;
            }
        }
        this.tableViewer.setContentProvider((IContentProvider)SDKPageContentProvider.getStructuredContentProvider());
        this.tableViewer.setInput(this.selectedSDKs);
    }
}

