/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.ui.internal.handler.SDKEditDialogHandler;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class LocationEditDialog
extends TitleAreaDialog {
    private static final String DIR_KEY = "SDK_DIR_KEY";
    private static final String ASK_KEY = "SDK_ASK_KEY";
    private static final Point HINT = new Point(300, 250);
    private static final int MAX_FILES = 1000;
    private static final int STATE_LOC = 18506;
    private IEnvironment env;
    private int counter = 0;
    private final String defaultName;
    private final String defaultDesc;
    private ILocationGroup userLocationGroup;
    private ILocationGroup systemLocationGroup;
    private Button okButton;
    private boolean isSystemEnvMode;
    private boolean isSDKLocationChanged;
    private SDKEditDialogHandler handler;

    LocationEditDialog(Shell parentShell, IEnvironment env, String name, String desc, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.env = env;
        this.defaultName = name == null ? "" : name.trim();
        this.defaultDesc = desc == null ? this.defaultName : desc;
        this.handler = new SDKEditDialogHandler(this, project);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.LocationEditDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = new Composite(parentComposite, 0);
        GridDataFactory.fillDefaults().hint(HINT).applyTo((Control)contents);
        this.setTitle(Messages.LocationEditDialog_location_title);
        contents.setLayout((Layout)new GridLayout());
        this.createWidgets(contents);
        Dialog.applyDialogFont((Control)parentComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), ".SDK_LOC_context");
        return contents;
    }

    public int getCounter() {
        return this.counter;
    }

    public IEnvironment getEnv() {
        return this.env;
    }

    private void createWidgets(Composite contents) {
        Group group = new Group(contents, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(4, false));
        this.userLocationGroup = new UserLocationGroup((Composite)group);
        this.systemLocationGroup = new SystemLocationGroup(group);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)contents, "com.freescale.s32ds.cross.sdk.support.SDK_LOC_context");
        this.setInitData();
        this.validate();
    }

    private void setInitData() {
        this.isSystemEnvMode = this.env != null && this.env.isSystem();
        this.getLocationGroup().init();
    }

    private String getLocation() {
        return this.env != null && this.env.getValue() != null ? this.env.getValue().trim() : "";
    }

    private String getNewLocation() {
        return this.getLocationGroup().getLocation();
    }

    private String getEnvironmentName() {
        return this.getLocationGroup().getEnvironmentName();
    }

    private ILocationGroup getLocationGroup() {
        return this.isSystemEnvMode ? this.systemLocationGroup : this.userLocationGroup;
    }

    private void createLabel(Composite parent, String labelText) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
    }

    private Text createField(Composite parent, int fieldStyle, String context) {
        Text field = new Text(parent, fieldStyle);
        field.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        field.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)field, "com.freescale.s32ds.cross.sdk.support" + context);
        return field;
    }

    private Combo createCombo(Composite parent, String[] items, String context) {
        Combo combo = new Combo(parent, 2060);
        if (items != null) {
            combo.setItems(items);
        }
        combo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)combo, "com.freescale.s32ds.cross.sdk.support" + context);
        return combo;
    }

    private void savePref(String key, String val) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        prefs.put(key, val);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
    }

    protected void okPressed() {
        String newLoc;
        String oldLoc = this.getLocation();
        if (this.showWarning(oldLoc, newLoc = this.getNewLocation())) {
            if (this.env != null && !this.env.isSystem()) {
                SDKUtils.removeSDKEnv(this.env);
            }
            String name = this.getEnvironmentName();
            this.env = SDKSupportPlugin.createEnvironment(name, this.isSystemEnvMode, false, newLoc, this.defaultDesc);
            if (!oldLoc.equals(newLoc)) {
                this.isSDKLocationChanged = true;
            }
            super.okPressed();
        }
    }

    boolean isSDKLocationChanged() {
        return this.isSDKLocationChanged;
    }

    private boolean showWarning(String oldLoc, String newLoc) {
        boolean yes;
        if (InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support").get(ASK_KEY, "").equals(ASK_KEY)) {
            return true;
        }
        if (oldLoc.length() == 0) {
            return true;
        }
        if (oldLoc.equals(newLoc)) {
            return true;
        }
        MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)Messages.SDKEditDialog_SDK_src_title, (String)String.format(Messages.SDKEditDialog_SDK_src_msg, oldLoc, newLoc), (String)Messages.LocationEditDialog_Dont_ask_again, (boolean)false, null, null);
        boolean bl = yes = toggleDialog.getReturnCode() == 2;
        if (yes && toggleDialog.getToggleState()) {
            this.savePref(ASK_KEY, ASK_KEY);
        }
        return yes;
    }

    private void validate() {
        this.setErrorMessage(null);
        boolean isOk = true;
        String envName = this.getEnvironmentName();
        String envPath = this.getNewLocation();
        if (isOk) {
            isOk &= this.handler.validatePathText(envPath);
        }
        if (isOk) {
            isOk &= this.handler.validateEnv(envName, this.isSystemEnvMode);
        }
        if (isOk && !this.isSystemEnvMode) {
            isOk &= this.checkEnvVariableExist(envName);
        }
        try {
            SDKSupportPlugin.substituteSystemVars(envPath, envName);
        }
        catch (CoreException e) {
            isOk = false;
            this.setErrorMessage(e.getMessage());
        }
        if (isOk) {
            this.setErrorMessage(null);
        }
        if (this.getErrorMessage() == null) {
            this.checkFilesCount(envPath);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(this.getErrorMessage() == null);
        }
        this.getLocationGroup().showResolvedPath(isOk && this.needResolvePath(this.getLocationGroup().getLocation()));
    }

    private boolean needResolvePath(String s) {
        return s != null && !s.isEmpty() && (s.contains("${") || s.equals("."));
    }

    private void checkFilesCount(String envPath) {
        try {
            String newLocation;
            String currentLocation = new File(SDKSupportPlugin.performStringSubstitution(this.getLocation(), this.getEnvironmentName())).getAbsolutePath();
            File file = new File(SDKSupportPlugin.performStringSubstitution(envPath, this.getEnvironmentName()));
            String string = newLocation = file.toPath().getNameCount() > 0 ? file.getAbsolutePath() : String.valueOf(file.getPath()) + File.separator;
            if (newLocation != null) {
                File f = new File(newLocation);
                if (f.exists() && f.isDirectory() && f.canRead()) {
                    this.counter = SDKUtils.calculateFilesCount(f.toPath(), 1000);
                    if (!currentLocation.equals(newLocation) && this.counter > 1000) {
                        this.setMessage(String.format(Messages.SDKEditDialog_question_text, 1000), 2);
                    } else {
                        this.setMessage(String.format(Messages.LocationEditDialog_total_files, this.counter > 1000 ? "more than 1000" : Integer.valueOf(this.counter)), 1);
                    }
                } else {
                    this.setErrorMessage(String.format(Messages.LocationEditDialog_loc_invalid, envPath));
                }
            }
        }
        catch (InvalidPathException invalidPathException) {
            this.setErrorMessage(String.format(Messages.LocationEditDialog_loc_invalid, envPath));
        }
    }

    private boolean checkEnvVariableExist(String name) {
        if (this.env == null || !name.equals(this.env.getName())) {
            return this.handler.validateEnvVariableExist(name);
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.validate();
    }

    static interface ILocationGroup {
        public void init();

        public String getEnvironmentName();

        public String getLocation();

        public void disable();

        public void showResolvedPath(boolean var1);
    }

    class SystemLocationGroup
    implements ILocationGroup {
        private Button toggleButton;
        private Combo systemVariablesCombo;
        private String variableName;
        private Text locationField;

        SystemLocationGroup(Group parent) {
            new Label((Composite)parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
            this.toggleButton = new Button((Composite)parent, 16);
            this.toggleButton.setText(Messages.LocationEditDialog_select_system_variable_button_text);
            this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemLocationGroup.this.toggleButton.setSelection(true);
                    LocationEditDialog.this.isSystemEnvMode = true;
                    SystemLocationGroup.this.systemVariablesCombo.setEnabled(true);
                    LocationEditDialog.this.userLocationGroup.disable();
                    LocationEditDialog.this.validate();
                }
            });
            this.systemVariablesCombo = LocationEditDialog.this.createCombo((Composite)parent, this.getSystemVariables(), ".SDK_SYS_VAR_context");
            this.systemVariablesCombo.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            LocationEditDialog.this.createLabel((Composite)parent, Messages.SDKDialog_location_label_text);
            this.locationField = LocationEditDialog.this.createField((Composite)parent, 18506, ".SDK_LOC_context");
            this.locationField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            this.systemVariablesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SystemLocationGroup.this.variableName = SystemLocationGroup.this.systemVariablesCombo.getText();
                    String value = null;
                    if (SystemLocationGroup.this.variableName != null) {
                        value = System.getenv(SystemLocationGroup.this.variableName);
                    }
                    SystemLocationGroup.this.locationField.setText(value == null ? "" : value.trim());
                    LocationEditDialog.this.validate();
                }
            });
        }

        @Override
        public void init() {
            this.toggleButton.setSelection(true);
            LocationEditDialog.this.userLocationGroup.disable();
            this.systemVariablesCombo.setText(LocationEditDialog.this.env.getName());
            this.variableName = this.systemVariablesCombo.getText();
            this.locationField.setText(LocationEditDialog.this.env.getValue());
            LocationEditDialog.this.isSystemEnvMode = true;
        }

        @Override
        public String getEnvironmentName() {
            return this.variableName;
        }

        @Override
        public String getLocation() {
            return this.locationField.getText().trim();
        }

        @Override
        public void disable() {
            LocationEditDialog.this.isSystemEnvMode = false;
            this.toggleButton.setSelection(false);
            this.systemVariablesCombo.setEnabled(false);
            this.locationField.setEnabled(false);
        }

        @Override
        public void showResolvedPath(boolean isShow) {
        }

        private String[] getSystemVariables() {
            Map<String, String> sysEnvVariables = System.getenv();
            ArrayList<String> items = new ArrayList<String>();
            for (String var : sysEnvVariables.keySet()) {
                if (!LocationEditDialog.this.handler.validateEnv(var, true, false) || !LocationEditDialog.this.handler.validatePath(sysEnvVariables.get(var), var, false)) continue;
                items.add(var);
            }
            items.sort(Comparator.naturalOrder());
            return items.toArray(new String[items.size()]);
        }
    }

    class UserLocationGroup
    implements ILocationGroup {
        private Button toggleButton;
        private Text envNameField;
        private Text locationField;
        private Button variableButton;
        private Button browseButton;
        private Label resolvedLabel;
        private Label resolvedText;

        UserLocationGroup(Composite parent) {
            this.toggleButton = new Button(parent, 16);
            this.toggleButton.setText(Messages.LocationEditDialog_define_new_variable_button_text);
            this.envNameField = LocationEditDialog.this.createField(parent, 2052, ".SDK_NEW_VAR_context");
            this.envNameField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            LocationEditDialog.this.createLabel(parent, Messages.SDKDialog_location_label_text);
            this.locationField = LocationEditDialog.this.createField(parent, 18498, ".SDK_NEW_VAR_context");
            this.locationField.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            this.resolvedLabel = new Label(parent, 0);
            this.resolvedLabel.setText(Messages.SDKDialog_resolved_location_label);
            this.resolvedLabel.setVisible(false);
            this.resolvedText = new Label(parent, 64);
            this.resolvedText.setVisible(false);
            this.resolvedText.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            new Label(parent, 0).setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.variableButton = new Button(parent, 8);
            this.variableButton.setText(Messages.LocationEditDialog_variable_button_text);
            this.variableButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            LocationEditDialog.this.setButtonLayoutData(this.variableButton);
            this.browseButton = new Button(parent, 8);
            this.browseButton.setText(Messages.LocationEditDialog_browse_button_text);
            this.browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            LocationEditDialog.this.setButtonLayoutData(this.browseButton);
            this.addListeners();
        }

        @Override
        public void init() {
            LocationEditDialog.this.isSystemEnvMode = false;
            this.toggleButton.setSelection(true);
            this.envNameField.setText(LocationEditDialog.this.env != null ? LocationEditDialog.this.env.getName() : LocationEditDialog.this.defaultName);
            this.locationField.setText(LocationEditDialog.this.env != null ? LocationEditDialog.this.env.getValue() : "");
            LocationEditDialog.this.systemLocationGroup.disable();
        }

        @Override
        public String getEnvironmentName() {
            return this.envNameField.getText();
        }

        @Override
        public String getLocation() {
            return this.locationField.getText().trim();
        }

        @Override
        public void disable() {
            LocationEditDialog.this.isSystemEnvMode = true;
            this.toggleButton.setSelection(false);
            this.envNameField.setEnabled(false);
            this.variableButton.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.locationField.setEnabled(false);
        }

        @Override
        public void showResolvedPath(boolean isShow) {
            String location = this.locationField.getText();
            String aPath = new File(SDKSupportPlugin.performStringSubstitution(location, this.getEnvironmentName())).getAbsolutePath();
            this.resolvedLabel.setVisible(isShow &= !location.isEmpty() && !aPath.equals(location));
            this.resolvedText.setText(isShow ? aPath : "");
            this.resolvedText.setVisible(isShow);
        }

        private void selectFolder() {
            DirectoryDialog dialog = new DirectoryDialog(LocationEditDialog.this.getShell(), 0x10000000);
            dialog.setText(Messages.SDKDialog_folder_selection_dialog_title);
            dialog.setMessage(Messages.SDKDialog_folder_selection_dialog_header_text);
            dialog.setFilterPath(InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support").get(LocationEditDialog.DIR_KEY, ""));
            String selectedFolder = dialog.open();
            if (selectedFolder != null) {
                this.locationField.setText(new Path(selectedFolder).makeAbsolute().toOSString());
                LocationEditDialog.this.savePref(LocationEditDialog.DIR_KEY, this.locationField.getText());
                LocationEditDialog.this.validate();
            }
        }

        private void selectVariable() {
            Object[] result;
            ElementListSelectionDialog variableSelectionDialog = new ElementListSelectionDialog(LocationEditDialog.this.getShell(), (ILabelProvider)new StringVariableLabelProvider()){

                protected Control createDialogArea(Composite parent) {
                    Composite c = (Composite)super.createDialogArea(parent);
                    c.addHelpListener(new HelpListener(){

                        public void helpRequested(HelpEvent arg0) {
                        }
                    });
                    return parent;
                }
            };
            variableSelectionDialog.setHelpAvailable(false);
            variableSelectionDialog.setElements((Object[])this.getInternalVariables());
            variableSelectionDialog.setTitle(StringSubstitutionMessages.StringVariableSelectionDialog_2);
            variableSelectionDialog.setMessage(StringSubstitutionMessages.StringVariableSelectionDialog_3);
            if (variableSelectionDialog.open() == 0 && (result = variableSelectionDialog.getResult()) != null && result.length > 0) {
                IValueVariable vv = (IValueVariable)result[0];
                this.locationField.setText("${" + vv.getName() + "}");
            }
        }

        private IValueVariable[] getInternalVariables() {
            IValueVariable[] vars;
            TreeSet<IValueVariable> variables = new TreeSet<IValueVariable>(new Comparator<IValueVariable>(){

                @Override
                public int compare(IValueVariable vv1, IValueVariable vv2) {
                    return vv1.getName().compareTo(vv2.getName());
                }
            });
            IValueVariable[] iValueVariableArray = vars = VariablesPlugin.getDefault().getStringVariableManager().getValueVariables();
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IValueVariable variable = iValueVariableArray[n2];
                if (LocationEditDialog.this.handler.validatePath(variable.getValue(), variable.getName(), false) && LocationEditDialog.this.handler.validateEnv(variable.getName(), false, false)) {
                    variables.add(variable);
                }
                ++n2;
            }
            return variables.toArray(new IValueVariable[variables.size()]);
        }

        private void addListeners() {
            this.locationField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String sourceText = UserLocationGroup.this.locationField.getText();
                    String trimmedText = sourceText.replaceAll("\r\n", "");
                    if (!trimmedText.equals(sourceText)) {
                        UserLocationGroup.this.locationField.setText(trimmedText);
                        UserLocationGroup.this.locationField.setSelection(trimmedText.length());
                    }
                    LocationEditDialog.this.validate();
                }
            });
            this.locationField.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 4) {
                        e.doit = true;
                    }
                }
            });
            this.envNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    LocationEditDialog.this.validate();
                }
            });
            this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LocationEditDialog.this.isSystemEnvMode = false;
                    UserLocationGroup.this.envNameField.setEnabled(true);
                    UserLocationGroup.this.envNameField.setText(LocationEditDialog.this.env != null && !LocationEditDialog.this.env.isSystem() ? LocationEditDialog.this.env.getName() : LocationEditDialog.this.defaultName);
                    UserLocationGroup.this.variableButton.setEnabled(true);
                    UserLocationGroup.this.browseButton.setEnabled(true);
                    LocationEditDialog.this.systemLocationGroup.disable();
                    UserLocationGroup.this.toggleButton.setSelection(true);
                    UserLocationGroup.this.locationField.setEnabled(true);
                    LocationEditDialog.this.validate();
                }
            });
            this.variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserLocationGroup.this.selectVariable();
                }
            });
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UserLocationGroup.this.selectFolder();
                }
            });
        }
    }
}

