/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.ui.internal.CustomTreeViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Tree;

public class LibraryFilesControl
extends CustomTreeViewer {
    public static final String LIBRARIES_SUFFIX = "B";
    private static final int ORDERING_ITEMS_LIST_HEIGHT_HINT = 110;
    private ListViewer orderingItemsListViewer;
    private Button moveUpButton;
    private Button moveDownButton;

    public LibraryFilesControl(Composite parent, boolean isEditable, boolean selectSiblings, String[][] heads) {
        super(parent, SDKSupportPlugin.binariesMatcher, isEditable, selectSiblings, LIBRARIES_SUFFIX, heads);
        this.createOredringItemsList(parent);
    }

    @Override
    public void setInput(CustomTreeViewer.InputWrapper wrapper, IExtendedPath[] selectedPaths, boolean expand) {
        super.setInput(wrapper, selectedPaths, true);
        this.setOrderingItemsListInput();
    }

    @Override
    public void setInput(CustomTreeViewer.InputWrapper wrapper, IExtendedPath[][] selectedPaths, boolean expand) {
        super.setInput(wrapper, selectedPaths, expand);
        this.toSelect.addAll(Arrays.asList(selectedPaths[0]));
        this.setOrderingItemsListInput();
    }

    @Override
    public IExtendedPath[] getChecked() {
        IExtendedPath[] selectedItems = super.getChecked();
        return (IExtendedPath[])Arrays.stream(selectedItems).filter(this.isNotDirectory()).toArray(IExtendedPath[]::new);
    }

    @Override
    public void clearSelected() {
        super.clearSelected();
        this.setOrderingItemsListInput();
    }

    @Override
    protected void switchSelection(Tree tree, int id) {
        super.switchSelection(tree, id);
        this.setOrderingItemsListInput();
    }

    @Override
    protected EditingSupport getSelectColumnEditingSupport() {
        return new LibrarySelectColumnEditingSupport((ColumnViewer)this.viewer);
    }

    private void createOredringItemsList(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LibraryFilesControl_ordering_items_list_label);
        Composite listComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        listComposite.setFont(parent.getFont());
        this.createOrderingItemsListViewer(listComposite);
        if (this.isEditable) {
            this.createButtonsGroup(listComposite);
        }
    }

    private void createOrderingItemsListViewer(Composite parent) {
        this.orderingItemsListViewer = new ListViewer(parent, 2820);
        GridData listLayoutData = new GridData(1808);
        listLayoutData.heightHint = 110;
        this.orderingItemsListViewer.getList().setLayoutData((Object)listLayoutData);
        this.orderingItemsListViewer.getList().setFont(parent.getFont());
        this.orderingItemsListViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return LibraryFilesControl.this.toSelect.stream().filter(LibraryFilesControl.this.isNotDirectory()).toArray(IExtendedPath[]::new);
            }
        });
        this.orderingItemsListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IExtendedPath) {
                    IExtendedPath path = (IExtendedPath)element;
                    Object viewerInput = LibraryFilesControl.this.viewer.getInput();
                    if (viewerInput instanceof CustomTreeViewer.InputWrapper) {
                        return path.makeRelativeTo(((CustomTreeViewer.InputWrapper)viewerInput).get().getRootPath()).toString();
                    }
                }
                return super.getText(element);
            }
        });
        this.orderingItemsListViewer.getList().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibraryFilesControl.this.updateMoveButtonsEnabledState();
            }
        });
    }

    private void createButtonsGroup(Composite parent) {
        Composite groupComponent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(groupComponent);
        GridData buttonGroupGridData = new GridData();
        buttonGroupGridData.verticalAlignment = 4;
        buttonGroupGridData.horizontalAlignment = 4;
        groupComponent.setLayoutData((Object)buttonGroupGridData);
        groupComponent.setFont(parent.getFont());
        this.moveUpButton = new Button(groupComponent, 8);
        this.moveUpButton.setText(Messages.LibraryFilesControl_ordering_list_button_up_text);
        this.moveUpButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.moveUpButton.setFont(groupComponent.getParent().getFont());
        this.moveUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.moveSelectedItemUp();
                LibraryFilesControl.this.updateMoveButtonsEnabledState();
            }

            private void moveSelectedItemUp() {
                int selectionIndex = LibraryFilesControl.this.orderingItemsListViewer.getList().getSelectionIndex();
                if (selectionIndex <= 0) {
                    return;
                }
                ArrayList<IExtendedPath> orderedList = new ArrayList<IExtendedPath>(LibraryFilesControl.this.toSelect);
                IExtendedPath selectedItem = (IExtendedPath)orderedList.remove(selectionIndex);
                orderedList.add(selectionIndex - 1, selectedItem);
                LibraryFilesControl.this.toSelect.clear();
                LibraryFilesControl.this.toSelect.addAll(orderedList);
                LibraryFilesControl.this.setOrderingItemsListInput();
                LibraryFilesControl.this.orderingItemsListViewer.getList().setSelection(selectionIndex - 1);
            }
        });
        this.moveDownButton = new Button(groupComponent, 8);
        this.moveDownButton.setText(Messages.LibraryFilesControl_ordering_list_button_down_text);
        this.moveDownButton.setLayoutData((Object)new GridData(4, 0, true, false));
        this.moveDownButton.setFont(groupComponent.getParent().getFont());
        this.moveDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.moveSelectedItemDown();
                LibraryFilesControl.this.updateMoveButtonsEnabledState();
            }

            private void moveSelectedItemDown() {
                List itemsList = LibraryFilesControl.this.orderingItemsListViewer.getList();
                int selectionIndex = itemsList.getSelectionIndex();
                if (selectionIndex >= itemsList.getItemCount() - 1) {
                    return;
                }
                ArrayList<IExtendedPath> orderedList = new ArrayList<IExtendedPath>(LibraryFilesControl.this.toSelect);
                IExtendedPath selectedItem = (IExtendedPath)orderedList.remove(selectionIndex);
                orderedList.add(selectionIndex + 1, selectedItem);
                LibraryFilesControl.this.toSelect.clear();
                LibraryFilesControl.this.toSelect.addAll(orderedList);
                LibraryFilesControl.this.setOrderingItemsListInput();
                LibraryFilesControl.this.orderingItemsListViewer.getList().setSelection(selectionIndex + 1);
            }
        });
        this.updateMoveButtonsEnabledState();
    }

    private void updateMoveButtonsEnabledState() {
        if (this.isEditable) {
            List list = this.orderingItemsListViewer.getList();
            int selectionIndex = list.getSelectionIndex();
            boolean isSelectedNotEmpty = !this.toSelect.isEmpty();
            this.moveUpButton.setEnabled(isSelectedNotEmpty && selectionIndex > 0);
            this.moveDownButton.setEnabled(isSelectedNotEmpty && selectionIndex < list.getItemCount() - 1);
        }
    }

    private void setOrderingItemsListInput() {
        this.orderingItemsListViewer.setInput(this.getFilteredItems(this.toSelect));
        this.orderingItemsListViewer.refresh();
    }

    private Set<IExtendedPath> getFilteredItems(Set<IExtendedPath> items) {
        return items.stream().filter(this.isNotDirectory()).collect(Collectors.toSet());
    }

    private Predicate<? super IExtendedPath> isNotDirectory() {
        return ep -> !ep.toFile().isDirectory();
    }

    class LibrarySelectColumnEditingSupport
    extends CustomTreeViewer.SelectColumnEditingSupport {
        public LibrarySelectColumnEditingSupport(ColumnViewer viewer) {
            super(LibraryFilesControl.this, viewer);
        }

        @Override
        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            LibraryFilesControl.this.setOrderingItemsListInput();
        }
    }
}

