/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKNameValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKVersionValidator;
import com.nxp.s32ds.cle.ide.sdk.core.ImportMcalSdkHandler;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportMcalSdkDialog
extends TitleAreaDialog {
    private static final String DATA_LABEL = "label";
    private static final String DATA_BUTTON = "button";
    private Text mcalConfigurationPathField;
    private Text sdkNameField;
    private Text sdkVersionField;
    private List<ISDK> mcalSdks;
    private ISDK mcalSdk;
    private String mcalDescriptiorPath;
    private String mcalConfigurationPath;
    private String sdkName;
    private String sdkVersion;
    private SDKNameValidator nameValidator = new SDKNameValidator();
    private SDKVersionValidator versionValidator = new SDKVersionValidator();

    public ImportMcalSdkDialog(Shell parentShell, List<ISDK> mcalSdks) {
        super(parentShell);
        this.mcalSdks = mcalSdks;
    }

    public ISDK getMcalSdk() {
        return this.mcalSdk;
    }

    public String getMcalDescriptiorPath() {
        return this.mcalDescriptiorPath;
    }

    public String getMcalConfigurationPath() {
        return this.mcalConfigurationPath;
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.ImportMcalSdkDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)parentComposite);
        Composite contents = this.createComposite(parentComposite);
        Dialog.applyDialogFont((Control)parentComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parentComposite, "com.freescale.s32ds.cross.sdk.support.SDK_import_MCAL_SDK_context");
        return contents;
    }

    public void create() {
        super.create();
        this.updateButtonsState();
    }

    protected void okPressed() {
        this.mcalConfigurationPath = this.mcalConfigurationPathField.getText();
        this.sdkName = this.sdkNameField.getText();
        this.sdkVersion = this.sdkVersionField.getText();
        super.okPressed();
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(500, -1).applyTo((Control)composite);
        this.createMcalDescriptorsComboViewer(composite);
        this.createMcalConfigurationPathField(composite);
        this.createTargetSdkFileds(composite);
        this.setTitle(Messages.ImportMcalSdkDialog_title);
        return composite;
    }

    private void createMcalDescriptorsComboViewer(Composite composite) {
        Label mcalDescriptiorPathLabel = this.createLabel(Messages.ImportMcalSdkDialog_label_mcal_descriptor, composite);
        Combo combo = new Combo(composite, 12);
        combo.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        ComboViewer mcalDescriptorsComboViewer = new ComboViewer(combo);
        mcalDescriptorsComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ImportMcalSdkDialog.this.mcalSdks.toArray();
            }
        });
        mcalDescriptorsComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ISDK)element).getName();
            }
        });
        mcalDescriptorsComboViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                this.mcalSdk = (ISDK)selection.getFirstElement();
                this.updateButtonsState();
            }
        });
        mcalDescriptorsComboViewer.setInput(this.mcalSdks);
        mcalDescriptorsComboViewer.refresh();
        mcalDescriptorsComboViewer.setData(DATA_LABEL, (Object)mcalDescriptiorPathLabel);
    }

    private void createMcalConfigurationPathField(Composite composite) {
        Label mcalConfigurationPathLabel = this.createLabel(Messages.ImportMcalSdkDialog_label_mcal_configuration_location, composite);
        this.mcalConfigurationPathField = new Text(composite, 2060);
        this.mcalConfigurationPathField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button mcalConfigurationBrowseButton = this.createMcalConfigurationBrowseButton(composite);
        this.mcalConfigurationPathField.setData(DATA_BUTTON, (Object)mcalConfigurationBrowseButton);
        this.mcalConfigurationPathField.setData(DATA_LABEL, (Object)mcalConfigurationPathLabel);
    }

    private void createTargetSdkFileds(Composite composite) {
        this.sdkNameField = this.createTextField(Messages.SDKDialog_name_label_text, composite);
        this.sdkVersionField = this.createTextField(Messages.SDKDialog_version_label_text, composite);
    }

    private Label createLabel(String title, Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(title);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return label;
    }

    private Button createMcalConfigurationBrowseButton(Composite composite) {
        Button browseButton = this.createBrowseButton(composite);
        browseButton.setText(Messages.SDKDialog_location_button_text);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ImportMcalSdkDialog.this.getShell(), 0x10001000);
                dialog.setText(Messages.ImportMcalSdkDialog_title_browse_mcal_configuration);
                ImportMcalSdkDialog.this.mcalConfigurationPathField.setText(ImportMcalSdkDialog.this.getSelectedPathName(dialog.open()));
                ImportMcalSdkDialog.this.updateButtonsState();
            }
        });
        this.setButtonLayoutData(browseButton);
        return browseButton;
    }

    private Button createBrowseButton(Composite composite) {
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.SDKDialog_location_button_text);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        return browseButton;
    }

    private Text createTextField(String labelTitle, Composite composite) {
        Label label = this.createLabel(labelTitle, composite);
        Text textField = new Text(composite, 2052);
        textField.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        textField.addModifyListener(e -> this.updateButtonsState());
        textField.setData(DATA_LABEL, (Object)label);
        return textField;
    }

    private String getSelectedPathName(String selectedPath) {
        return selectedPath != null ? new File(selectedPath).getAbsolutePath() : "";
    }

    private void updateButtonsState() {
        this.setErrorMessage(null);
        IStatus status = Status.OK_STATUS;
        if (this.mcalSdk == null) {
            status = new Status(4, "com.freescale.s32ds.cross.sdk.support", Messages.ImportMcalSdkDialog_error_select_mcal_descriptor);
        }
        if (status.isOK() && this.mcalConfigurationPathField.getText().isEmpty()) {
            status = new Status(4, "com.freescale.s32ds.cross.sdk.support", Messages.ImportMcalSdkDialog_error_select_mcal_configuration_location);
        }
        if (status.isOK()) {
            status = ImportMcalSdkHandler.checkMcalConfigDirectoryStructure(this.mcalConfigurationPathField.getText());
        }
        if (status.isOK()) {
            status = this.nameValidator.validate(this.sdkNameField.getText());
        }
        if (status.isOK()) {
            status = this.versionValidator.validate(this.sdkVersionField.getText());
        }
        if (status.isOK() && SDKUtils.exists(this.sdkNameField.getText(), this.sdkVersionField.getText())) {
            status = new Status(4, "com.freescale.s32ds.cross.sdk.support", Messages.SDKEditDialog_same_name_exists);
        }
        this.setErrorMessage(!status.isOK() ? status.getMessage() : null);
        this.getButton(0).setEnabled(this.getErrorMessage() == null);
    }
}

