/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.freescale.s32ds.cross.sdk.ui.internal.CustomTreeViewer;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResource;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class HeaderFilesTreeViewer
extends CustomTreeViewer {
    public static final String HEADERS_SUFFIX = "H";
    private static final int INCLUDE_ALL_MENUITEM_ID = 5;
    private static final int INCLUDE_NONE_MENUITEM_ID = 6;
    private Map<String, List<IExtendedPath>> includeFiles = new LinkedHashMap<String, List<IExtendedPath>>();
    private TCHolder rootToolChainHolder;

    public HeaderFilesTreeViewer(Composite parent, boolean isEdiatable, String[][] heads, TCHolder rootToolChainHolder) {
        super(parent, SDKSupportPlugin.headersMatcher, isEdiatable, false, HEADERS_SUFFIX, heads);
        this.rootToolChainHolder = rootToolChainHolder;
    }

    public Map<String, List<IExtendedPath>> getIncludeFiles() {
        return this.includeFiles != null ? this.includeFiles : Collections.emptyMap();
    }

    public void setIncludedFiles(Map<String, List<IExtendedPath>> includeFiles) {
        this.includeFiles = includeFiles == null ? new LinkedHashMap() : includeFiles;
    }

    @Override
    public void clearSelected() {
        super.clearSelected();
        this.includeFiles.clear();
    }

    @Override
    protected ITreeContentProvider getSourceTreeContentProvider() {
        return new HeaderFilesTreeContentProvider();
    }

    @Override
    protected void addExtraColumns(String[][] heads) {
        super.addExtraColumns(heads);
        TreeViewerColumn includeFilesColumn = new TreeViewerColumn(this.viewer, 0);
        includeFilesColumn.getColumn().setText(Messages.HeaderFilesTreeViewer_include_files_column_title);
        includeFilesColumn.getColumn().setWidth(50);
        includeFilesColumn.setLabelProvider((CellLabelProvider)new IncludeFilesColumnLabelProvider());
        if (this.isEditable) {
            includeFilesColumn.setEditingSupport((EditingSupport)new IncludeFilesColumnEditingSupport((ColumnViewer)this.viewer));
        }
    }

    @Override
    protected boolean isDirectorySelectable(IExtendedPath directory) {
        if (!super.isDirectorySelectable(directory)) {
            File[] listFiles = directory.toFile().listFiles();
            if (listFiles != null) {
                return Arrays.stream(listFiles).noneMatch(File::isFile);
            }
            return false;
        }
        return true;
    }

    @Override
    protected List<IExtendedPath> getMatchedSelectableFolders(IExtendedPath parentPath) {
        File[] listFiles = parentPath.toFile().listFiles();
        if (listFiles != null) {
            return Arrays.stream(listFiles).filter(File::isDirectory).map(dir -> ExtendedPath.fromOSString(dir.getAbsolutePath(), true)).filter(this::isDirectorySelectable).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    protected Menu getMenu(Tree tree) {
        Menu menu = super.getMenu(tree);
        new MenuItem(menu, 2);
        this.addItem(menu, tree, Messages.HeaderFilesTreeViewer_menuitem_include_all_title, 5);
        this.addItem(menu, tree, Messages.HeaderFilesTreeViewer_menuitem_include_none_title, 6);
        return menu;
    }

    @Override
    protected void switchSelection(Tree tree, int id) {
        super.switchSelection(tree, id);
        switch (id) {
            case 5: {
                this.includeFiles.clear();
                this.viewer.expandAll();
                this.includeItems(tree.getItems());
                break;
            }
            case 2: 
            case 6: {
                this.includeFiles.clear();
                break;
            }
        }
    }

    private void includeItems(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof IExtendedPath) {
                String rootToolChainId = this.rootToolChainHolder.getTCId();
                IExtendedPath includeFilePath = (IExtendedPath)data;
                if (this.toSelect.contains(includeFilePath)) {
                    this.includeFiles.computeIfAbsent(rootToolChainId, s -> new ArrayList()).add(includeFilePath);
                }
            }
            this.includeItems(treeItem.getItems());
            ++n2;
        }
    }

    private boolean isIncludeFilesContainPath(IExtendedPath path) {
        return this.includeFiles != null && this.includeFiles.values().stream().flatMap(Collection::stream).anyMatch(s -> s.equals(path));
    }

    private class HeaderFilesTreeContentProvider
    extends CustomTreeViewer.SourcesTreeContentProvider {
        private HeaderFilesTreeContentProvider() {
        }

        @Override
        protected Object[] getModulesResources(CustomTreeViewer.SdkDataHolder sdkDataHolder) {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            result.addAll(this.getMatchedChildren(sdkDataHolder.getRootPath()));
            Set<SdkModule> refModules = sdkDataHolder.getModulesHolder();
            for (SdkModule refModule : refModules) {
                ISDK refSdk = refModule.getSdk();
                if (refSdk == null) continue;
                IExtendedPath rootPath = ExtendedPath.fromOSString(refSdk.getHeader().getBasePath(), true);
                List<IExtendedPath> resourcesPaths = refSdk.getRoot().getHeaders().stream().map(SdkResource::getPath).collect(Collectors.toList());
                result.add(new CustomTreeViewer.ModuleResources(refModule.getName(), rootPath, resourcesPaths));
            }
            return result.toArray();
        }
    }

    private class IncludeFilesColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public IncludeFilesColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (HeaderFilesTreeViewer.this.isEditable && element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                return path.toFile().isFile() && HeaderFilesTreeViewer.this.toSelect.contains(path);
            }
            return false;
        }

        protected Boolean getValue(Object element) {
            if (element instanceof IExtendedPath) {
                return HeaderFilesTreeViewer.this.isIncludeFilesContainPath((IExtendedPath)element);
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            boolean isIncludeFile = (Boolean)value;
            String rootToolChainId = HeaderFilesTreeViewer.this.rootToolChainHolder.getTCId();
            IExtendedPath includeFilePath = (IExtendedPath)element;
            if (isIncludeFile) {
                HeaderFilesTreeViewer.this.includeFiles.computeIfAbsent(rootToolChainId, s -> new ArrayList()).add(includeFilePath);
            } else {
                HeaderFilesTreeViewer.this.includeFiles.computeIfAbsent(rootToolChainId, s -> new ArrayList()).remove(includeFilePath);
            }
            this.getViewer().refresh();
        }
    }

    private class IncludeFilesColumnLabelProvider
    extends CellLabelProvider {
        private IncludeFilesColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                boolean isInclude = HeaderFilesTreeViewer.this.isIncludeFilesContainPath(path);
                boolean isFileAndSelected = path.toFile().isFile() && (!HeaderFilesTreeViewer.this.isEditable || HeaderFilesTreeViewer.this.toSelect.contains(path));
                cell.setImage(ICONS[isInclude ? 1 : 0][isFileAndSelected ? 1 : 0]);
            }
        }
    }
}

