/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.IFileFilter;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModulesHolder;
import java.io.File;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class CustomTreeViewer {
    protected static final int SEL_ALL = 1;
    protected static final int SEL_NON = 2;
    private static final int COPY_ALL = 3;
    private static final int COPY_NON = 4;
    public static final String[][] DEFAULT_HEADS = new String[][]{{"Copy"}, {"'x' stands for Link      '+' stands for Copy"}};
    private static final String TREE_KEY = "TREE_";
    protected final boolean isEditable;
    private final boolean selectSiblings;
    protected final TreeViewer viewer;
    protected final PathMatcher matcher;
    private IExtendedPath[] checkedStore;
    private final Set<IExtendedPath> toCopy = new HashSet<IExtendedPath>();
    protected final Set<IExtendedPath> toSelect = new LinkedHashSet<IExtendedPath>();
    protected final Set<IExtendedPath> toSelectFolder = new HashSet<IExtendedPath>();
    protected static final int DATA_COPY = 0;
    protected static final int DATA_SELECT = 1;
    protected static final int DATA_SELECT_FOLDER = 2;
    protected IExtendedPath.PathList[][] multiData = null;
    protected String[][] heads;
    private final IFileFilter selectedFileFilter = new IFileFilter(){

        @Override
        public boolean accept(File f) {
            return CustomTreeViewer.this.isSelected(f);
        }
    };
    private final String suffix;
    protected static final Image[][] ICONS;

    static {
        Image[][] imageArrayArray = new Image[2][];
        Image[] imageArray = new Image[2];
        imageArray[1] = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE");
        imageArrayArray[0] = imageArray;
        Image[] imageArray2 = new Image[2];
        imageArray2[1] = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD");
        imageArrayArray[1] = imageArray2;
        ICONS = imageArrayArray;
    }

    public CustomTreeViewer(Composite parent, PathMatcher matcher, boolean isEditable, boolean selectSiblings, String suffix, String[][] heads) {
        this.isEditable = isEditable;
        this.selectSiblings = selectSiblings;
        this.matcher = matcher;
        this.suffix = suffix;
        this.heads = heads == null || heads.length == 0 ? DEFAULT_HEADS : heads;
        this.viewer = new TreeViewer(parent, 68096);
        this.viewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.viewer.setContentProvider((IContentProvider)this.getSourceTreeContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                CustomTreeViewer.this.saveTreeItemState(event.getElement(), true);
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                CustomTreeViewer.this.saveTreeItemState(event.getElement(), false);
            }
        });
        if (isEditable) {
            this.viewer.getTree().setMenu(this.getMenu(this.viewer.getTree()));
        }
        this.addNameColumn();
        this.addExtraColumns(heads);
    }

    protected void addNameColumn() {
        TreeViewerColumn nameColumn = new TreeViewerColumn(this.viewer, 0);
        nameColumn.getColumn().setText("Name");
        nameColumn.getColumn().setWidth(300);
        nameColumn.setLabelProvider((CellLabelProvider)new NameColumnLabelProvider());
    }

    protected ITreeContentProvider getSourceTreeContentProvider() {
        return new SourcesTreeContentProvider();
    }

    protected EditingSupport getSelectColumnEditingSupport() {
        return new SelectColumnEditingSupport((ColumnViewer)this.viewer);
    }

    protected void addExtraColumns(String[][] heads) {
        if (this.isEditable) {
            TreeViewerColumn selectColumn = new TreeViewerColumn(this.viewer, 0);
            selectColumn.getColumn().setText("Select");
            selectColumn.getColumn().setWidth(50);
            selectColumn.setLabelProvider((CellLabelProvider)new SelectColumnLabelProvider());
            selectColumn.setEditingSupport(this.getSelectColumnEditingSupport());
            TreeViewerColumn copyColumn = new TreeViewerColumn(this.viewer, 0);
            copyColumn.getColumn().setText("Copy");
            copyColumn.getColumn().setWidth(50);
            copyColumn.setLabelProvider((CellLabelProvider)new CopyColumnLabelProvider());
            copyColumn.setEditingSupport((EditingSupport)new CopyColumnEditingSupport((ColumnViewer)this.viewer));
        } else {
            if (heads == null || heads[0] == null || heads[0].length == 0) {
                heads = DEFAULT_HEADS;
            }
            int i = 0;
            while (i < heads[0].length) {
                TreeViewerColumn c = new TreeViewerColumn(this.viewer, 0);
                c.getColumn().setText(heads[0][i]);
                if (heads[1].length > i) {
                    c.getColumn().setToolTipText(heads[1][i]);
                } else {
                    c.getColumn().setToolTipText(DEFAULT_HEADS[1][0]);
                }
                c.getColumn().setWidth(50);
                c.setLabelProvider((CellLabelProvider)new MultiColumnLabelProvider(i));
                ++i;
            }
        }
    }

    protected Menu getMenu(Tree t) {
        Menu m = new Menu((Control)t);
        this.addItem(m, t, "Select all", 1);
        this.addItem(m, t, "Select none", 2);
        new MenuItem(m, 2);
        this.addItem(m, t, "Copy all", 3);
        this.addItem(m, t, "Copy none", 4);
        return m;
    }

    protected void addItem(Menu m, final Tree t, String txt, final int id) {
        MenuItem mi = new MenuItem(m, 0);
        mi.setText(txt);
        mi.setID(id);
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomTreeViewer.this.switchSelection(t, id);
                CustomTreeViewer.this.viewer.refresh();
            }
        });
    }

    protected void switchSelection(Tree tree, int id) {
        switch (id) {
            case 1: {
                this.selectAll(tree);
                break;
            }
            case 2: {
                this.toSelect.clear();
                this.toCopy.clear();
                break;
            }
            case 3: {
                this.copyAll(tree);
                break;
            }
            case 4: {
                this.toCopy.clear();
            }
        }
    }

    protected void saveTreeItemState(Object key, boolean state) {
        if (key == null) {
            return;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        prefs.put(TREE_KEY + this.suffix + '_' + key.toString(), Boolean.toString(state));
        try {
            prefs.flush();
        }
        catch (Exception ex) {
            SDKSupportPlugin.error(ex);
        }
    }

    protected boolean getTreeItemState(Object key) {
        if (key == null) {
            return true;
        }
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        return prefs.getBoolean(TREE_KEY + this.suffix + '_' + key.toString(), true);
    }

    public void setInput(InputWrapper wrapper, Set<IExtendedPath> checked, boolean expand) {
        this.setInput(wrapper, checked.toArray(new IExtendedPath[checked.size()]), expand);
    }

    public void setInput(InputWrapper inputWrapper, IExtendedPath[][] selectedPaths) {
        if (selectedPaths == null || selectedPaths.length == 0) {
            throw new IllegalArgumentException("Null or Empty files list !");
        }
        this.checkedStore = selectedPaths[0];
        this.initMultiData(selectedPaths);
        this.viewer.setInput((Object)inputWrapper);
    }

    public void setInput(InputWrapper wrapper, IExtendedPath[] selectedPaths, boolean expand) {
        this.checkedStore = selectedPaths;
        if (this.isEditable) {
            this.initInternalData(selectedPaths);
        }
        this.viewer.setInput((Object)wrapper);
        if (expand) {
            this.viewer.expandAll();
            this.restore(this.viewer.getTree().getItems());
        }
    }

    private void initInternalData(IExtendedPath[] selectedPaths) {
        this.toSelectFolder.clear();
        this.toSelect.clear();
        this.toCopy.clear();
        IExtendedPath[] iExtendedPathArray = selectedPaths;
        int n = selectedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            IExtendedPath p = iExtendedPathArray[n2];
            if (p.isCopy()) {
                this.toCopy.add(p);
            }
            if ((f = p.toFile()).isDirectory()) {
                this.toSelectFolder.add(p);
            } else if (f.isFile()) {
                IExtendedPath parent = this.getParent(p);
                this.toSelectFolder.add(parent);
                if (this.selectSiblings) {
                    this.toSelect.addAll(Arrays.asList(parent.matchedChildren(this.matcher, true, null)));
                } else {
                    this.toSelect.add(p);
                }
            }
            ++n2;
        }
    }

    public void setInput(InputWrapper wrapper, IExtendedPath[][] checked, boolean expand) {
        if (checked == null || checked.length == 0) {
            throw new IllegalArgumentException("Null or Empty files list !");
        }
        this.checkedStore = checked[0];
        this.initMultiData(checked);
        this.viewer.setInput((Object)wrapper);
        if (expand) {
            this.viewer.expandAll();
            this.restore(this.viewer.getTree().getItems());
        }
    }

    private void initMultiData(IExtendedPath[][] checked) {
        int offset = 1;
        int size = checked.length - 1;
        if (size == 0) {
            size = 1;
            offset = 0;
        }
        this.multiData = new IExtendedPath.PathList[size][3];
        int i = 0;
        while (i < this.multiData.length) {
            this.multiData[i][0] = new IExtendedPath.PathList();
            this.multiData[i][1] = new IExtendedPath.PathList();
            this.multiData[i][2] = new IExtendedPath.PathList();
            IExtendedPath[] iExtendedPathArray = checked[i + offset];
            int n = iExtendedPathArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f;
                IExtendedPath p = iExtendedPathArray[n2];
                if (p.isCopy()) {
                    this.multiData[i][0].add(p);
                }
                if ((f = p.toFile()).isDirectory()) {
                    this.multiData[i][1].add(p);
                } else if (f.isFile()) {
                    IExtendedPath parent = this.getParent(p);
                    this.multiData[i][2].add(parent);
                    if (this.selectSiblings) {
                        this.multiData[i][1].addAll(Arrays.asList(parent.matchedChildren(this.matcher, true, null)));
                    } else {
                        this.multiData[i][1].add(p);
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private void restore(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem it = treeItemArray[n2];
            it.setExpanded(this.getTreeItemState(it.getData()));
            this.restore(it.getItems());
            ++n2;
        }
    }

    private IExtendedPath getParent(IExtendedPath p) {
        return ExtendedPath.fromOSString(p.removeLastSegments(1).toOSString(), true);
    }

    public IExtendedPath[] getChecked() {
        if (!this.isEditable) {
            throw new IllegalAccessError("Bad access !");
        }
        LinkedHashSet<IExtendedPath> selectedPaths = new LinkedHashSet<IExtendedPath>();
        selectedPaths.addAll(this.toSelectFolder);
        selectedPaths.addAll(this.toSelect);
        selectedPaths.stream().forEach(path -> path.setCopy(this.toCopy.contains(path)));
        return selectedPaths.toArray(new ExtendedPath[0]);
    }

    public void clearSelected() {
        this.toSelect.clear();
        this.toSelectFolder.clear();
    }

    private boolean isSelected(File file) {
        if (this.isEditable) {
            return true;
        }
        String abs = file.getAbsolutePath();
        IExtendedPath[] iExtendedPathArray = this.checkedStore;
        int n = this.checkedStore.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath p = iExtendedPathArray[n2];
            if (p.toOSString().equals(abs)) {
                return true;
            }
            if (p.isPrefixOf(Path.fromOSString((String)abs))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void copyAll(Tree tree) {
        if (this.toSelect.isEmpty()) {
            return;
        }
        this.toCopy.clear();
        this.viewer.expandAll();
        this.copyItems(tree.getItems());
    }

    private void copyItems(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            IExtendedPath path;
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof IExtendedPath && this.toSelect.contains(path = (IExtendedPath)data)) {
                this.toCopy.add(path);
            }
            this.copyItems(treeItem.getItems());
            ++n2;
        }
    }

    private void selectAll(Tree tree) {
        this.toSelect.clear();
        this.viewer.expandAll();
        this.selectItems(tree.getItems());
    }

    private void selectItems(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            Object data = treeItem.getData();
            if (data instanceof IExtendedPath) {
                this.toSelect.add((IExtendedPath)data);
            }
            this.selectItems(treeItem.getItems());
            ++n2;
        }
    }

    protected boolean isDirectorySelectable(IExtendedPath directory) {
        return directory.matchedChildren(this.matcher, false, null).length > 0;
    }

    static InputWrapper wrap(final SdkDataHolder input) {
        return new InputWrapper(){

            @Override
            public SdkDataHolder get() {
                return input;
            }
        };
    }

    protected List<IExtendedPath> getMatchedSelectableFolders(IExtendedPath parentPath) {
        return Collections.emptyList();
    }

    public Object getInput() {
        return this.viewer.getInput();
    }

    class CopyColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public CopyColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (!CustomTreeViewer.this.isEditable) {
                return false;
            }
            if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                return path.toFile().isFile() && CustomTreeViewer.this.toSelect.contains(path);
            }
            return false;
        }

        protected Boolean getValue(Object element) {
            return CustomTreeViewer.this.toCopy.contains(element);
        }

        protected void setValue(Object element, Object value) {
            boolean copy = (Boolean)value;
            if (copy) {
                CustomTreeViewer.this.toCopy.add((IExtendedPath)element);
            } else {
                CustomTreeViewer.this.toCopy.remove(element);
            }
            this.getViewer().refresh();
        }
    }

    class CopyColumnLabelProvider
    extends CellLabelProvider {
        CopyColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                boolean copy = CustomTreeViewer.this.toCopy.contains(path);
                boolean canEdit = path.toFile().isFile() && CustomTreeViewer.this.toSelect.contains(path);
                cell.setImage(ICONS[copy ? 1 : 0][canEdit ? 1 : 0]);
            }
        }
    }

    static interface InputWrapper {
        public SdkDataHolder get();
    }

    protected class ModuleResources {
        private String moduleName;
        private IExtendedPath rootPath;
        private List<IExtendedPath> resourcesPaths;

        protected ModuleResources(String moduleName, IExtendedPath rootPath, List<IExtendedPath> resourcesPaths) {
            this.moduleName = moduleName;
            this.rootPath = rootPath;
            this.resourcesPaths = resourcesPaths;
        }

        protected String getModuleName() {
            return this.moduleName;
        }

        protected IExtendedPath getRootPath() {
            return this.rootPath;
        }

        protected List<IExtendedPath> getPaths() {
            return this.resourcesPaths != null ? this.resourcesPaths : Collections.emptyList();
        }
    }

    class MultiColumnLabelProvider
    extends CellLabelProvider {
        private final int index;

        public MultiColumnLabelProvider(int i) {
            this.index = i;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                boolean copy = CustomTreeViewer.this.multiData[this.index][0].contains(path);
                boolean canEdit = path.toFile().isFile() && CustomTreeViewer.this.multiData[this.index][1].contains(path);
                cell.setImage(ICONS[copy ? 1 : 0][canEdit ? 1 : 0]);
            }
        }
    }

    class NameColumnLabelProvider
    extends ColumnLabelProvider {
        NameColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof SdkDataHolder) {
                IExtendedPath rootPath = ((SdkDataHolder)element).getRootPath();
                String sdkFolderName = rootPath.lastSegment();
                return sdkFolderName != null ? sdkFolderName : rootPath.toOSString();
            }
            if (element instanceof ModuleResources) {
                return ((ModuleResources)element).getModuleName();
            }
            if (element instanceof IExtendedPath) {
                return ((IExtendedPath)element).lastSegment();
            }
            return super.getText(element);
        }
    }

    static class SdkDataHolder {
        private IExtendedPath rootPath;
        private SdkModulesHolder modulesHolder;

        SdkDataHolder() {
        }

        void setRootPath(String rootPath) {
            this.rootPath = ExtendedPath.fromOSString(rootPath, true);
        }

        IExtendedPath getRootPath() {
            return this.rootPath;
        }

        void setModulesHolder(SdkModulesHolder modulesHolder) {
            this.modulesHolder = modulesHolder;
        }

        Set<SdkModule> getModulesHolder() {
            return this.modulesHolder != null ? this.modulesHolder.getRefModules() : Collections.emptySet();
        }
    }

    class SelectColumnEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor;

        public SelectColumnEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new CheckboxCellEditor();
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            if (element instanceof SdkDataHolder) {
                return CustomTreeViewer.this.isDirectorySelectable(((SdkDataHolder)element).getRootPath());
            }
            if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                return path.toFile().isDirectory() ? CustomTreeViewer.this.isDirectorySelectable(path) : !CustomTreeViewer.this.selectSiblings;
            }
            return false;
        }

        protected Boolean getValue(Object element) {
            if (element instanceof SdkDataHolder) {
                return CustomTreeViewer.this.toSelectFolder.contains(((SdkDataHolder)element).getRootPath());
            }
            if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                return path.toFile().isDirectory() ? CustomTreeViewer.this.toSelectFolder.contains(path) : CustomTreeViewer.this.toSelect.contains(path);
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            boolean isSelected = (Boolean)value;
            if (element instanceof SdkDataHolder) {
                this.handleDirectorySelection(((SdkDataHolder)element).getRootPath(), isSelected);
            } else if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                if (path.toFile().isDirectory()) {
                    this.handleDirectorySelection(path, isSelected);
                } else {
                    this.handleFileSelection(path, isSelected);
                }
            }
            this.getViewer().refresh();
        }

        private void handleDirectorySelection(IExtendedPath path, boolean isSelected) {
            IExtendedPath.PathList toProcess = new IExtendedPath.PathList();
            toProcess.addAll(Arrays.asList(path.matchedChildren(CustomTreeViewer.this.matcher, false, null)));
            if (isSelected) {
                CustomTreeViewer.this.toSelectFolder.add(path);
                CustomTreeViewer.this.toSelect.addAll(toProcess);
            } else {
                CustomTreeViewer.this.toSelectFolder.remove(path);
                CustomTreeViewer.this.toSelect.removeAll(toProcess);
            }
        }

        private void handleFileSelection(IExtendedPath path, boolean isSelected) {
            IExtendedPath.PathList toProcess = new IExtendedPath.PathList();
            toProcess.add(path);
            if (isSelected) {
                CustomTreeViewer.this.toSelect.addAll(toProcess);
            } else {
                CustomTreeViewer.this.toSelect.removeAll(toProcess);
            }
        }
    }

    class SelectColumnLabelProvider
    extends CellLabelProvider {
        SelectColumnLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            boolean isCellEditable = false;
            boolean isCellSelected = false;
            if (element instanceof SdkDataHolder) {
                IExtendedPath path = ((SdkDataHolder)element).getRootPath();
                isCellEditable = !path.isEmpty() && CustomTreeViewer.this.isDirectorySelectable(path);
                isCellSelected = !CustomTreeViewer.this.toSelectFolder.isEmpty() && CustomTreeViewer.this.toSelectFolder.contains(path) && !CustomTreeViewer.this.toSelect.isEmpty();
            } else if (element instanceof IExtendedPath) {
                IExtendedPath path = (IExtendedPath)element;
                boolean bl = isCellEditable = !path.isEmpty();
                if (path.toFile().isDirectory()) {
                    isCellSelected = CustomTreeViewer.this.toSelectFolder.contains(path);
                    isCellEditable &= CustomTreeViewer.this.isDirectorySelectable(path);
                } else {
                    isCellSelected = CustomTreeViewer.this.toSelect.contains(path);
                }
            }
            this.updateCell(cell, isCellSelected, isCellEditable);
        }

        private void updateCell(ViewerCell cell, boolean isCellSelected, boolean isCellEditable) {
            cell.setImage(ICONS[isCellSelected ? 1 : 0][isCellEditable ? 1 : 0]);
        }
    }

    protected class SourcesTreeContentProvider
    implements ITreeContentProvider {
        protected SourcesTreeContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            if (element instanceof IPath) {
                IPath path = (IPath)element;
                java.nio.file.Path p = Paths.get(path.toOSString(), new String[0]);
                java.nio.file.Path parent = p.getParent();
                return parent == null ? null : ExtendedPath.fromOSString((String)parent.toFile().getAbsolutePath());
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof InputWrapper) {
                return new SdkDataHolder[]{((InputWrapper)parentElement).get()};
            }
            if (parentElement instanceof SdkDataHolder) {
                return this.getModulesResources((SdkDataHolder)parentElement);
            }
            if (parentElement instanceof ModuleResources) {
                ModuleResources mr = (ModuleResources)parentElement;
                return this.getMatchedChildren(mr.getRootPath()).stream().filter(path -> path.toFile().isDirectory() || mr.getPaths().contains(path)).collect(Collectors.toSet()).toArray(new IExtendedPath[0]);
            }
            if (parentElement instanceof IExtendedPath) {
                return this.getMatchedChildren((IExtendedPath)parentElement).toArray(new IExtendedPath[0]);
            }
            return new Object[0];
        }

        protected Object[] getModulesResources(SdkDataHolder sdkDataHolder) {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            Set<SdkModule> refModules = sdkDataHolder.getModulesHolder();
            if (refModules.isEmpty()) {
                result.addAll(this.getMatchedChildren(sdkDataHolder.getRootPath()));
            } else {
                for (SdkModule refModule : refModules) {
                    ISDK refSdk = refModule.getSdk();
                    if (refSdk == null) continue;
                    IExtendedPath rootPath = ExtendedPath.fromOSString(refSdk.getHeader().getBasePath(), true);
                    ArrayList<IExtendedPath> resourcesPaths = new ArrayList<IExtendedPath>();
                    TCHolder rootToolChainHolder = refSdk.getRoot();
                    resourcesPaths.addAll(rootToolChainHolder.getSources().stream().collect(Collectors.toList()));
                    resourcesPaths.addAll(rootToolChainHolder.getBinaries().stream().collect(Collectors.toList()));
                    resourcesPaths.addAll(rootToolChainHolder.getLinkerFiles().stream().collect(Collectors.toList()));
                    resourcesPaths.addAll(rootToolChainHolder.getUntypedResources().stream().collect(Collectors.toList()));
                    result.add(new ModuleResources(refModule.getName(), rootPath, resourcesPaths));
                }
            }
            return result.toArray();
        }

        protected Set<IExtendedPath> getMatchedChildren(IExtendedPath parentPath) {
            LinkedHashSet<IExtendedPath> result = new LinkedHashSet<IExtendedPath>();
            if (CustomTreeViewer.this.isEditable) {
                result.addAll(CustomTreeViewer.this.getMatchedSelectableFolders(parentPath));
            }
            result.addAll(Arrays.asList(parentPath.matchedChildren(CustomTreeViewer.this.matcher, true, CustomTreeViewer.this.selectedFileFilter)));
            return result;
        }
    }
}

