/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.ui.internal.CustomTreeViewer;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ConflictedFilesTreeViewer
extends CustomTreeViewer {
    private static final String[][] columnsCaptions = new String[][]{{Messages.ConflictedFilesTreeViewer_replace_column_title}, {""}};
    private Map<String, Set<IExtendedPath>> conflictedFiles;
    private Button overrideAllCheckBox;
    private boolean isBackupFiles = true;

    public ConflictedFilesTreeViewer(Composite parent, PathMatcher matcher) {
        super(parent, matcher, true, false, "O", columnsCaptions);
        Composite checkersGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        checkersGroup.setLayout((Layout)layout);
        this.createOverrideCheckBox(checkersGroup);
        this.createBackupFilesCheckBox(checkersGroup);
        Label text = new Label(parent, 0);
        text.setText(Messages.SDKConflictedFilesDialog_message_note);
    }

    @Override
    protected void addExtraColumns(String[][] columnsHeads) {
        TreeViewerColumn overrideColumn = new TreeViewerColumn(this.viewer, 0);
        overrideColumn.getColumn().setText(columnsCaptions[0][0]);
        overrideColumn.getColumn().setWidth(70);
        overrideColumn.setLabelProvider((CellLabelProvider)new CustomTreeViewer.SelectColumnLabelProvider(this));
        overrideColumn.setEditingSupport((EditingSupport)new CFSelectColumnEditingSupport((ColumnViewer)this.viewer));
    }

    @Override
    protected Menu getMenu(Tree t) {
        Menu menu = new Menu((Control)t);
        this.addItem(menu, t, Messages.ConflictedFilesTreeViewer_replace_all_menu_item_text, 1);
        this.addItem(menu, t, Messages.ConflictedFilesTreeViewer_replace_none_menu_item_text, 2);
        return menu;
    }

    @Override
    protected void switchSelection(Tree t, int id) {
        switch (id) {
            case 1: {
                this.toSelect.clear();
                this.forEach(t.getItems(), 1);
                this.overrideAllCheckBox.setSelection(true);
                break;
            }
            case 2: {
                this.toSelect.clear();
                this.toSelectFolder.clear();
                this.overrideAllCheckBox.setSelection(false);
            }
        }
    }

    protected void forEach(TreeItem[] tis, int id) {
        TreeItem[] treeItemArray = tis;
        int n = tis.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            Object data = ti.getData();
            if (data instanceof IExtendedPath) {
                IExtendedPath ep = (IExtendedPath)ti.getData();
                if (ep.isDirectory()) {
                    this.toSelectFolder.add(ep);
                } else {
                    this.toSelect.add(ep);
                }
            }
            this.forEach(ti.getItems(), 1);
            ++n2;
        }
    }

    public void setBackupFiles(boolean isBackupFiles) {
        this.isBackupFiles = isBackupFiles;
    }

    public boolean isBackupFiles() {
        return this.isBackupFiles;
    }

    private void createOverrideCheckBox(Composite parent) {
        this.overrideAllCheckBox = new Button(parent, 32);
        this.overrideAllCheckBox.setText(Messages.ConflictedFilesTreeViewer_replace_all_checkbox_text);
        this.overrideAllCheckBox.setSelection(true);
        this.overrideAllCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictedFilesTreeViewer.this.switchSelection(ConflictedFilesTreeViewer.this.viewer.getTree(), ((Button)e.getSource()).getSelection() ? 1 : 2);
                ConflictedFilesTreeViewer.this.viewer.refresh();
            }
        });
    }

    private void createBackupFilesCheckBox(Composite parent) {
        Button backupFilesCheckBox = new Button(parent, 32);
        backupFilesCheckBox.setText(Messages.ConflictedFilesTreeViewer_backup_files_checkbox_text);
        backupFilesCheckBox.setSelection(true);
        backupFilesCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConflictedFilesTreeViewer.this.setBackupFiles(((Button)e.getSource()).getSelection());
            }
        });
    }

    void setConflictedFiles(Map<String, Set<IExtendedPath>> conflictedFiles) {
        this.conflictedFiles = conflictedFiles;
    }

    class CFSelectColumnEditingSupport
    extends CustomTreeViewer.SelectColumnEditingSupport {
        public CFSelectColumnEditingSupport(ColumnViewer viewer) {
            super(ConflictedFilesTreeViewer.this, viewer);
        }

        @Override
        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            ConflictedFilesTreeViewer.this.overrideAllCheckBox.setSelection(this.isSelectedAll());
        }

        private boolean isSelectedAll() {
            return Arrays.stream(ConflictedFilesTreeViewer.this.getChecked()).filter(p -> !p.toFile().isDirectory()).count() == ConflictedFilesTreeViewer.this.conflictedFiles.values().stream().flatMap(Collection::stream).count();
        }
    }
}

