/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui;

import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKSelectDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SDKDialogCellEditor
extends DialogCellEditor {
    private final ISDKFilterInfo filterInfo;

    public static Control getControl(Composite parent, CProjectContext projectContext, ISDKFilterInfo info, final SDKDialogEditorListener listener) {
        final SDKDialogCellEditor editor = new SDKDialogCellEditor(parent, 2048, info);
        List<? extends IModelSDK> sdks = SDKDialogCellEditor.getSdkListFilteredByTags(projectContext);
        List<? extends IModelSDK> choosenSdks = SDKDialogCellEditor.getSdkListFilteredByVersion(sdks);
        if (choosenSdks != null && !choosenSdks.isEmpty()) {
            editor.setValue(choosenSdks.stream().toArray());
        }
        editor.addListener(new ICellEditorListener(){
            private Object previousValue = null;

            public void editorValueChanged(boolean oldState, boolean newState) {
            }

            public void cancelEditor() {
            }

            public void applyEditorValue() {
                Object value = editor.getValue();
                if (listener != null && value != null) {
                    if (value.equals(this.previousValue)) {
                        return;
                    }
                    this.previousValue = value;
                    Object[] ary = (Object[])value;
                    ArrayList<ISDK> sdks = new ArrayList<ISDK>();
                    Object[] objectArray = ary;
                    int n = ary.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof ISDK) {
                            sdks.add((ISDK)o);
                        }
                        ++n2;
                    }
                    listener.applyValue(sdks);
                }
            }
        });
        return editor.getControl();
    }

    public SDKDialogCellEditor(Composite parent, int style, ISDKFilterInfo info) {
        super(parent, style);
        this.filterInfo = info;
    }

    private static List<? extends IModelSDK> getSdkListFilteredByTags(CProjectContext pc) {
        if (pc == null) {
            return Collections.emptyList();
        }
        ProcessorData pd = pc.getProcessor();
        if (pd == null) {
            return Collections.emptyList();
        }
        String tag = pd.getSdkTag();
        if (tag == null || tag.isEmpty()) {
            return Collections.emptyList();
        }
        List sdkList = pc.getSdkList();
        if (sdkList == null || sdkList.isEmpty()) {
            return Collections.emptyList();
        }
        return sdkList.stream().filter(sdk -> SDKDialogCellEditor.containsTag(sdk, tag)).collect(Collectors.toList());
    }

    private static List<? extends IModelSDK> getSdkListFilteredByVersion(List<? extends IModelSDK> sdkList) {
        if (sdkList == null || sdkList.isEmpty()) {
            return Collections.emptyList();
        }
        IModelSDK sdkWithMaxVersion = sdkList.stream().max(Comparator.comparing(IModelSDK::getVersion)).orElse(null);
        if (sdkWithMaxVersion == null) {
            return Collections.emptyList();
        }
        String maxVersion = sdkWithMaxVersion.getVersion();
        if (maxVersion == null) {
            return Arrays.asList(sdkWithMaxVersion);
        }
        return sdkList.stream().filter(sdk -> sdk.getVersion().equals(maxVersion)).collect(Collectors.toList());
    }

    private static boolean containsTag(IModelSDK modelSdk, String sdkTag) {
        if (modelSdk instanceof ISDK) {
            ISDK sdk = (ISDK)modelSdk;
            Set<String> tags = sdk.getTags();
            return tags != null && tags.contains(sdkTag);
        }
        return false;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        SDKSelectDialog dialog = new SDKSelectDialog(cellEditorWindow.getShell(), this.filterInfo, this.getValue());
        if (dialog.open() == 0) {
            return dialog.get();
        }
        return null;
    }

    public void deactivate() {
    }

    protected void updateContents(Object value) {
        Object[] selection = this.checkNullAndCastToArray(value);
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof ISDK) {
                sb.append(((ISDK)o).getName()).append(", ");
            }
            ++n2;
        }
        int length = sb.length();
        if (length > 0) {
            sb.delete(length - 2, length);
        }
        value = sb.toString();
        super.updateContents(value);
    }

    private Object[] checkNullAndCastToArray(Object value) {
        return value != null ? (Object[])value : new Object[]{};
    }

    public static interface SDKDialogEditorListener {
        public void applyValue(List<? extends IModelSDK> var1);
    }
}

