/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.validation;

import com.freescale.s32ds.cross.sdk.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkTargetFolderNameValidator
implements IValidator {
    private static final String SDK_TARGET_FOLDER_NAME_PATTERN = "^[a-zA-Z0-9_]*$";
    private static final int SDK_TARGET_FOLDER_NAME_MAX_LENGTH = 250;

    public IStatus validate(Object value) {
        if (value != null && !(value instanceof String)) {
            return ValidationStatus.error((String)"Unexpected input");
        }
        String name = (String)value;
        if (name == null || name.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return ValidationStatus.error((String)Messages.SDKDialog_target_folder_name_start_letter_error);
        }
        if (name.length() > 250) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDialog_target_folder_name_too_long_error, (Object)250));
        }
        if (!name.matches(SDK_TARGET_FOLDER_NAME_PATTERN)) {
            return ValidationStatus.error((String)Messages.SDKDialog_target_folder_name_symbols_error);
        }
        return Status.OK_STATUS;
    }
}

