/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.validation;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class SdkModuleValidator
implements IValidator {
    public IStatus validate(Object value) {
        if (value instanceof IConfigurationElement) {
            return this.validateAttributes((IConfigurationElement)value);
        }
        if (value instanceof Element) {
            return this.validateAttributes((Element)value);
        }
        return ValidationStatus.error((String)"Unexpected input");
    }

    private IStatus validateAttributes(IConfigurationElement ce) {
        IStatus status = this.validateAttributeNotEmpty(ce.getAttribute("id"), Messages.SdkModuleValidator_module_id_empty);
        if (status.isOK()) {
            status = this.validateAttributeNotEmpty(ce.getAttribute("name"), Messages.SdkModuleValidator_module_name_empty);
        }
        if (status.isOK()) {
            status = this.validateSdkIdAttribute(ce);
        }
        return status;
    }

    private IStatus validateAttributes(Element ce) {
        IStatus status = this.validateAttributeNotEmpty(ce.getAttribute("id"), Messages.SdkModuleValidator_module_id_empty);
        if (status.isOK()) {
            status = this.validateAttributeNotEmpty(ce.getAttribute("name"), Messages.SdkModuleValidator_module_name_empty);
        }
        if (status.isOK()) {
            status = this.validateSdkIdAttribute(ce);
        }
        return status;
    }

    private IStatus validateAttributeNotEmpty(String attributeValue, String errorMessage) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            return ValidationStatus.error((String)errorMessage);
        }
        return Status.OK_STATUS;
    }

    private IStatus validateSdkIdAttribute(IConfigurationElement ce) {
        String sdkId;
        String refSdkId;
        IConfigurationElement sdkElement;
        IStatus status = Status.OK_STATUS;
        IConfigurationElement modulesElement = (IConfigurationElement)ce.getParent();
        if (modulesElement != null && "modules".equals(modulesElement.getName()) && (sdkElement = (IConfigurationElement)modulesElement.getParent()) != null && "sdk".equals(sdkElement.getName()) && (status = this.validateAttributeNotEmpty(refSdkId = ce.getAttribute("sdkId"), Messages.SdkModuleValidator_module_sdk_id_empty)).isOK() && (sdkId = SDKHeader.makeId(sdkElement.getAttribute("name"), sdkElement.getAttribute("version"))).equals(refSdkId)) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkModuleValidator_module_refers_to_holder_sdk, (Object)ce.getAttribute("id"), (Object)sdkId));
        }
        return status;
    }

    private IStatus validateSdkIdAttribute(Element ce) {
        String sdkId;
        String refSdkId;
        Element sdkElement;
        IStatus status = Status.OK_STATUS;
        Element modulesElement = (Element)ce.getParentNode();
        if (modulesElement != null && "modules".equals(modulesElement.getNodeName()) && (sdkElement = (Element)modulesElement.getParentNode()) != null && "sdk".equals(sdkElement.getNodeName()) && (status = this.validateAttributeNotEmpty(refSdkId = ce.getAttribute("sdkId"), Messages.SdkModuleValidator_module_sdk_id_empty)).isOK() && (sdkId = SDKHeader.makeId(sdkElement.getAttribute("name"), sdkElement.getAttribute("version"))).equals(refSdkId)) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkModuleValidator_module_refers_to_holder_sdk, (Object)ce.getAttribute("id"), (Object)sdkId));
        }
        return status;
    }
}

