/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.validation;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.internal.SDKVersion;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SDKVersionValidator
implements IValidator {
    public IStatus validate(Object value) {
        if (value != null && !(value instanceof String)) {
            return ValidationStatus.error((String)"Unexpected input");
        }
        String version = (String)value;
        if (version == null || version.isEmpty()) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDialog_empty_version_error_text, null));
        }
        try {
            SDKVersion.parseVersion(version);
        }
        catch (IllegalArgumentException iae) {
            return ValidationStatus.error((String)iae.getMessage());
        }
        return Status.OK_STATUS;
    }
}

