/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.validation;

import com.freescale.s32ds.cross.sdk.Messages;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SDKNameValidator
implements IValidator {
    private static final String SDK_NAME_PATTERN = "^[a-zA-Z0-9_]*$";
    private static final int SDK_NAME_MAX_LENGTH = 250;

    public IStatus validate(Object value) {
        if (value != null && !(value instanceof String)) {
            return ValidationStatus.error((String)"Unexpected input");
        }
        String name = (String)value;
        if (name == null || name.isEmpty()) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDialog_empty_name_error_text, null));
        }
        if (!Character.isLetter(name.charAt(0))) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDialog_start_name_error_text, null));
        }
        if (name.length() > 250) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKEditDialog_name_too_long, null));
        }
        if (!name.matches(SDK_NAME_PATTERN)) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SDKDialog_lnu_name_error_text, null));
        }
        return Status.OK_STATUS;
    }
}

