/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.validation;

import com.freescale.s32ds.cross.sdk.internal.validation.SDKNameValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKVersionValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SdkBasePathValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SdkSymbolsValidator;
import com.freescale.s32ds.cross.sdk.internal.validation.SdkTargetFolderNameValidator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Element;

public class SDKHeaderValidator
implements IValidator {
    private IValidator sdkNameValidator = new SDKNameValidator();
    private IValidator sdkVersionValidator = new SDKVersionValidator();
    private IValidator sdkTargetFolderNameValidator = new SdkTargetFolderNameValidator();
    private IValidator sdkBasePathValidator = new SdkBasePathValidator();
    private IValidator sdkSymbolsValidator = new SdkSymbolsValidator();

    public IStatus validate(Object value) {
        if (value instanceof IConfigurationElement) {
            return this.validateAttributes((IConfigurationElement)value);
        }
        if (value instanceof Element) {
            return this.validateAttributes((Element)value);
        }
        return ValidationStatus.error((String)"Unexpected input");
    }

    private IStatus validateAttributes(IConfigurationElement ce) {
        IStatus status = this.sdkNameValidator.validate((Object)ce.getAttribute("name"));
        if (status.isOK()) {
            status = this.sdkVersionValidator.validate((Object)ce.getAttribute("version"));
        }
        if (status.isOK()) {
            status = this.sdkBasePathValidator.validate((Object)ce.getAttribute("basePath"));
        }
        if (status.isOK()) {
            status = this.sdkTargetFolderNameValidator.validate((Object)ce.getAttribute("targetFolderName"));
        }
        if (status.isOK()) {
            status = this.validateSymbols(ce.getAttribute("symbols"));
        }
        return status;
    }

    private IStatus validateAttributes(Element ce) {
        IStatus status = this.sdkNameValidator.validate((Object)ce.getAttribute("name"));
        if (status.isOK()) {
            status = this.sdkVersionValidator.validate((Object)ce.getAttribute("version"));
        }
        if (status.isOK()) {
            status = this.sdkBasePathValidator.validate((Object)ce.getAttribute("basePath"));
        }
        if (status.isOK()) {
            status = this.validateSymbols(ce.getAttribute("symbols"));
        }
        return status;
    }

    private IStatus validateSymbols(String symbols) {
        IStatus status = Status.OK_STATUS;
        if (symbols == null) {
            return Status.OK_STATUS;
        }
        String[] stringArray = symbols.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String symbol = stringArray[n2];
            status = this.sdkSymbolsValidator.validate((Object)symbol.trim());
            if (!status.isOK()) {
                return status;
            }
            ++n2;
        }
        return status;
    }
}

