/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.hook;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class ProcessorExpertFileAdjuster {
    private static final String[] PE_FILE_REPLACEMENT_HOLDERS = new String[]{"Options", "CPU", "Bean"};
    private Map<String, String> pexReplacementValues;

    public IStatus adjustProcessorExpertFile(ISDK sdk, IProject project, Map<String, String> pexReplacementValues, boolean isAutoReplace) {
        if (!project.isAccessible()) {
            SDKSupportPlugin.error(NLS.bind((String)Messages.ProcessorExpertFileAdjuster_error_project_inaccessible, (Object)project.getName()), null);
            return Status.CANCEL_STATUS;
        }
        this.pexReplacementValues = pexReplacementValues;
        IExtendedPath pexFileEP = Stream.of(sdk.getRoot().get(3)).filter(f -> f.getFileExtension().equals("pe") && f.isCopy() && !f.isOverride()).findFirst().orElse(null);
        if (pexFileEP == null) {
            SDKSupportPlugin.error(Messages.ProcessorExpertFileAdjuster_error_pex_file_null, null);
            return Status.CANCEL_STATUS;
        }
        IFile pexFile = SDKResourcesHandler.INSTANCE.getTargetFile(pexFileEP, sdk, project);
        if (pexFile == null || !pexFile.exists()) {
            SDKSupportPlugin.log((IStatus)new Status(2, SDKSupportPlugin.getUniqueIdentifier(), Messages.ProcessorExpertFileAdjuster_error_pex_file_not_found));
            return Status.CANCEL_STATUS;
        }
        boolean isProcess = true;
        if (!isAutoReplace) {
            isProcess = this.showConfirmMessage("SDK Attach Confirmation", NLS.bind((String)Messages.ProcessorExpertFileAdjuster_confirmation_message, (Object)pexFile.getName()));
        }
        if (isProcess) {
            return this.processFile(pexFile.getLocationURI());
        }
        return Status.CANCEL_STATUS;
    }

    public IFile getProcessorExpertFile(ISDK sdk, IProject project) {
        if (!project.isAccessible()) {
            SDKSupportPlugin.error(NLS.bind((String)Messages.ProcessorExpertFileAdjuster_error_project_inaccessible, (Object)project.getName()), null);
            return null;
        }
        IExtendedPath sdkPExFile = Stream.of(sdk.getRoot().get(3)).filter(f -> f.getFileExtension().equals("pe") && f.isCopy() && !f.isOverride()).findFirst().orElse(null);
        if (sdkPExFile == null) {
            return null;
        }
        return SDKResourcesHandler.INSTANCE.getTargetFile(sdkPExFile, sdk, project);
    }

    private IStatus processFile(URI fileUri) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(fileUri)));){
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                documentBuilder.setErrorHandler(new DefaultHandler());
                Document document = documentBuilder.parse(bis);
                Element peProjectRoot = document.getDocumentElement();
                String[] stringArray = PE_FILE_REPLACEMENT_HOLDERS;
                int n = PE_FILE_REPLACEMENT_HOLDERS.length;
                int n2 = 0;
                while (n2 < n) {
                    String holder = stringArray[n2];
                    this.replaceValues(peProjectRoot.getElementsByTagName(holder));
                    ++n2;
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(document);
                StreamResult outputTarget = new StreamResult(new FileOutputStream(new File(fileUri)));
                transformer.transform(source, outputTarget);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void replaceValues(NodeList holderNodes) {
        int i = 0;
        while (i < holderNodes.getLength()) {
            NodeList children = holderNodes.item(i).getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Element el;
                String replacementValue;
                Node childNode = children.item(j);
                if (childNode instanceof Element && (replacementValue = this.pexReplacementValues.get((el = (Element)childNode).getNodeName())) != null) {
                    el.setTextContent(replacementValue);
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean showConfirmMessage(String title, String message) {
        Status status = new Status(2, SDKSupportPlugin.getUniqueIdentifier(), message, null);
        try {
            Object result = RcpStatusHandlers.handleStatus((String)"com.freescale.s32ds.cross.sdk.support.sdkAttachStatusHandler", (IStatus)status, null);
            return result instanceof Boolean && (Boolean)result != false;
        }
        catch (CoreException ce) {
            SDKSupportPlugin.error(ce);
            return false;
        }
    }
}

