/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.attach;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.ISDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.ISDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.namechecker.ISDKNameChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.namechecker.SDKNameChecker;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModulesChecker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;

public class SDKAttachStatusesResolver {
    public static final SDKAttachStatusesResolver INSTANCE = new SDKAttachStatusesResolver();
    private ISDKAvailabilityChecker availabilityChecker = new SDKAvailabilityChecker();
    private ISDKCompatibilityChecker compatibilityChecker = new SDKCompatibilityChecker();
    private ISDKNameChecker nameChecker = new SDKNameChecker();
    private SdkModulesChecker modulesChecker = new SdkModulesChecker();

    public Map<String, List<IStatus>> resolveAttachStatuses(IProject project, List<ISDK> sdks) {
        HashMap<String, List<IStatus>> result = new HashMap<String, List<IStatus>>();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null) {
            IConfiguration[] cfgs = buildInfo.getManagedProject().getConfigurations();
            for (ISDK sdk : sdks) {
                ArrayList<IStatus> sdkAttachStatuses = new ArrayList<IStatus>();
                IConfiguration[] iConfigurationArray = cfgs;
                int n = cfgs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfiguration configuration = iConfigurationArray[n2];
                    sdkAttachStatuses.add(this.resolveAttachStatus(sdk, project, configuration));
                    ++n2;
                }
                result.put(sdk.getId(), sdkAttachStatuses);
            }
        }
        return result;
    }

    public IStatus resolveAttachStatus(ISDK sdk, IProject project, IConfiguration configuration) {
        IStatus result = this.availabilityChecker.checkAvailability(sdk);
        if (result.isOK()) {
            result = this.compatibilityChecker.checkPlatform(project, sdk);
        }
        if (result.isOK()) {
            result = this.compatibilityChecker.checkPlatformHost(project, sdk);
        }
        if (result.isOK()) {
            result = this.compatibilityChecker.checkCore(sdk, project);
        }
        if (result.isOK()) {
            result = this.compatibilityChecker.checkLanguage(sdk, project);
        }
        if (result.isOK()) {
            result = this.compatibilityChecker.checkToolchainsCompatibility(sdk, project, configuration);
        }
        if (result.isOK()) {
            result = this.nameChecker.checkName(sdk, project);
        }
        if (result.isOK()) {
            result = this.modulesChecker.checkModulesAttachStatuses(sdk, project, configuration);
        }
        if (result.isOK()) {
            return this.getAttachStatus(sdk, project, configuration);
        }
        return result;
    }

    private IStatus getAttachStatus(ISDK sdk, IProject project, IConfiguration configuration) {
        return SDKAttach.isAttached(project.getName(), configuration.getName(), sdk.getId()) ? ISDKAttachStatuses.OK_SDK_ATTACHED : ISDKAttachStatuses.OK_SDK_NOT_ATTACHED;
    }
}

