/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal.attach;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import com.freescale.s32ds.cross.sdk.internal.attach.SDKAttachStatusesResolver;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;

public class SDKAttachStatusesHolder {
    public static final SDKAttachStatusesHolder INSTANCE = new SDKAttachStatusesHolder();
    private Map<String, List<IStatus>> actualSDKsAttachStates = new LinkedHashMap<String, List<IStatus>>();
    private Map<String, List<IStatus>> backupSDKsAttachStates = new LinkedHashMap<String, List<IStatus>>();

    public void loadAvailableSDKsAttachStates(IProject project) {
        this.actualSDKsAttachStates = this.getResolvedAttachStates(project);
        this.backupSDKsAttachStates = SDKAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
    }

    public List<ISDK> getSDKsByStatus(IProject project, IStatus status) {
        ArrayList<ISDK> unavailableSDKs = new ArrayList<ISDK>();
        for (Map.Entry<String, List<IStatus>> e : this.actualSDKsAttachStates.entrySet()) {
            List<IStatus> sdkStatuses = e.getValue();
            if (!sdkStatuses.get(0).equals(status)) continue;
            unavailableSDKs.add(SDKUtils.getSDKbyID(e.getKey()));
        }
        return unavailableSDKs;
    }

    public Map<String, List<IStatus>> getActualSDKsAttachStates() {
        return this.actualSDKsAttachStates;
    }

    public Map<String, List<IStatus>> getActualSDKsAttachStatesCopy() {
        return SDKAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
    }

    public Map<String, List<IStatus>> getBackupSDKsAttachStates() {
        return this.backupSDKsAttachStates;
    }

    public void addSDKAttachStates(String sdkId, List<IStatus> statuses) {
        this.actualSDKsAttachStates.put(sdkId, statuses);
    }

    public void addSdkAttachStates(ISDK sdk, IProject project) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
        if (bi != null) {
            IConfiguration[] configurations;
            IConfiguration[] iConfigurationArray = configurations = bi.getManagedProject().getConfigurations();
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration configuration = iConfigurationArray[n2];
                statuses.add(SDKAttachStatusesResolver.INSTANCE.resolveAttachStatus(sdk, project, configuration));
                ++n2;
            }
        }
        this.addSDKAttachStates(sdk.getId(), statuses);
    }

    public List<IStatus> getSDKAttachStates(String sdkId) {
        return this.actualSDKsAttachStates.get(sdkId);
    }

    public void removeSDKAttachStates(List<ISDK> removedSDKs, IProject project) {
        removedSDKs.stream().forEach(sdk -> {
            List<IStatus> list = this.actualSDKsAttachStates.remove(sdk.getId());
        });
        this.getResolvedAttachStates(project).entrySet().stream().filter(e -> ((IStatus)((List)e.getValue()).get(0)).equals(ISDKAttachStatuses.ERROR_SDK_LOCATION)).map(e -> SDKUtils.getSDKbyID((String)e.getKey())).forEach(sdk -> this.addSdkAttachStates((ISDK)sdk, project));
    }

    public List<IStatus> getSDKAttachStates(ISDK sdk, IProject project) {
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
        if (bi != null) {
            IConfiguration[] configs = bi.getManagedProject().getConfigurations();
            return configs != null ? Stream.of(configs).map(config -> SDKAttachStatusesResolver.INSTANCE.resolveAttachStatus(sdk, project, (IConfiguration)config)).collect(Collectors.toList()) : new ArrayList<IStatus>();
        }
        return new ArrayList<IStatus>();
    }

    public void commitSDKsAttachStates() {
        this.backupSDKsAttachStates = SDKAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
    }

    private static Map<String, List<IStatus>> copyData(Map<String, List<IStatus>> map) {
        LinkedHashMap<String, List<IStatus>> data = new LinkedHashMap<String, List<IStatus>>();
        for (String sdkId : map.keySet()) {
            List<IStatus> statuses = map.get(sdkId);
            ArrayList<IStatus> copyStatuses = new ArrayList<IStatus>();
            for (IStatus status : statuses) {
                copyStatuses.add(status);
            }
            data.put(sdkId, copyStatuses);
        }
        return data;
    }

    private Map<String, List<IStatus>> getResolvedAttachStates(IProject project) {
        return SDKAttachStatusesResolver.INSTANCE.resolveAttachStatuses(project, SDKUtils.filter(AvailableSDKFilter.getNoOptionsFilter(project)));
    }
}

