/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class SDKVersion
implements Comparable<SDKVersion> {
    private static final String SEPARATOR = ".";
    private static final List<String> VERSION_PATTERNS = new ArrayList<String>();
    private int major = -1;
    private int minor = -1;
    private int micro = -1;
    private String qualifier = null;

    static {
        VERSION_PATTERNS.add("^(\\d+)$");
        VERSION_PATTERNS.add("^(\\d+)(?:\\.(\\d+))$");
        VERSION_PATTERNS.add("^(\\d+)(?:\\.(\\d+))(?:\\.(\\d+))$");
        VERSION_PATTERNS.add("^(\\d+)(?:\\.(\\d+))(?:\\.(\\d+))(?:\\.([a-zA-Z0-9_]+))$");
    }

    private SDKVersion(List<String> versionParts) {
        this.major = Integer.parseInt(versionParts.get(0));
        if (versionParts.size() > 1) {
            this.minor = Integer.parseInt(versionParts.get(1));
        }
        if (versionParts.size() > 2) {
            this.micro = Integer.parseInt(versionParts.get(2));
        }
        if (versionParts.size() > 3) {
            this.qualifier = versionParts.get(3);
        }
    }

    public static SDKVersion createVersion(String version) {
        List<String> parsedVersion = null;
        parsedVersion = SDKVersion.parseVersion(version);
        return new SDKVersion(parsedVersion);
    }

    public static List<String> parseVersion(String version) {
        ArrayList<String> parsedVersion = new ArrayList<String>();
        boolean isMatched = false;
        for (String pattern : VERSION_PATTERNS) {
            Pattern versionPattern = Pattern.compile(pattern);
            Matcher matcher = versionPattern.matcher(version);
            if (!matcher.find()) continue;
            int groupsCount = matcher.groupCount();
            if (groupsCount == 0 || groupsCount > 4) break;
            isMatched = true;
            int i = 1;
            while (i <= groupsCount) {
                parsedVersion.add(matcher.group(i));
                ++i;
            }
            break block0;
        }
        if (!isMatched || parsedVersion.isEmpty()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.SDKVersion_error_sdk_version, (Object)version));
        }
        int i = 0;
        while (i < parsedVersion.size()) {
            String part = (String)parsedVersion.get(i);
            if (i < 3 && part.length() > 1 && part.startsWith("0")) {
                throw new IllegalArgumentException(Messages.SDKVersion_error_sdk_version_has_zeros);
            }
            ++i;
        }
        return parsedVersion;
    }

    @Override
    public int compareTo(SDKVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        if (this.qualifier == null && other.qualifier == null) {
            return 0;
        }
        if (this.qualifier != null && other.qualifier == null) {
            return 1;
        }
        if (this.qualifier == null && other.qualifier != null) {
            return -1;
        }
        return this.qualifier.compareTo(other.qualifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.minor != -1) {
            sb.append(SEPARATOR).append(this.minor);
            if (this.micro != -1) {
                sb.append(SEPARATOR).append(this.micro);
                if (this.qualifier != null) {
                    sb.append(SEPARATOR).append(this.qualifier);
                }
            }
        }
        return sb.toString();
    }
}

