/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.nxp.s32ds.cle.ide.sdk.core.ContributedSdkHandler;
import com.nxp.s32ds.cle.ide.sdk.core.InternalSdkHandler;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.IStartup;

public class SDKSupportStartup
implements IStartup {
    public void earlyStartup() {
        final long startLoading = System.currentTimeMillis();
        WorkspaceJob wj = new WorkspaceJob("SDK Support Startup"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SDKSupportStartup.this.loadSDKs();
                return Status.OK_STATUS;
            }
        };
        wj.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                SDKUtils.handleConflictedSdks();
                SDKAttach.checkAttachedSdksExist();
                SDKUtils.cleanUnusedSdkEnvironmentVariables();
                SDKSupportPlugin.getDefault().addResourceChangeListeners();
                long finishLoading = System.currentTimeMillis();
                SDKSupportPlugin.log("Init SDKs, sec.: " + (double)(finishLoading - startLoading) / 1000.0);
            }
        });
        wj.schedule();
    }

    private void loadSDKs() {
        long startLoading = System.currentTimeMillis();
        InternalSdkHandler.loadInternalPersistedSDKs();
        ContributedSdkHandler.loadContributedSdks();
        ExternalSDK.loadExternalPersistedSDKs();
        ProjectLocalSDK.loadProjectLocalPersistedSDKs();
        ImportSDK.loadImportSDKs();
        long finishLoading = System.currentTimeMillis();
        SDKSupportPlugin.log("Load SDKs, sec.: " + (double)(finishLoading - startLoading) / 1000.0);
    }
}

