/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class SDKFilteringUtils {
    private static final String EP_HARDWARE = "com.freescale.s32ds.cross.core.Hardware";
    private static final String ELEMENT_HARDWARE = "hardware";
    private static final String ELEMENT_PROCESSORS = "processors";
    private static final String ELEMENT_PROCESSOR = "processor";
    private static final String ELEMENT_CORE_TYPES = "coreTypes";
    private static final String ELEMENT_CORE_TYPE = "coreType";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_CORE_KIND_ID = "coreKindId";
    private static Map<String, String> coreKindsMap = SDKFilteringUtils.loadCoreKindsMap();

    public static String getCoreKind(String deviceCoreId) {
        String coreKind = coreKindsMap.get(deviceCoreId);
        return coreKind != null ? coreKind : deviceCoreId;
    }

    public static boolean isSdkAcceptsProjectComponentHardwareIds(ISDK sdk, String projectDeviceId, String projectDeviceCoreId, String projectCoreId) {
        String[] sdkCoreOptions = sdk.getFilterOptions().getCores();
        return SDKFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkCoreOptions, projectDeviceId, projectDeviceCoreId, projectCoreId);
    }

    public static boolean isSdkAcceptsProjectComponentHardwareIds(String[] sdkCoreOptions, String projectDeviceId, String projectDeviceCoreId, String projectCoreId) {
        boolean result;
        if (sdkCoreOptions.length == 0) {
            return true;
        }
        if (projectDeviceId.isEmpty() && projectDeviceCoreId.isEmpty() && projectCoreId.isEmpty()) {
            return false;
        }
        List<String> sdkDeviceIdList = SDKUtils.getDevicesbyOption(sdkCoreOptions);
        List<String> sdkDeviceCoreIdList = SDKUtils.getDeviceCoresbyOption(sdkCoreOptions);
        List<String> sdkCoreIdList = SDKUtils.getCoresbyOption(sdkCoreOptions);
        boolean isAccepted = true;
        boolean hasIds = false;
        if (!projectDeviceCoreId.isEmpty() && !sdkDeviceCoreIdList.isEmpty()) {
            isAccepted = sdkDeviceCoreIdList.contains(projectDeviceCoreId);
            hasIds = true;
        }
        if (isAccepted && !projectDeviceId.isEmpty() && !sdkDeviceIdList.isEmpty()) {
            isAccepted = sdkDeviceIdList.contains(projectDeviceId);
            hasIds = true;
        }
        if (isAccepted && !projectCoreId.isEmpty() && !sdkCoreIdList.isEmpty()) {
            isAccepted = sdkCoreIdList.contains(projectCoreId);
            hasIds = true;
        }
        boolean bl = result = hasIds ? isAccepted : false;
        return result;
    }

    private static Map<String, String> loadCoreKindsMap() {
        HashMap<String, String> coreKinds = new HashMap<String, String>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint(EP_HARDWARE);
        if (ep == null) {
            return new HashMap<String, String>();
        }
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement celk = iConfigurationElementArray[n4];
                if (ELEMENT_HARDWARE.equals(celk.getName())) {
                    IConfigurationElement[] iConfigurationElementArray2 = celk.getChildren(ELEMENT_PROCESSORS);
                    int n5 = iConfigurationElementArray2.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement processorsElement = iConfigurationElementArray2[n6];
                        IConfigurationElement[] iConfigurationElementArray3 = processorsElement.getChildren(ELEMENT_PROCESSOR);
                        int n7 = iConfigurationElementArray3.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            IConfigurationElement processorElement = iConfigurationElementArray3[n8];
                            IConfigurationElement[] iConfigurationElementArray4 = processorElement.getChildren(ELEMENT_CORE_TYPES);
                            int n9 = iConfigurationElementArray4.length;
                            int n10 = 0;
                            while (n10 < n9) {
                                IConfigurationElement coreTypesElement = iConfigurationElementArray4[n10];
                                IConfigurationElement[] iConfigurationElementArray5 = coreTypesElement.getChildren(ELEMENT_CORE_TYPE);
                                int n11 = iConfigurationElementArray5.length;
                                int n12 = 0;
                                while (n12 < n11) {
                                    IConfigurationElement coreTypeElement = iConfigurationElementArray5[n12];
                                    coreKinds.put(coreTypeElement.getAttribute(ATTRIBUTE_ID), coreTypeElement.getAttribute(ATTRIBUTE_CORE_KIND_ID));
                                    ++n12;
                                }
                                ++n10;
                            }
                            ++n8;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        SDKFilteringUtils.addLegacySDKs(coreKinds);
        return coreKinds;
    }

    private static void addLegacySDKs(Map<String, String> coreKinds) {
        coreKinds.put("M0plus", "cortex-m0plus");
        coreKinds.put("S32V_M0plus", "cortex-m0plus");
        coreKinds.put("M4", "cortex-m4");
        coreKinds.put("A5", "cortex-a5");
    }
}

