/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.core.model.IModelSDK;
import com.freescale.s32ds.cross.sdk.IContributedSDK;
import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKMissedMarkerHandler;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesCheckerResult;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKFilesChecker;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.ProjectUpdater;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import com.freescale.s32ds.cross.sdk.internal.attach.SDKAttachChecker;
import com.freescale.s32ds.cross.sdk.internal.attach.SDKAttachStatusesHolder;
import com.freescale.s32ds.cross.sdk.internal.attach.SDKAttachStatusesResolver;
import com.freescale.s32ds.cross.sdk.processors.CopyProcessor;
import com.freescale.s32ds.cross.sdk.processors.ISourcePathProcessor;
import com.freescale.s32ds.cross.sdk.processors.LinkProcessor;
import com.freescale.s32ds.cross.sdk.ui.internal.SDKConflictedFilesDialog;
import com.freescale.s32ds.cross.sdk.ui.internal.property.SDKProjectPropertyPage;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import com.nxp.s32ds.cle.ide.sdk.core.attach.SdkAttachUtils;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import com.nxp.s32ds.cle.ide.sdk.core.resources.ProjectSourceFolder;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class SDKAttach {
    private static final String OLD_PREF = "_?_";
    private static final Map<String, AttachData[]> cache = new LinkedHashMap<String, AttachData[]>();
    private static Map<String, Boolean[]> changedSDKAttachments = new LinkedHashMap<String, Boolean[]>();

    public static List<ISDK> getAttached(IProject project) {
        return SDKAttach.getAttached(project, false);
    }

    public static List<ISDK> getAttachedVerbose(IProject project) {
        return SDKAttach.getAttached(project, true);
    }

    public static List<ISDK> getAttached(IProject project, boolean verbose) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        LinkedHashMap<String, String> notAvailableSDKs = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> missedSDKs = new LinkedHashMap<String, String>();
        SDKAvailabilityChecker availabilityChecker = new SDKAvailabilityChecker();
        List<AttachData> attachDatas = SDKAttach.getProjectAttachData(project);
        for (AttachData ad : attachDatas) {
            String sdkId = ad.sdkId;
            IStatus status = availabilityChecker.checkAvailability(sdkId);
            int statusCode = status.getCode();
            if (statusCode == ISDKAttachStatuses.ERROR_SDK_MISSED.getCode()) {
                ad.isMissed = true;
                missedSDKs.put(sdkId, NLS.bind((String)"SDK {0} is not found in workspace", (Object)sdkId));
                continue;
            }
            ISDK sdk = SDKUtils.getSDKbyID(sdkId);
            if (statusCode == ISDKAttachStatuses.ERROR_SDK_LOCATION.getCode()) {
                IPath sdkPath = SDKSupportPlugin.getEclipsePath(sdk);
                notAvailableSDKs.put(sdkId, NLS.bind((String)"SDK {0} is not found: invalid path: {1}", (Object)sdkId, (Object)(sdkPath != null ? sdkPath : "")));
            }
            if (ad.isMissed) {
                ad.isMissed = false;
            }
            result.add(sdk);
        }
        if (verbose) {
            SDKMissedMarkerHandler.delete(project);
            notAvailableSDKs.entrySet().forEach(e -> SDKAttach.handleNotAvailableSDKError((String)e.getKey(), project, (String)e.getValue()));
            missedSDKs.entrySet().forEach(e -> SDKAttach.handleNotAvailableSDKError((String)e.getKey(), project, (String)e.getValue()));
        }
        cache.put(project.getName(), attachDatas.toArray(new AttachData[0]));
        return result;
    }

    private static void handleNotAvailableSDKError(String sdkId, IProject project, String errorMessage) {
        SDKMissedMarkerHandler.create(sdkId, project, errorMessage);
        SDKSupportPlugin.error(errorMessage, null);
    }

    public static List<ISDK> getAttached(IProject project, ISDK.TYPE type) {
        return SDKAttach.getAttached(project).stream().filter(sdk -> type == sdk.getType()).collect(Collectors.toList());
    }

    public static List<IConfiguration> getAttached(IProject project, ISDK sdk) {
        ArrayList<IConfiguration> res = new ArrayList<IConfiguration>();
        if (project == null || sdk == null) {
            return res;
        }
        List<AttachData> attData = SDKAttach.getProjectAttachData(project);
        for (AttachData data : attData) {
            if (!data.sdkId.equals(sdk.getId())) continue;
            IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
            IConfiguration[] configurations = bi.getManagedProject().getConfigurations();
            if (data.cfgs.length == 0) {
                IConfiguration[] iConfigurationArray = configurations;
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfiguration configuration = iConfigurationArray[n2];
                    res.add(configuration);
                    ++n2;
                }
            } else {
                String[] stringArray = data.cfgs;
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String s = stringArray[n3];
                    int c = 0;
                    while (c < configurations.length) {
                        IConfiguration conf = configurations[c];
                        if (s != null && s.equals(conf.getName())) {
                            res.add(conf);
                        }
                        ++c;
                    }
                    ++n3;
                }
            }
            break;
        }
        return res;
    }

    public static String[] getAttached(String prj, String sdkId) {
        if (prj != null) {
            AttachData[] data = cache.get(prj);
            if (data == null) {
                for (IProject project : SDKUtils.listProjects()) {
                    if (prj.equals(project.getName())) {
                        SDKAttach.getAttached(project, false);
                    }
                    data = cache.get(prj);
                }
            }
            if (prj != null && sdkId != null) {
                AttachData[] attachDataArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    AttachData ad = attachDataArray[n2];
                    if (sdkId.equals(ad.sdkId)) {
                        return ad.cfgs;
                    }
                    ++n2;
                }
            } else if (prj != null && sdkId == null) {
                String[] res = new String[data.length];
                int i = 0;
                while (i < data.length) {
                    res[i] = data[i].sdkId;
                    ++i;
                }
                return res;
            }
        } else if (prj == null && sdkId != null) {
            ArrayList<String> res = new ArrayList<String>();
            block3: for (String key : cache.keySet()) {
                AttachData[] attachDataArray = cache.get(key);
                int n = attachDataArray.length;
                int n3 = 0;
                while (n3 < n) {
                    AttachData data = attachDataArray[n3];
                    if (sdkId.equals(data.sdkId)) {
                        res.add(key);
                        continue block3;
                    }
                    ++n3;
                }
            }
            return res.toArray(new String[0]);
        }
        return null;
    }

    public static boolean isAttached(String prj, String cfg, String sdkId) {
        if (prj == null || cfg == null || sdkId == null) {
            return false;
        }
        AttachData[] data = cache.get(prj);
        if (data != null) {
            AttachData[] attachDataArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                AttachData ad = attachDataArray[n2];
                if (sdkId.equals(ad.sdkId)) {
                    if (SDKUtils.getSDKbyID(sdkId) == null || ad.isMissed) {
                        return false;
                    }
                    if (ad.cfgs.length == 0) {
                        return true;
                    }
                    String[] stringArray = ad.cfgs;
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        if (s != null && s.equals(cfg)) {
                            return true;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isAttached(ISDK sdk, IProject project) {
        return !SDKAttach.hasAttached(project) ? false : !SDKAttach.getAttached(project, sdk).isEmpty();
    }

    public static boolean isAttached(ISDK sdk) {
        return cache.entrySet().stream().flatMap(entry -> Stream.of((AttachData[])entry.getValue())).anyMatch(ad -> ((AttachData)ad).getSDKId().equals(sdk.getId()));
    }

    public static List<IProject> getAttached(ISDK sdk) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        if (sdk == null) {
            return result;
        }
        String sdkId = sdk.getId();
        for (IProject project : SDKUtils.listProjects()) {
            for (ISDK sd : SDKAttach.getAttached(project, false)) {
                if (!sdkId.equals(sd.getId())) continue;
                result.add(project);
            }
        }
        return result;
    }

    public static void restoreSDK(ISDK sdk, IProject project) {
        List<IConfiguration> configurations = SDKAttach.getAttached(project, sdk);
        configurations.forEach(conf -> {
            SDKAttach.addOptions(sdk, conf);
            SDKAttach.addResources(sdk, conf);
            SDKUtils.addSources(project, sdk, conf);
        });
    }

    public static boolean attachToProjectConfigurations(ISDK sdk, Iterable<IConfiguration> configs, int context) {
        IStatus status;
        if (!SDKAttach.validateAttachParameters(sdk, configs)) {
            return false;
        }
        if (context == 0 && sdk instanceof IContributedSDK && !SDKAttach.handleAttachStatus(status = ((IContributedSDK)sdk).checkStateChangePreconditions(5, null), null)) {
            return false;
        }
        return SDKAttach.attachTo(sdk, configs);
    }

    public static boolean attachToProjectConfigurations(List<ISDK> sdks, Iterable<IConfiguration> configs, IProject project, int context) {
        Map<ISDK, IStatus> attachingSDKsStatuses = SDKAttach.preprocessSDKsList(sdks, project);
        Set configsNames = ((List)configs).stream().map(IBuildObject::getName).collect(Collectors.toSet());
        attachingSDKsStatuses.entrySet().stream().filter(e -> ((IStatus)e.getValue()).isOK()).forEach(e -> {
            IStatus iStatus = SDKAttach.attachToProjectConfigurations((ISDK)e.getKey(), project, configsNames, context);
        });
        SDKAttach.postprocessSDKsList(attachingSDKsStatuses);
        return true;
    }

    private static IStatus attachToProjectConfigurations(ISDK sdk, IProject project, Set<String> configsNames, int context) {
        IStatus status = ISDKAttachStatuses.OK_SDK_ATTACHED;
        List<IConfiguration> projectConfigurations = SDKUtils.getProjectConfigurations(project);
        if (projectConfigurations == null || projectConfigurations.isEmpty()) {
            status = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKAttach_no_configs_to_attach, null));
            SDKSupportPlugin.log(status);
            return status;
        }
        List<IConfiguration> configs = projectConfigurations.stream().filter(conf -> configsNames.contains(conf.getName())).collect(Collectors.toList());
        if (!SDKAttach.attachToProjectConfigurations(sdk, configs, context)) {
            status = new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKAttach_error_not_attached, (Object)sdk.getId(), (Object)project.getName()));
            SDKSupportPlugin.log(status);
            return status;
        }
        SDKSupportPlugin.log(status);
        return status;
    }

    private static Map<ISDK, IStatus> preprocessSDKsList(List<ISDK> sdks, IProject project) {
        List<ISDK> availableSDKs = SDKAttach.checkUnavailableSDKs(sdks, project);
        Map<ISDK, IStatus> attachableSDKs = SDKAttach.checkSDKListForSimilarNames(availableSDKs, project, true);
        return attachableSDKs;
    }

    private static void postprocessSDKsList(Map<ISDK, IStatus> attachingSDKsStatuses) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<ISDK, IStatus> e : attachingSDKsStatuses.entrySet()) {
            IStatus sdkAttachStatus = e.getValue();
            if (sdkAttachStatus.isOK()) continue;
            if (result.length() > 0) {
                result.append('\n');
            }
            String message = sdkAttachStatus.getMessage();
            SDKSupportPlugin.log(message);
            result.append(message);
        }
        if (result.length() > 0) {
            Shell shell = EclipseUtils.getShell();
            shell.getDisplay().syncExec(() -> MessageDialog.openWarning((Shell)shell, (String)"SDK Attach Warning", (String)NLS.bind((String)Messages.SDKAttach_warning_sdks_not_attached_message, (Object)result.toString())));
        }
    }

    private static List<ISDK> checkUnavailableSDKs(List<ISDK> sdks, IProject project) {
        List unavailableSDKs = sdks.stream().filter(sdk -> SDKAttachStatusesHolder.INSTANCE.getSDKAttachStates((ISDK)sdk, project).contains(ISDKAttachStatuses.ERROR_SDK_LOCATION)).collect(Collectors.toList());
        if (!unavailableSDKs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            unavailableSDKs.stream().forEach(sdk -> {
                StringBuilder stringBuilder2 = sb.append("- ").append(sdk.getBriefInfo()).append('\n');
            });
            Shell shell = EclipseUtils.getShell();
            shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)NLS.bind((String)Messages.SDKAttach_error_cannot_attach_unavailable_sdk_title, null), (String)NLS.bind((String)Messages.SDKAttach_error_cannot_attach_unavailable_sdk_message, (Object)sb.toString())));
        }
        return sdks.stream().filter(sdk -> !unavailableSDKs.contains(sdk)).collect(Collectors.toList());
    }

    private static Map<ISDK, IStatus> checkSDKListForSimilarNames(List<ISDK> sdks, IProject project, boolean showWarning) {
        LinkedHashMap<ISDK, IStatus> attachableSDKs = new LinkedHashMap<ISDK, IStatus>();
        HashMap<String, ISDK> sdksNames = new HashMap<String, ISDK>();
        for (ISDK sdk : sdks) {
            String sdkName = sdk.getName();
            String sdkNameUC = sdkName.toUpperCase();
            if (sdksNames.containsKey(sdkNameUC) && !((ISDK)sdksNames.get(sdkNameUC)).getName().equals(sdkName)) {
                ISDK conflictedSDK = (ISDK)sdksNames.get(sdkNameUC);
                String message = NLS.bind((String)Messages.SDKAttach_error_sdk_has_similar_name, (Object)(String.valueOf(sdk.getName()) + " v." + sdk.getVersion()), (Object)(String.valueOf(conflictedSDK.getName()) + " v." + conflictedSDK.getVersion()));
                SDKSupportPlugin.log(message);
                attachableSDKs.put(sdk, (IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", message));
                continue;
            }
            sdksNames.put(sdkNameUC, sdk);
            attachableSDKs.put(sdk, Status.OK_STATUS);
        }
        return attachableSDKs;
    }

    private static boolean validateAttachParameters(ISDK sdk, Iterable<IConfiguration> configs) {
        if (sdk == null || configs == null) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKAttach_illegal_attach_params, null)));
            return false;
        }
        if (!configs.iterator().hasNext()) {
            SDKSupportPlugin.log((IStatus)new Status(2, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.SDKAttach_no_configs_to_attach, null)));
            return false;
        }
        return true;
    }

    private static boolean attachTo(ISDK sdk, Iterable<IConfiguration> cfgs) {
        if (!SDKAttach.validateAttachParameters(sdk, cfgs)) {
            return false;
        }
        IProject project = cfgs.iterator().next().getOwner().getProject();
        if (!SDKAttach.handleAttachStatus(SDKAttachChecker.INSTANCE.checkPreAttach(sdk, project), null)) {
            return false;
        }
        OverrideData overrideData = new OverrideData();
        if (!SDKAttach.checkConflictedFiles(sdk, project, overrideData)) {
            return false;
        }
        if (sdk instanceof IContributedSDK) {
            ((IContributedSDK)sdk).stateChange(5, false, cfgs.iterator().next(), project.getName());
        }
        for (IConfiguration cfg : cfgs) {
            if (SDKAttach.isAttached(project.getName(), cfg.getName(), sdk.getId())) continue;
            if (sdk instanceof IContributedSDK) {
                ((IContributedSDK)sdk).stateChange(2, false, cfg, project.getName());
            }
            if (!SDKAttachStatusesResolver.INSTANCE.resolveAttachStatus(sdk, project, cfg).isOK()) continue;
            SDKAttach.attach(sdk, cfg);
            SDKAttach.addOptions(sdk, cfg);
            if (SDKAttach.addResources(sdk, cfg, overrideData)) {
                SDKUtils.addSources(project, sdk, cfg);
            }
            overrideData.setBackupFiles(false);
            if (!(sdk instanceof IContributedSDK)) continue;
            ((IContributedSDK)sdk).stateChange(2, true, cfg, project.getName());
        }
        if (sdk instanceof IContributedSDK) {
            ((IContributedSDK)sdk).stateChange(5, true, cfgs.iterator().next(), project.getName());
            IStatus status = ((IContributedSDK)sdk).checkStateChangePostconditions(5, null);
            SDKAttach.handleAttachStatus(status, null);
        }
        SDKAttach.reindexProject(project);
        SDKUtils.notifySDKObserver();
        SDKUtils.notifySDKAttached(sdk, project);
        SDKUtils.openResources(sdk, project);
        return true;
    }

    private static boolean handleAttachStatus(IStatus status, Object source) {
        try {
            Boolean handleResult = (Boolean)RcpStatusHandlers.handleStatus((String)"com.freescale.s32ds.cross.sdk.support.sdkAttachStatusHandler", (IStatus)status, null);
            if (!handleResult.booleanValue()) {
                return false;
            }
        }
        catch (CoreException ce) {
            SDKSupportPlugin.error(ce);
        }
        return true;
    }

    public static boolean detachFrom(ISDK sdk, Iterable<IConfiguration> configs) {
        if (sdk == null || configs == null) {
            throw new IllegalArgumentException(NLS.bind((String)"Illegal argument(s): SDK={0} CFGS={1}", (Object)sdk, configs));
        }
        IProject project = null;
        IConfiguration cfg0 = null;
        Iterator<IConfiguration> it = configs.iterator();
        if (it.hasNext()) {
            cfg0 = it.next();
            project = cfg0.getOwner().getProject();
            if (project == null) {
                return true;
            }
        } else {
            return true;
        }
        List<ISDK> sdksAttachedToProject = SDKAttach.getAttached(project, false);
        if (!sdksAttachedToProject.contains(sdk)) {
            return true;
        }
        List<IConfiguration> configsSdkAttachedTo = SDKAttach.getAttached(project, sdk);
        int cnt = 0;
        for (IConfiguration config : configs) {
            if (sdk instanceof IContributedSDK) {
                ((IContributedSDK)sdk).stateChange(3, false, config, project.getName());
            }
            SDKAttach.detach(sdk, config);
            SDKAttach.removeResources(sdk, config);
            SDKAttach.removeOptions(sdk, config);
            SDKUtils.removeSources(project, sdk, config);
            if (sdk instanceof IContributedSDK) {
                ((IContributedSDK)sdk).stateChange(3, true, config, project.getName());
            }
            configsSdkAttachedTo.remove(config);
            ++cnt;
        }
        if (cnt > 0 && configsSdkAttachedTo.isEmpty()) {
            SDKAttach.removeSDKFolderFromProject(sdk, project);
            sdksAttachedToProject.remove(sdk);
            SDKUtils.notifySDKDetached(sdk, project);
        }
        SDKUtils.notifySDKObserver();
        return cnt > 0;
    }

    public static void detachFrom(ISDK sdk, IProject project) {
        List<IConfiguration> configurations = SDKAttach.getAttached(project, sdk);
        SDKAttach.detachFrom(sdk, configurations);
        SDKUtils.notifySDKDetached(sdk, project);
    }

    public static void addOptions(ISDK sdk, IConfiguration config) {
        IProject project = config.getOwner().getProject();
        List<ISDK> refModulesSdks = sdk.getModules().getRefModulesSdks();
        if (refModulesSdks.isEmpty()) {
            ProjectUpdater.updateOptions(config, sdk, false);
        } else {
            for (ISDK refSdk : refModulesSdks) {
                if (!SDKAttachStatusesResolver.INSTANCE.resolveAttachStatus(refSdk, project, config).isOK()) continue;
                ProjectUpdater.updateOptions(config, refSdk, false);
            }
        }
    }

    public static void removeOptions(ISDK sdk, IConfiguration config) {
        List<ISDK> refModulesSdks = sdk.getModules().getRefModulesSdks();
        if (refModulesSdks.isEmpty()) {
            ProjectUpdater.updateOptions(config, sdk, true);
        } else {
            refModulesSdks.stream().forEach(refSdk -> {
                boolean bl = ProjectUpdater.updateOptions(config, refSdk, true);
            });
        }
    }

    public static boolean addResources(ISDK sdk, IConfiguration cfg) {
        return SDKAttach.addResources(sdk, cfg, null);
    }

    public static boolean addResources(ISDK sdk, IConfiguration cfg, OverrideData overrideData) {
        LinkedHashMap<SdkModule, Set<IExtendedPath>> resourcesToCopy = new LinkedHashMap<SdkModule, Set<IExtendedPath>>();
        LinkedHashMap<SdkModule, Set<IExtendedPath>> resourcesToMove = new LinkedHashMap<SdkModule, Set<IExtendedPath>>();
        LinkedHashMap<SdkModule, Set<IExtendedPath>> resourcesToLink = new LinkedHashMap<SdkModule, Set<IExtendedPath>>();
        boolean isBackupFiles = overrideData != null && overrideData.isBackupFiles();
        Map resourcesToOverride = overrideData != null ? overrideData.getFilesToOverride() : null;
        String toolChainId = cfg.getToolChain().getBaseId();
        IProject project = cfg.getOwner().getProject();
        AvailableSDKFilter sdkFilter = new AvailableSDKFilter(project);
        SDKAttach.prepareSourcePaths(sdk, sdkFilter, toolChainId, resourcesToCopy, resourcesToMove, resourcesToLink, (Map<String, Set<IExtendedPath>>)resourcesToOverride);
        return SDKAttach.processSourcePaths(sdk, resourcesToCopy, resourcesToMove, resourcesToLink, project, sdkFilter, isBackupFiles);
    }

    private static void prepareSourcePaths(ISDK sdk, ISDKFilter sdkFilter, String configToolChainId, Map<SdkModule, Set<IExtendedPath>> resourcesToCopy, Map<SdkModule, Set<IExtendedPath>> resourcesToMove, Map<SdkModule, Set<IExtendedPath>> resourcesToLink, Map<String, Set<IExtendedPath>> resourcesToOverride) {
        Set<SdkModule> sdkRefModules = sdk.getModules().getRefModules(sdkFilter);
        if (sdkRefModules.isEmpty()) {
            SDKAttach.prepareSourcePaths(sdk, configToolChainId, sdk.getModules().getRootModule(), resourcesToCopy, resourcesToMove, resourcesToLink, resourcesToOverride);
        } else {
            for (SdkModule sdkRefModule : sdkRefModules) {
                ISDK refModuleSdk = sdkRefModule.getSdk();
                if (refModuleSdk == null) continue;
                SDKAttach.prepareSourcePaths(refModuleSdk, configToolChainId, sdkRefModule, resourcesToCopy, resourcesToMove, resourcesToLink, resourcesToOverride);
            }
        }
    }

    private static void prepareSourcePaths(ISDK sdk, String configToolChainId, SdkModule sdkModule, Map<SdkModule, Set<IExtendedPath>> resourcesToCopy, Map<SdkModule, Set<IExtendedPath>> resourcesToMove, Map<SdkModule, Set<IExtendedPath>> resourcesToLink, Map<String, Set<IExtendedPath>> resourcesToOverride) {
        Map<Integer, List<IExtendedPath>> sdkRefModuleResources = SDKResourcesHandler.INSTANCE.getResources(sdk, configToolChainId);
        for (Map.Entry<Integer, List<IExtendedPath>> e : sdkRefModuleResources.entrySet()) {
            int resourceType = e.getKey();
            for (IExtendedPath resourcePath : e.getValue()) {
                SDKAttach.prepareResource(resourcePath, resourceType, sdkModule, resourcesToCopy, resourcesToMove, resourcesToLink, resourcesToOverride);
            }
        }
    }

    private static void prepareResource(IExtendedPath resourcePath, int resourceType, SdkModule sdkModule, Map<SdkModule, Set<IExtendedPath>> resourcesToCopy, Map<SdkModule, Set<IExtendedPath>> resourcesToMove, Map<SdkModule, Set<IExtendedPath>> resourcesToLink, Map<String, Set<IExtendedPath>> resourcesToOverride) {
        if (resourcesToOverride != null) {
            boolean isResourceOveridden = resourcesToOverride.values().stream().anyMatch(v -> v.contains(resourcePath));
            resourcePath.setOverride(isResourceOveridden);
        }
        if (resourcePath.isCopy()) {
            if (resourcePath.copyPath() == null) {
                resourcesToCopy.computeIfAbsent(sdkModule, s -> new LinkedHashSet()).add(resourcePath);
            } else {
                resourcesToMove.computeIfAbsent(sdkModule, s -> new LinkedHashSet()).add(resourcePath);
            }
        } else if (1 != resourceType && 2 != resourceType) {
            resourcesToLink.computeIfAbsent(sdkModule, s -> new LinkedHashSet()).add(resourcePath);
        }
    }

    private static boolean processSourcePaths(ISDK sdk, Map<SdkModule, Set<IExtendedPath>> resourcesToCopy, Map<SdkModule, Set<IExtendedPath>> resourcesToMove, Map<SdkModule, Set<IExtendedPath>> resourcesToLink, IProject project, ISDKFilter filter, boolean isBackupFiles) {
        boolean needCopy;
        CopyProcessor copyProcessor = new CopyProcessor(sdk, isBackupFiles);
        IFolder sdkFolder = project.getFolder(sdk.getTargetFolderName());
        SDKAttach.processSourcePaths(resourcesToMove, sdkFolder, copyProcessor);
        boolean bl = needCopy = !resourcesToCopy.isEmpty();
        if (needCopy || !resourcesToLink.isEmpty()) {
            try {
                SDKAttach.createSdkTargetFolders(sdk, sdkFolder, filter, needCopy);
                SDKAttach.createProjectFolders(sdk, project, filter);
                SDKAttach.processSourcePaths(resourcesToCopy, sdkFolder, copyProcessor);
                SDKAttach.processSourcePaths(resourcesToLink, sdkFolder, new LinkProcessor(sdk, isBackupFiles));
            }
            catch (CoreException ce) {
                SDKSupportPlugin.error(NLS.bind((String)"Unable to perform attach SDK {0}", (Object)sdk.getId()), ce);
                return false;
            }
            return true;
        }
        return false;
    }

    private static void createSdkTargetFolders(ISDK sdk, IFolder sdkFolder, ISDKFilter filter, boolean needCopy) throws CoreException {
        SDKAttach.createSdkTargetFolder(sdkFolder, needCopy);
        for (ISDK refModuleSdk : sdk.getModules().getRefModulesSdks(filter)) {
            SDKAttach.createSdkTargetFolder(sdkFolder.getFolder(refModuleSdk.getTargetFolderName()), needCopy);
        }
    }

    private static void createProjectFolders(ISDK sdk, IProject project, ISDKFilter filter) throws CoreException {
        Set projectSourceFolders = sdk.getProjectSourceFolders().values().stream().flatMap(Collection::stream).filter(ProjectSourceFolder::isForceCreate).collect(Collectors.toSet());
        for (ProjectSourceFolder folder : projectSourceFolders) {
            SDKAttach.createProjectFolder(project.getFolder(folder.getPath()));
        }
        for (ISDK refModuleSdk : sdk.getModules().getRefModulesSdks(filter)) {
            SDKAttach.createProjectFolders(refModuleSdk, project, filter);
        }
    }

    private static void createProjectFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IPath copyPath = Path.fromOSString((String)folder.getProjectRelativePath().toString());
            IFolder f = folder.getProject().getFolder(copyPath.segment(0));
            if (!f.exists()) {
                f.create(1, true, (IProgressMonitor)new NullProgressMonitor());
            }
            int i = 1;
            while (i < copyPath.segmentCount()) {
                if (!(f = f.getFolder(copyPath.segment(i))).exists()) {
                    f.create(1, true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++i;
            }
        }
    }

    private static void createSdkTargetFolder(IFolder folder, boolean isRealFolder) throws CoreException {
        if (folder.exists() && folder.isVirtual() && isRealFolder) {
            folder.delete(true, null);
        }
        if (!folder.exists()) {
            folder.create(isRealFolder ? 1 : 8192, true, null);
        }
    }

    private static void processSourcePaths(Map<SdkModule, Set<IExtendedPath>> sourcePaths, IFolder sdkRootFolder, ISourcePathProcessor processor) {
        for (Map.Entry<SdkModule, Set<IExtendedPath>> e : sourcePaths.entrySet()) {
            SdkModule sdkModule = e.getKey();
            IPath sdkBasePath = sdkModule.getBasePath();
            IFolder sdkModuleFolder = !sdkModule.isRoot() ? sdkRootFolder.getFolder(sdkModule.getSdk().getTargetFolderName()) : sdkRootFolder;
            for (IExtendedPath source : e.getValue()) {
                SDKAttach.processSourcePath(source, sdkBasePath, sdkModuleFolder, processor);
            }
        }
    }

    public static void removeResources(ISDK sdk, IConfiguration cfg) {
        SDKResourcesHandler.INSTANCE.removeResourcesFromProject(sdk, (IProject)cfg.getOwner(), cfg.getToolChain().getBaseId());
    }

    public static void processSourcePath(IExtendedPath path, IPath root, IFolder parent, ISourcePathProcessor processor) {
        String copyToProjectPath = path.copyPath();
        if (copyToProjectPath != null) {
            String name = path.lastSegment();
            String rename = path.renameTo();
            if (rename != null && !rename.isEmpty()) {
                name = new Path(rename).lastSegment();
            }
            IProject project = parent.getProject();
            if (copyToProjectPath.isEmpty() || copyToProjectPath.equals(".") || copyToProjectPath.equals("/")) {
                IFile link = project.getFile(name);
                processor.file(link, path);
            } else {
                IPath copyPath = Path.fromOSString((String)copyToProjectPath);
                IFolder f = project.getFolder(copyPath.segment(0));
                processor.folder(f);
                int i = 1;
                while (i < copyPath.segmentCount()) {
                    f = f.getFolder(copyPath.segment(i));
                    processor.folder(f);
                    ++i;
                }
                IFile link = f.getFile(name);
                processor.file(link, path);
            }
        } else {
            IPath srcRelPath = path.makeRelativeTo(root);
            if (srcRelPath != null && srcRelPath.segmentCount() > 0) {
                IFolder f = parent;
                int i = 0;
                while (i < srcRelPath.segmentCount() - 1) {
                    f = f.getFolder(srcRelPath.segment(i));
                    processor.folder(f);
                    ++i;
                }
                if (path.toFile().isDirectory()) {
                    processor.folder(f.getFolder(srcRelPath.lastSegment()));
                } else {
                    processor.file(f.getFile(srcRelPath.lastSegment()), path);
                }
            }
        }
    }

    public static void changeAttachments(IProject project, SDKProjectPropertyPage widget) {
        if (project != null && !changedSDKAttachments.isEmpty()) {
            List<ISDK> sdks = changedSDKAttachments.keySet().stream().filter(SDKUtils::exists).collect(Collectors.mapping(SDKUtils::getSDKbyID, Collectors.toList()));
            Map<ISDK, IStatus> preprocessedSDKsStatuses = SDKAttach.preprocessSDKsList(sdks, project);
            preprocessedSDKsStatuses.entrySet().stream().filter(e -> ((IStatus)e.getValue()).isOK()).forEach(e -> SDKAttach.changeAttachment((ISDK)e.getKey(), project, widget));
            changedSDKAttachments.clear();
            SDKAttachStatusesHolder.INSTANCE.commitSDKsAttachStates();
            SDKAttach.postprocessSDKsList(preprocessedSDKsStatuses);
        }
    }

    private static void changeAttachment(ISDK sdk, IProject project, SDKProjectPropertyPage widget) {
        Integer configIndex;
        String sdkId = sdk.getId();
        boolean[] newAttachFlags = SDKAttach.getSelectedAttachConfigurations(sdkId);
        if (newAttachFlags == null) {
            return;
        }
        boolean[] oldAttachFlags = SDKAttach.getSelectedAttachConfigurations(OLD_PREF + sdkId);
        ArrayList<IConfiguration> toAdd = new ArrayList<IConfiguration>();
        ArrayList<IConfiguration> toDel = new ArrayList<IConfiguration>();
        int selectedConfigsCount = newAttachFlags.length;
        if (oldAttachFlags == null) {
            oldAttachFlags = new boolean[selectedConfigsCount];
        }
        HashMap<IConfiguration, Integer> confsAtachInfo = new HashMap<IConfiguration, Integer>();
        IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int i = 0;
        while (i < selectedConfigsCount) {
            IConfiguration configuration = cfgs[i];
            confsAtachInfo.put(configuration, i);
            if (newAttachFlags[i] && !oldAttachFlags[i]) {
                toAdd.add(configuration);
            } else if (!newAttachFlags[i] && oldAttachFlags[i]) {
                toDel.add(configuration);
            }
            ++i;
        }
        if (!toAdd.isEmpty() && !SDKAttach.attachToProjectConfigurations(sdk, toAdd, 0)) {
            Boolean[] undoAttachFlags = new Boolean[newAttachFlags.length];
            for (Map.Entry e : confsAtachInfo.entrySet()) {
                configIndex = (Integer)e.getValue();
                undoAttachFlags[configIndex.intValue()] = newAttachFlags[configIndex];
                if (!toAdd.contains(e.getKey()) || !newAttachFlags[configIndex]) continue;
                undoAttachFlags[configIndex.intValue()] = Boolean.FALSE;
            }
            SDKAttach.updateSDKAttachStates(sdkId, undoAttachFlags);
            widget.updateWidgetState();
        }
        if (!toDel.isEmpty() && !SDKAttach.detachFrom(sdk, toDel)) {
            Boolean[] undoAttachFlags = new Boolean[newAttachFlags.length];
            for (Map.Entry e : confsAtachInfo.entrySet()) {
                configIndex = (Integer)e.getValue();
                undoAttachFlags[configIndex.intValue()] = newAttachFlags[configIndex];
                if (!toDel.contains(e.getKey()) || !oldAttachFlags[configIndex]) continue;
                undoAttachFlags[configIndex.intValue()] = Boolean.TRUE;
            }
            SDKAttach.updateSDKAttachStates(sdkId, undoAttachFlags);
            widget.updateWidgetState();
        }
    }

    private static void updateSDKAttachStates(String sdkId, Boolean[] states) {
        ArrayList<IStatus> convStatuses = new ArrayList<IStatus>(states.length);
        int i = 0;
        while (i < states.length) {
            convStatuses.add(states[i] != false ? ISDKAttachStatuses.OK_SDK_ATTACHED : ISDKAttachStatuses.OK_SDK_NOT_ATTACHED);
            ++i;
        }
        SDKAttachStatusesHolder.INSTANCE.addSDKAttachStates(sdkId, convStatuses);
    }

    public static void checkAttached(IProject project) {
        SDKAvailabilityChecker checker = new SDKAvailabilityChecker();
        List<ISDK> attached = SDKAttach.getProjectAttachData(project).stream().map(AttachData::access$4).filter(sdkId -> checker.checkAvailability((String)sdkId).isOK()).collect(Collectors.mapping(SDKUtils::getSDKbyID, Collectors.toList()));
        if (attached.isEmpty()) {
            return;
        }
        SDKAttach.checkMissedFiles(project, attached);
    }

    public static boolean hasAttached(IProject project) {
        return cache.containsKey(project.getName());
    }

    public static void checkAttachedSdksExist() {
        for (IProject project : SDKUtils.listProjects()) {
            SDKAttach.getAttachedVerbose(project);
        }
    }

    private static void attach(ISDK sdk, IConfiguration cfg) {
        if (sdk == null || cfg == null) {
            return;
        }
        IProject project = cfg.getOwner().getProject();
        String configName = cfg.getName();
        sdk.getModules().getModulesSdks().stream().filter(rsdk -> SDKAttachStatusesResolver.INSTANCE.resolveAttachStatus((ISDK)rsdk, project, cfg).isOK()).map(IModelSDK::getId).forEach(sdkId -> SDKAttach.attachSdkToProjectConfiguration(sdkId, configName, project));
    }

    private static void attachSdkToProjectConfiguration(String sdkId, String configName, IProject project) {
        AttachData attachData = null;
        int index = -1;
        List<AttachData> projectAttachData = SDKAttach.getProjectAttachData(project);
        int i = 0;
        while (i < projectAttachData.size()) {
            attachData = projectAttachData.get(i);
            if (attachData.sdkId.equals(sdkId)) {
                index = i;
                ArrayList<String> configs = new ArrayList<String>(Arrays.asList(attachData.cfgs));
                if (attachData.isMissed) {
                    configs.clear();
                    attachData.isMissed = false;
                }
                if (configs.contains(configName)) {
                    SDKSupportPlugin.log(String.format(Messages.SDKAttach_Attached, sdkId, configName, project.getName()));
                    return;
                }
                configs.add(configName);
                attachData.cfgs = configs.toArray(new String[0]);
                break;
            }
            ++i;
        }
        if (index == -1) {
            attachData = null;
        }
        if (attachData == null) {
            attachData = new AttachData();
            attachData.sdkId = sdkId;
            attachData.cfgs = new String[]{configName};
            projectAttachData.add(attachData);
        } else {
            projectAttachData.set(index, attachData);
        }
        SDKAttach.put(project, projectAttachData.toArray(new AttachData[0]));
    }

    private static void detach(ISDK sdk, IConfiguration cfg) {
        if (sdk == null || cfg == null) {
            return;
        }
        IProject project = cfg.getOwner().getProject();
        String configName = cfg.getName();
        sdk.getModules().getModulesSdks().forEach(msdk -> SDKAttach.detachSdkFromProjectConfiguration(msdk.getId(), configName, project));
    }

    private static void detachSdkFromProjectConfiguration(String sdkId, String configName, IProject project) {
        AttachData attachData = null;
        int index = -1;
        List<AttachData> projectAttachData = SDKAttach.getProjectAttachData(project);
        int i = 0;
        while (i < projectAttachData.size()) {
            attachData = projectAttachData.get(i);
            if (attachData.sdkId.equals(sdkId)) {
                index = i;
                ArrayList<String> configs = new ArrayList<String>(Arrays.asList(attachData.cfgs));
                if (!configs.removeIf(configName::equals)) {
                    SDKSupportPlugin.log(String.format(Messages.SDKAttach_Not_attached_to_cfg, sdkId, configName, project.getName()));
                    return;
                }
                attachData.cfgs = configs.toArray(new String[0]);
                break;
            }
            ++i;
        }
        if (index == -1) {
            SDKSupportPlugin.log(String.format(Messages.SDKAttach_Not_attached_to_prj, sdkId, project.getName()));
            return;
        }
        if (attachData != null) {
            if (attachData.cfgs.length == 0) {
                projectAttachData.remove(index);
            } else {
                projectAttachData.set(index, attachData);
            }
            SDKAttach.put(project, projectAttachData.toArray(new AttachData[0]));
        }
    }

    private static List<AttachData> getProjectAttachData(IProject project) {
        AttachData[] projectAttachData = cache.get(project.getName());
        return new ArrayList<AttachData>(Arrays.asList(projectAttachData != null ? projectAttachData : SDKAttach.load(project)));
    }

    private static AttachData[] load(IProject project) {
        String sdksConfigData;
        IConfiguration[] configurations = null;
        IManagedBuildInfo bi = ManagedBuildManager.getBuildInfo((IResource)project);
        if (bi != null) {
            configurations = bi.getManagedProject().getConfigurations();
        }
        if ((sdksConfigData = new ProjectSettings(project, SDKSupportPlugin.getUniqueIdentifier()).load(AttachData.SDKS_PROJECT_PROPERTY_KEY)) == null || sdksConfigData.trim().length() == 0) {
            cache.remove(project.getName());
            return new AttachData[0];
        }
        String[] attachedSdks = sdksConfigData.split(":");
        int attachedSdksCount = attachedSdks.length;
        AttachData[] attachData = new AttachData[attachedSdksCount];
        int i = 0;
        while (i < attachedSdksCount) {
            String[] attachedSdkParams = attachedSdks[i].split(Pattern.quote("|"));
            attachData[i] = new AttachData();
            attachData[i].sdkId = attachedSdkParams[0].trim();
            int attachedConfigsCount = attachedSdkParams.length - 1;
            if (attachedConfigsCount > 0) {
                attachData[i].cfgs = new String[attachedConfigsCount];
                System.arraycopy(attachedSdkParams, 1, attachData[i].cfgs, 0, attachedConfigsCount);
            } else if (configurations != null) {
                int projectConfigsCount = configurations.length;
                attachData[i].cfgs = new String[projectConfigsCount];
                int j = 0;
                while (j < projectConfigsCount) {
                    ((AttachData)attachData[i]).cfgs[j] = configurations[j].getName();
                    ++j;
                }
            } else {
                attachData[i].cfgs = new String[0];
            }
            ++i;
        }
        cache.put(project.getName(), attachData);
        return attachData;
    }

    private static void put(IProject p, AttachData[] data) {
        StringBuilder sb = new StringBuilder();
        AttachData[] attachDataArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            AttachData dt = attachDataArray[n2];
            if (sb.length() > 0) {
                sb.append(":");
            }
            sb.append(dt.toRecord());
            ++n2;
        }
        new ProjectSettings(p, SDKSupportPlugin.getUniqueIdentifier()).store(AttachData.SDKS_PROJECT_PROPERTY_KEY, sb.toString());
        cache.put(p.getName(), data);
    }

    private static boolean checkConflictedFiles(ISDK sdk, IProject project, OverrideData overrideData) {
        boolean isChecked = true;
        ISDKFilesChecker filesChecker = SDKFilesChecker.getFilesChecker(sdk, project, ISDKFilesChecker.Mode.CONFLICTED);
        ISDKFilesCheckerResult checkResult = filesChecker.checkFiles();
        Map<String, Set<IExtendedPath>> conflictedFiles = checkResult.getResultFiles();
        if (!conflictedFiles.isEmpty()) {
            SDKConflictedFilesDialog sdkConflictedFilesDialog = new SDKConflictedFilesDialog(EclipseUtils.getShell(), sdk, project, conflictedFiles);
            if (sdkConflictedFilesDialog.open() != 0) {
                isChecked = false;
            } else {
                overrideData.setFilesToOverride(sdkConflictedFilesDialog.getFilesToOverride());
                overrideData.setBackupFiles(sdkConflictedFilesDialog.isBackupFiles());
            }
        }
        return isChecked;
    }

    private static void checkMissedFiles(IProject project, List<ISDK> attachedSdks) {
        Map<String, Set<IExtendedPath>> checkResults = SdkAttachUtils.checkMissedSdkTargetFiles(project, attachedSdks);
        if (!checkResults.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            checkResults.keySet().stream().map(SDKUtils::getSDKbyID).filter(Objects::nonNull).forEach(sdk -> {
                StringBuilder stringBuilder2 = sb.append("- ").append(sdk.getBriefInfo()).append('\n');
            });
            SDKAttach.confirmAndRestoreSDKFiles(checkResults, project, sb.toString());
        }
    }

    private static void confirmAndRestoreSDKFiles(Map<String, Set<IExtendedPath>> checkResults, IProject project, String sdkList) {
        Shell shell = EclipseUtils.getShell();
        shell.getDisplay().syncExec(() -> {
            if (MessageDialog.openConfirm((Shell)shell, (String)Messages.SDKMissedFilesDialog_title, (String)String.format(Messages.SDKMissedFilesDialog_text, project.getName(), sdkList))) {
                SDKAttach.restoreSDKs(checkResults, project);
            }
        });
    }

    private static void removeSDKFolderFromProject(ISDK sdk, IProject project) {
        SDKUtils.removeSources(project, sdk);
        IFolder projectSDKFolder = project.getFolder(sdk.getTargetFolderName());
        if (projectSDKFolder.isVirtual()) {
            try {
                projectSDKFolder.delete(true, null);
            }
            catch (CoreException e) {
                SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", e.getMessage()));
            }
        }
    }

    private static void reindexProject(IProject project) {
        ICProject cProject = CoreModel.getDefault().getCModel().getCProject(project.getName());
        CCorePlugin.getIndexManager().reindex(cProject);
    }

    private static void restoreSDKs(Map<String, Set<IExtendedPath>> sdks, IProject project) {
        ArrayList<ISDK> sdksToRestore = new ArrayList<ISDK>();
        for (Map.Entry<String, Set<IExtendedPath>> entry : sdks.entrySet()) {
            ISDK sdk2 = SDKUtils.getSDKbyID(entry.getKey());
            Set<IExtendedPath> missedPaths = entry.getValue();
            if (sdk2 == null || missedPaths == null || missedPaths.isEmpty() || !SdkAttachUtils.restoreProjectSdkFolders(sdk2, new ArrayList<IExtendedPath>(missedPaths), project).isOK()) continue;
            sdksToRestore.add(sdk2);
        }
        sdks.keySet().stream().filter(Objects::nonNull).map(SDKUtils::getSDKbyID).filter(Objects::nonNull).forEach(sdk -> SDKAttach.restoreSDK(sdk, project));
        SDKUtils.refreshProjectResources(project);
    }

    public static List<ISDK> getUnavailableSDKs(IProject project) {
        return SDKAttachStatusesHolder.INSTANCE.getSDKsByStatus(project, ISDKAttachStatuses.ERROR_SDK_LOCATION);
    }

    public static void collectChangedSDKsAttachStates(Map<String, List<IStatus>> src) {
        for (String sdkId : src.keySet()) {
            List<IStatus> srcStates = src.get(sdkId);
            List<IStatus> actStates = SDKAttachStatusesHolder.INSTANCE.getSDKAttachStates(sdkId);
            if (srcStates == null || actStates == null || srcStates.size() != actStates.size()) {
                return;
            }
            boolean isAttachmentStatesChanged = false;
            int i = 0;
            while (i < srcStates.size()) {
                IStatus srcStatus = srcStates.get(i);
                if (!srcStatus.equals(actStates.get(i))) {
                    actStates.set(i, srcStatus);
                    isAttachmentStatesChanged = true;
                }
                ++i;
            }
            if (!isAttachmentStatesChanged) continue;
            Boolean[] convStates = new Boolean[actStates.size()];
            int idx = 0;
            for (IStatus actStatus : actStates) {
                convStates[idx++] = actStatus.equals(ISDKAttachStatuses.OK_SDK_ATTACHED);
            }
            changedSDKAttachments.put(sdkId, convStates);
        }
    }

    public static boolean[] getSelectedAttachConfigurations(String sdkId) {
        Boolean[] res = null;
        List<IStatus> states = null;
        states = sdkId.startsWith(OLD_PREF) ? SDKAttachStatusesHolder.INSTANCE.getBackupSDKsAttachStates().get(sdkId.substring(OLD_PREF.length())) : SDKAttachStatusesHolder.INSTANCE.getActualSDKsAttachStates().get(sdkId);
        if (states == null) {
            return null;
        }
        if (states != null) {
            int configsCount = states.size();
            res = new Boolean[configsCount];
            int idx = 0;
            for (IStatus status : states) {
                res[idx++] = status.equals(ISDKAttachStatuses.OK_SDK_ATTACHED);
            }
        }
        boolean[] out = new boolean[res.length];
        int i = 0;
        while (i < out.length) {
            out[i] = res[i] == null ? false : res[i];
            ++i;
        }
        return out;
    }

    public static void cleanProjectAttachData(IProject project) {
        cache.remove(project.getName());
    }

    public static void reAttachSDK(ISDK sdk, IProject project) {
        if (!SDKAttach.isAttached(sdk, project)) {
            return;
        }
        List attachedConfigsNames = SDKAttach.getAttached(project, sdk).stream().map(IBuildObject::getName).collect(Collectors.toList());
        SDKAttach.detachFrom(sdk, project);
        List<IConfiguration> configurations = SDKUtils.getProjectConfigurations(project);
        if (configurations != null && !configurations.isEmpty()) {
            List<IConfiguration> configsToAttach = configurations.stream().filter(c -> attachedConfigsNames.contains(c.getName())).collect(Collectors.toList());
            SDKAttach.attachTo(sdk, configsToAttach);
        }
    }

    private static class AttachData {
        private static final String SDKS_PROJECT_PROPERTY_KEY = String.valueOf(SDKSupportPlugin.getUniqueIdentifier()) + ".attachedSDKs";
        private static final String SDK_IDS_SEPARATOR = ":";
        private static final String SDK_GROUP_SEPARATOR = "|";
        private String sdkId;
        private String[] cfgs;
        private boolean isMissed = false;

        private AttachData() {
        }

        public String toString() {
            return "[AttachData: " + this.sdkId + SDK_GROUP_SEPARATOR + Arrays.toString(this.cfgs) + (this.isMissed ? " (missed)" : "") + " ]";
        }

        private String getSDKId() {
            return this.sdkId;
        }

        private String toRecord() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.sdkId);
            String[] stringArray = this.cfgs;
            int n = this.cfgs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(SDK_GROUP_SEPARATOR);
                }
                sb.append(s);
                ++n2;
            }
            return sb.toString();
        }
    }

    private static class OverrideData {
        private boolean isBackupFiles;
        private Map<String, Set<IExtendedPath>> filesToOverride;

        private OverrideData() {
        }

        private void setFilesToOverride(Map<String, Set<IExtendedPath>> filesToOverride) {
            this.filesToOverride = filesToOverride;
        }

        private void setBackupFiles(boolean isBackupFiles) {
            this.isBackupFiles = isBackupFiles;
        }

        private Map<String, Set<IExtendedPath>> getFilesToOverride() {
            return this.filesToOverride;
        }

        private boolean isBackupFiles() {
            return this.isBackupFiles;
        }
    }
}

