/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHandler;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class ProjectUpdater {
    public static final boolean ADD = false;
    public static final boolean REMOVE = true;
    private static final String ERROR_NO_UPDATER = "Error: no Project Updater found for project %s, SDK %s.";
    private static final String ERROR_MANY_UPDATERS = "Warning: More than one Project Updater found for project %s, SDK %s : %s";
    private static final String MSG_OK = "The Project Updater %s processed the project %s, SDK %s.";
    private static final String QUOTE = "\"";
    private static final String UPDATER_ELEMENT = "updater";
    private static final String EXTENSION_POINT_ID = "com.freescale.s32ds.cross.sdk.support.updater";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TOOLCHAINS_ATTRIBUTE = "toolchains";
    private static final String LIBRARY_PREFIX_ATTRIBUTE = "libraryPrefix";
    private static final String LIBRARY_SUFFIX_ATTRIBUTE = "librarySuffix";
    private static final String COM_INCLUDE_ATTRIBUTE = "comInclude";
    private static final String CPP_INCLUDE_ATTRIBUTE = "cppInclude";
    private static final String COM_DEFINE_ATTRIBUTE = "comDefine";
    private static final String CPP_DEFINE_ATTRIBUTE = "cppDefine";
    private static final String ASM_INCLUDE_ATTRIBUTE = "asmInclude";
    private static final String ASM_DEFINE_ATTRIBUTE = "asmDefine";
    private static final String LINK_LIBS_ATTRIBUTE = "linkLib";
    private static final String LINK_PATH_ATTRIBUTE = "linkPath";
    private static final String LINK_SCRIPT_ATTRIBUTE = "linkLD";
    private static final String COM_INCLUDE_FILES_ATTRIBUTE = "comIncludeFiles";
    private static final String CPP_INCLUDE_FILES_ATTRIBUTE = "cppIncludeFiles";
    private static final String COM_UNDEFINE_ATTRIBUTE = "comUndefine";
    private static final String CPP_UNDEFINE_ATTRIBUTE = "cppUndefine";
    private static final String ASM_UNDEFINE_ATTRIBUTE = "asmUndefine";
    private static List<ProjectUpdater> updaters = null;
    private final String name;
    private final String libraryPrefix;
    private final String librarySuffix;
    private final String[] tcs;
    private Map<String, String> options = new HashMap<String, String>();

    private static synchronized List<ProjectUpdater> getUpdaters() {
        if (updaters == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
            updaters = extensionPoint == null ? Collections.emptyList() : new ArrayList(Arrays.stream(extensionPoint.getExtensions()).flatMap(extension -> Arrays.stream(extension.getConfigurationElements())).filter(configElement -> UPDATER_ELEMENT.equals(configElement.getName())).map(ProjectUpdater::new).filter(ProjectUpdater::valid).collect(Collectors.toMap(p -> p.name, Function.identity())).values());
        }
        return updaters;
    }

    private ProjectUpdater(IConfigurationElement ce) {
        this.name = ce.getAttribute(NAME_ATTRIBUTE);
        this.options.put(COM_INCLUDE_ATTRIBUTE, ce.getAttribute(COM_INCLUDE_ATTRIBUTE));
        this.options.put(CPP_INCLUDE_ATTRIBUTE, ce.getAttribute(CPP_INCLUDE_ATTRIBUTE));
        this.options.put(ASM_INCLUDE_ATTRIBUTE, ce.getAttribute(ASM_INCLUDE_ATTRIBUTE));
        this.options.put(COM_DEFINE_ATTRIBUTE, ce.getAttribute(COM_DEFINE_ATTRIBUTE));
        this.options.put(CPP_DEFINE_ATTRIBUTE, ce.getAttribute(CPP_DEFINE_ATTRIBUTE));
        this.options.put(ASM_DEFINE_ATTRIBUTE, ce.getAttribute(ASM_DEFINE_ATTRIBUTE));
        this.options.put(LINK_LIBS_ATTRIBUTE, ce.getAttribute(LINK_LIBS_ATTRIBUTE));
        this.options.put(LINK_PATH_ATTRIBUTE, ce.getAttribute(LINK_PATH_ATTRIBUTE));
        this.options.put(LINK_SCRIPT_ATTRIBUTE, ce.getAttribute(LINK_SCRIPT_ATTRIBUTE));
        this.options.put(COM_INCLUDE_FILES_ATTRIBUTE, ce.getAttribute(COM_INCLUDE_FILES_ATTRIBUTE));
        this.options.put(CPP_INCLUDE_FILES_ATTRIBUTE, ce.getAttribute(CPP_INCLUDE_FILES_ATTRIBUTE));
        this.options.put(COM_UNDEFINE_ATTRIBUTE, ce.getAttribute(COM_UNDEFINE_ATTRIBUTE));
        this.options.put(CPP_UNDEFINE_ATTRIBUTE, ce.getAttribute(CPP_UNDEFINE_ATTRIBUTE));
        this.options.put(ASM_UNDEFINE_ATTRIBUTE, ce.getAttribute(ASM_UNDEFINE_ATTRIBUTE));
        String tmp = ce.getAttribute(TOOLCHAINS_ATTRIBUTE);
        this.tcs = tmp == null || tmp.isEmpty() ? null : tmp.split(",");
        this.libraryPrefix = ProjectUpdater.getStringAttribute(ce, LIBRARY_PREFIX_ATTRIBUTE);
        this.librarySuffix = ProjectUpdater.getStringAttribute(ce, LIBRARY_SUFFIX_ATTRIBUTE);
    }

    private boolean valid() {
        return this.tcs != null && this.tcs.length > 0 && this.tcs[0] != null && !this.tcs[0].isEmpty();
    }

    private boolean accept(IToolChain tc) {
        IToolChain tmp = tc;
        while (tmp != null) {
            String[] stringArray = this.tcs;
            int n = this.tcs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase(tmp.getId()) || s.equalsIgnoreCase(tmp.getBaseId())) {
                    return true;
                }
                tmp = tmp.getSuperClass();
                ++n2;
            }
        }
        return false;
    }

    private static String getStringAttribute(IConfigurationElement ce, String name) {
        String value = ce.getAttribute(name);
        return value != null ? value.trim() : "";
    }

    private boolean update(IConfiguration cfg, ISDK sdk, boolean remove) {
        if (sdk == null || cfg == null) {
            return false;
        }
        String toolChainId = cfg.getToolChain().getBaseId();
        IProject project = cfg.getOwner().getProject();
        AvailableSDKFilter filter = new AvailableSDKFilter(project);
        this.updateIncludePaths(cfg, sdk, filter, toolChainId, remove);
        this.updateIncludeFiles(cfg, sdk, filter, toolChainId, remove);
        ProjectUpdater.updateOption(cfg, this.options.get(LINK_LIBS_ATTRIBUTE), new OptionUpdater(this.makeLibs(sdk, filter, toolChainId), remove));
        String[] libraries = SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 2);
        ProjectUpdater.updateOption(cfg, this.options.get(LINK_PATH_ATTRIBUTE), new OptionUpdater(libraries, remove));
        String[] linkerScripts = SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 4);
        ProjectUpdater.updateOption(cfg, this.options.get(LINK_SCRIPT_ATTRIBUTE), new OptionUpdater(linkerScripts, remove));
        this.updateSymbols(cfg, sdk, toolChainId, remove);
        return true;
    }

    private void updateIncludeFiles(IConfiguration cfg, ISDK sdk, ISDKFilter filter, String toolChainId, boolean remove) {
        List<String> commonIncludeFiles = Arrays.asList(SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 5));
        ProjectUpdater.updateOption(cfg, this.options.get(COM_INCLUDE_FILES_ATTRIBUTE), new OptionUpdater(this.collectIncludeFiles(sdk, filter, toolChainId, commonIncludeFiles, "c"), remove));
        ProjectUpdater.updateOption(cfg, this.options.get(CPP_INCLUDE_FILES_ATTRIBUTE), new OptionUpdater(this.collectIncludeFiles(sdk, filter, toolChainId, commonIncludeFiles, "cpp"), remove));
    }

    private String[] collectIncludeFiles(ISDK sdk, ISDKFilter filter, String toolChainId, List<String> commonIncludeFiles, String langId) {
        ArrayList<String> includePaths = new ArrayList<String>();
        includePaths.addAll(commonIncludeFiles);
        includePaths.addAll(Arrays.asList(SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 5, langId)));
        return includePaths.toArray(new String[0]);
    }

    private void updateIncludePaths(IConfiguration cfg, ISDK sdk, ISDKFilter filter, String toolChainId, boolean remove) {
        List<String> commonIncludePaths = Arrays.asList(SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 1));
        ProjectUpdater.updateOption(cfg, this.options.get(COM_INCLUDE_ATTRIBUTE), new OptionUpdater(this.collectIncludePaths(sdk, filter, toolChainId, commonIncludePaths, "c"), remove));
        ProjectUpdater.updateOption(cfg, this.options.get(CPP_INCLUDE_ATTRIBUTE), new OptionUpdater(this.collectIncludePaths(sdk, filter, toolChainId, commonIncludePaths, "cpp"), remove));
        ProjectUpdater.updateOption(cfg, this.options.get(ASM_INCLUDE_ATTRIBUTE), new OptionUpdater(SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 1, "asm"), remove));
    }

    private String[] collectIncludePaths(ISDK sdk, ISDKFilter filter, String toolChainId, List<String> commonIncludePaths, String langId) {
        ArrayList<String> includePaths = new ArrayList<String>();
        includePaths.addAll(commonIncludePaths);
        includePaths.addAll(Arrays.asList(SDKResourcesHandler.INSTANCE.getResourcePaths(sdk, filter, toolChainId, 1, langId)));
        return includePaths.toArray(new String[0]);
    }

    private void updateSymbols(IConfiguration cfg, ISDK sdk, String toolChainId, boolean remove) {
        Collection<SdkSymbolsHolder> holders = sdk.getSymbols(toolChainId).values();
        if (holders.isEmpty()) {
            return;
        }
        List<String> comonDefSymbols = SdkSymbolsHandler.getSymbolsNames(holders, SdkSymbolTypes.DEFINED, "");
        String[] comDefs = this.collectSymbols(holders, SdkSymbolTypes.DEFINED, "c", comonDefSymbols);
        String[] cppDefs = this.collectSymbols(holders, SdkSymbolTypes.DEFINED, "cpp", comonDefSymbols);
        String[] asmDefs = this.collectSymbols(holders, SdkSymbolTypes.DEFINED, "asm", comonDefSymbols);
        ProjectUpdater.updateOption(cfg, this.options.get(COM_DEFINE_ATTRIBUTE), new OptionUpdater(comDefs, remove));
        ProjectUpdater.updateOption(cfg, this.options.get(CPP_DEFINE_ATTRIBUTE), new OptionUpdater(cppDefs, remove));
        ProjectUpdater.updateOption(cfg, this.options.get(ASM_DEFINE_ATTRIBUTE), new OptionUpdater(asmDefs, remove));
        List<String> commonUndefSymbols = SdkSymbolsHandler.getSymbolsNames(holders, SdkSymbolTypes.UNDEFINED, "");
        String[] comUndefs = this.collectSymbols(holders, SdkSymbolTypes.UNDEFINED, "c", commonUndefSymbols);
        String[] cppUndefs = this.collectSymbols(holders, SdkSymbolTypes.UNDEFINED, "cpp", commonUndefSymbols);
        String[] asmUndefs = this.collectSymbols(holders, SdkSymbolTypes.UNDEFINED, "asm", commonUndefSymbols);
        ProjectUpdater.updateOption(cfg, this.options.get(COM_UNDEFINE_ATTRIBUTE), new OptionUpdater(comUndefs, remove));
        ProjectUpdater.updateOption(cfg, this.options.get(CPP_UNDEFINE_ATTRIBUTE), new OptionUpdater(cppUndefs, remove));
        ProjectUpdater.updateOption(cfg, this.options.get(ASM_UNDEFINE_ATTRIBUTE), new OptionUpdater(asmUndefs, remove));
    }

    private String[] collectSymbols(Collection<SdkSymbolsHolder> holders, SdkSymbolTypes type, String langId, List<String> commonSymbols) {
        List<String> symbols = SdkSymbolsHandler.getSymbolsNames(holders, type, langId);
        symbols.addAll(commonSymbols);
        return symbols.toArray(new String[0]);
    }

    private String[] makeLibs(ISDK sdk, ISDKFilter filter, String toolChainId) {
        return this.prepareLibrariesPaths(SDKResourcesHandler.INSTANCE.getBinaryFiles(sdk, filter, toolChainId));
    }

    private String[] prepareLibrariesPaths(Map<String, Boolean> libPaths) {
        ArrayList<String> resultLibPaths = new ArrayList<String>();
        for (Map.Entry<String, Boolean> e : libPaths.entrySet()) {
            String libPath = e.getKey();
            boolean hasPrefix = e.getValue();
            String resultLibPath = new Path(libPath).lastSegment();
            if (resultLibPath.startsWith(QUOTE)) {
                resultLibPath = resultLibPath.substring(1);
            }
            if (resultLibPath.endsWith(QUOTE)) {
                resultLibPath = resultLibPath.substring(0, resultLibPath.length() - 1);
            }
            if (hasPrefix) {
                resultLibPath = String.valueOf(this.libraryPrefix) + resultLibPath + this.librarySuffix;
            }
            resultLibPaths.add(resultLibPath);
        }
        return resultLibPaths.toArray(new String[0]);
    }

    private static void updateOption(IConfiguration cfg, String id, IOptionUpdater updater) {
        if (updater == null || id == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        boolean autoBuilding = workspaceDesc.isAutoBuilding();
        try {
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            if (ProjectUpdater.setOptionValue(cfg, id, updater)) {
                ManagedBuildManager.saveBuildInfo((IProject)((IProject)cfg.getOwner()), (boolean)true);
            }
            workspaceDesc.setAutoBuilding(autoBuilding);
            workspace.setDescription(workspaceDesc);
        }
        catch (BuildException | CoreException e) {
            SDKSupportPlugin.error(e);
        }
    }

    private static boolean setOptionValue(IConfiguration cfg, String id, IOptionUpdater updater) throws BuildException {
        ITool[] tools;
        IProject p = (IProject)cfg.getOwner();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)p);
        IManagedProject managedProject = buildInfo.getManagedProject();
        if (managedProject == null) {
            return false;
        }
        boolean modified = false;
        IToolChain toolChain = cfg.getToolChain();
        modified |= ProjectUpdater.setOptionForConfig(id, cfg, toolChain.getOptions(), (IHoldsOptions)toolChain, updater);
        ITool[] iToolArray = tools = cfg.getTools();
        int n = tools.length;
        int n2 = 0;
        while (n2 < n) {
            ITool tool = iToolArray[n2];
            modified |= ProjectUpdater.setOptionForConfig(id, cfg, tool.getOptions(), (IHoldsOptions)tool, updater);
            ++n2;
        }
        return modified;
    }

    private static boolean setOptionForConfig(String id, IConfiguration config, IOption[] options, IHoldsOptions optionHolder, IOptionUpdater updater) throws BuildException {
        boolean modified = false;
        String lowerId = id.toLowerCase();
        IOption[] iOptionArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption option = iOptionArray[n2];
            String lowerCaseOptionId = option.getBaseId().toLowerCase();
            if (lowerCaseOptionId.matches(lowerId)) {
                String[] list = null;
                switch (option.getValueType()) {
                    case 4: {
                        list = option.getIncludePaths();
                        break;
                    }
                    case 8: {
                        list = option.getBasicStringListValue();
                        break;
                    }
                    case 5: {
                        list = option.getDefinedSymbols();
                        break;
                    }
                    case -5: {
                        list = option.getBasicStringListValue();
                        break;
                    }
                    case 9: {
                        list = option.getLibraryPaths();
                        break;
                    }
                    case 6: {
                        list = option.getLibraries();
                        break;
                    }
                    case 3: {
                        list = option.getStringListValue();
                        break;
                    }
                }
                if (list != null) {
                    String[] newValue = updater.update(list);
                    ManagedBuildManager.setOption((IConfiguration)config, (IHoldsOptions)optionHolder, (IOption)option, (String[])newValue);
                    modified = true;
                }
            }
            ++n2;
        }
        return modified;
    }

    public static boolean updateOptions(IConfiguration cfg, ISDK sdk, boolean remove) {
        IToolChain tc = cfg.getToolChain();
        ArrayList<String> used = new ArrayList<String>();
        String name = String.valueOf(cfg.getName()) + " @ " + cfg.getOwner().getName() + (remove ? " (DETACH)" : " (ATTACH)");
        for (ProjectUpdater pu : ProjectUpdater.getUpdaters()) {
            if (!pu.accept(tc)) continue;
            pu.update(cfg, sdk, remove);
            used.add(pu.name);
        }
        if (used.size() == 0) {
            SDKSupportPlugin.log(String.format(ERROR_NO_UPDATER, name, sdk.getName()));
            return false;
        }
        if (used.size() > 1) {
            SDKSupportPlugin.log(String.format(ERROR_MANY_UPDATERS, name, sdk.getName(), used));
        } else {
            SDKSupportPlugin.log(String.format(MSG_OK, used.get(0), name, sdk.getName()));
        }
        return true;
    }

    static interface IOptionUpdater {
        public String[] update(String[] var1);
    }

    private class OptionUpdater
    implements IOptionUpdater {
        private final String[] values;
        private final boolean remove;

        private OptionUpdater(String[] values, boolean remove) {
            this.values = values;
            this.remove = remove;
        }

        @Override
        public String[] update(String[] old) {
            LinkedHashSet<String> l = new LinkedHashSet<String>(Arrays.asList(old));
            if (this.remove) {
                Stream.of(this.values).forEach(l::remove);
            } else {
                Stream.of(this.values).forEach(l::add);
            }
            return l.toArray(new String[l.size()]);
        }
    }
}

