/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.ConflictedSDKsHandler;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDKFilter;
import com.freescale.s32ds.cross.sdk.internal.S32DSTester;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;

public class ProjectLocalSDK
extends ExternalSDK
implements IProjectLocalSDK {
    private static final String PROJECT_LOCAL_SDKS_PREF_KEY = String.valueOf(SDKSupportPlugin.getUniqueIdentifier()) + ".projectLocalSDKs";
    private final IProject project;

    public ProjectLocalSDK(IProject project, SDKHeader head, TCHolder root, IFilterOptions filterOptions) {
        super(head, root, filterOptions);
        this.project = project;
        this.type = ISDK.TYPE.PROJECT;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public ISDK.STATUS getStatus() {
        return ISDK.STATUS.PROJECT;
    }

    public static void loadProjectLocalPersistedSDKs() {
        for (IProject project : SDKUtils.listProjects()) {
            ProjectLocalSDK.loadProjectLocalPersistedSDK(project);
        }
    }

    public static void loadProjectLocalPersistedSDK(IProject project) {
        String sdksString = new ProjectSettings(project, SDKSupportPlugin.getUniqueIdentifier()).load(PROJECT_LOCAL_SDKS_PREF_KEY);
        ProjectLocalSDK.parseSDKsString(sdksString, project, 5);
    }

    public static void loadProjectLocalPersistedSDK(IProject project, boolean isForceReload) {
        String sdksString = new ProjectSettings(project, SDKSupportPlugin.getUniqueIdentifier()).load(PROJECT_LOCAL_SDKS_PREF_KEY);
        ProjectLocalSDK.parseSDKsString(sdksString, project, 5, isForceReload);
    }

    public static void storeProjectLocalSDK(IProject project) {
        new ProjectSettings(project, SDKSupportPlugin.getUniqueIdentifier()).store(PROJECT_LOCAL_SDKS_PREF_KEY, ProjectLocalSDK.getSDKsString(ProjectLocalSDK.getProjectLocalSDKs(project)));
    }

    public static void storeProjectLocalSDKs() {
        for (IProject project : SDKUtils.listProjects()) {
            if (!S32DSTester.checkCNature(project)) continue;
            new ProjectSettings(project, SDKSupportPlugin.getUniqueIdentifier()).store(PROJECT_LOCAL_SDKS_PREF_KEY, ProjectLocalSDK.getSDKsString(ProjectLocalSDK.getProjectLocalSDKs(project)));
        }
    }

    public static void removeProjectLocalSDKs(IProject project) {
        ProjectLocalSDK.getProjectLocalSDKs(project).stream().forEach(sdk -> SDKUtils.remove(sdk, project, false));
    }

    public static List<ISDK> getProjectLocalSDKs(IProject project) {
        List<ISDK> result = SDKUtils.filter(new ProjectLocalSDKFilter(project));
        Set<ISDK> conflictedSdks = ConflictedSDKsHandler.INSTANCE.getConflictedSdks(project);
        if (conflictedSdks != null) {
            result.addAll(conflictedSdks);
        }
        return result;
    }

    @Override
    public String getStatusText() {
        return "Project (" + (this.project == null ? "NULL" : this.project.getName()) + ')';
    }
}

