/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.core.model.ISDKFilterInfo;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.settings.model.extension.CTargetPlatformData;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.cdt.utils.Platform;
import org.osgi.framework.Version;

public class FilterOptions
implements IFilterOptions {
    private static final String USED = "USED";
    public static final FilterOptions EMPTY_FILTER = new FilterOptions(IFilterOptions.ELang.UNKNOWN, new IToolChain[0], new String[0]);
    private static final String CORE_PATTERN = "%s:%s";
    private final IFilterOptions.ELang lang;
    private final IToolChain[] toolChains;
    private final String[] cores;
    private String platformTarget;
    private String platformHost;
    private String filterOptionsInfo;
    private boolean isCheckAvailability = false;

    public FilterOptions(IFilterOptions.ELang lang, IToolChain[] toolChains, String[] cores) {
        this.lang = lang;
        IToolChain[] tmpTCs = new IToolChain[toolChains.length];
        int i = 0;
        while (i < tmpTCs.length) {
            if (toolChains[i] != null) {
                IToolChain sup = toolChains[i].getSuperClass();
                tmpTCs[i] = sup != null && FilterOptions.isDigitTail(toolChains[i].getId()) ? sup : toolChains[i];
            }
            ++i;
        }
        this.toolChains = Arrays.stream(toolChains).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new IToolChain[0]);
        this.cores = cores;
        this.isCheckAvailability = true;
    }

    public FilterOptions(IFilterOptions.ELang lang, IToolChain[] toolChains, String[] cores, String platformTarget, String platformHost) {
        this(lang, toolChains, cores);
        this.platformTarget = platformTarget;
        this.platformHost = platformHost;
    }

    @Override
    public IFilterOptions.ELang getLang() {
        return this.lang;
    }

    @Override
    public IToolChain[] getToolChains() {
        return this.toolChains;
    }

    @Override
    public String[] getCores() {
        return this.cores;
    }

    @Override
    public String getToolChainID() {
        if (this.toolChains == null || this.toolChains.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", Arrays.stream(this.toolChains).map(tc -> tc.getId().trim()).collect(Collectors.toList()));
    }

    @Override
    public String getPlatform() {
        return this.platformTarget != null ? this.platformTarget.toLowerCase() : "";
    }

    @Override
    public String getHost() {
        return this.platformHost != null ? this.platformHost.toLowerCase() : "";
    }

    public static IFilterOptions createFilterOptions(SDKHeader sdkHeader) {
        return FilterOptions.createFilterOptions(sdkHeader.getLangs(), sdkHeader.getObsoleteToolchainIds(), sdkHeader.getCores(), sdkHeader.getPlatformTarget(), sdkHeader.getPlatformHost());
    }

    public static IFilterOptions createFilterOptions(String langs, String toolchainsStr, String coresStr, String platformTarget, String platformHost) {
        IFilterOptions.ELang lang = (IFilterOptions.ELang)((Object)str2langMap.get(langs));
        if (lang == null) {
            lang = IFilterOptions.ELang.UNKNOWN;
        }
        if (toolchainsStr == null) {
            toolchainsStr = "";
        }
        IToolChain[] realToolchains = ManagedBuildManager.getRealToolChains();
        String[] toolchainIds = toolchainsStr.isEmpty() ? new String[]{} : toolchainsStr.split(",");
        ArrayList<IToolChain> toolChains = new ArrayList<IToolChain>();
        Object[] objectArray = realToolchains;
        int n = realToolchains.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain tc = objectArray[n2];
            int i = 0;
            while (i < toolchainIds.length) {
                String id = toolchainIds[i];
                if (FilterOptions.isDigitTail(id)) {
                    id = id.substring(0, id.lastIndexOf(46));
                }
                if (tc.getBaseId().equals(id)) {
                    toolChains.add(tc);
                    toolchainIds[i] = USED;
                    break;
                }
                ++i;
            }
            ++n2;
        }
        objectArray = toolchainIds;
        n = toolchainIds.length;
        n2 = 0;
        while (n2 < n) {
            IToolChain id = objectArray[n2];
            if (!USED.equals(id)) {
                toolChains.add(new DummyToolChain((String)id));
            }
            ++n2;
        }
        if (coresStr == null) {
            coresStr = "";
        }
        String[] cores = coresStr.isEmpty() ? new String[]{} : coresStr.split(",");
        return new FilterOptions(lang, toolChains.toArray(new IToolChain[0]), cores, platformTarget, platformHost);
    }

    public static IFilterOptions createFilter(ISDKFilterInfo info) {
        if (info == null) {
            return EMPTY_FILTER;
        }
        IToolChain[] toolChains = info.getToolchain();
        ProcessorData processor = info.getProcessor();
        CoreNatureData core = info.getCurrenCoreNature();
        String coreNatureId = core.getCoreNatureId();
        DeviceCoreDescriptor deviceCore = DeviceDescriptors.getDeviceCoreDescriptor((String)coreNatureId);
        String processorId = !processor.getDevice().isEmpty() ? processor.getDevice() : processor.getId();
        String[] cores = deviceCore != null ? new String[]{String.format(CORE_PATTERN, deviceCore.getDeviceId(), deviceCore.getId())} : new String[]{String.format(CORE_PATTERN, processorId, coreNatureId)};
        IFilterOptions.ELang lng = IFilterOptions.str2langMap.get(info.getLanguage());
        String platformTarget = processor.getPlatform();
        String platformHost = Platform.getOS();
        return new FilterOptions(lng == null ? IFilterOptions.ELang.UNKNOWN : lng, toolChains, cores, platformTarget, platformHost);
    }

    public static boolean isDigitTail(String s) {
        String tail = s.substring(s.lastIndexOf(46) + 1);
        int i = 0;
        while (i < tail.length()) {
            if (!Character.isDigit(tail.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.filterOptionsInfo;
    }

    @Override
    public boolean isCheckAvailability() {
        return this.isCheckAvailability;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.cores);
        result = 31 * result + (this.filterOptionsInfo == null ? 0 : this.filterOptionsInfo.hashCode());
        result = 31 * result + (this.isCheckAvailability ? 1231 : 1237);
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.platformTarget == null ? 0 : this.platformTarget.hashCode());
        result = 31 * result + (this.platformHost == null ? 0 : this.platformHost.hashCode());
        result = 31 * result + Arrays.stream(this.toolChains).map(IBuildObject::getId).collect(Collectors.toList()).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        List otherTcIds;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterOptions other = (FilterOptions)obj;
        if (!Arrays.equals(this.cores, other.cores)) {
            return false;
        }
        if (this.isCheckAvailability != other.isCheckAvailability) {
            return false;
        }
        if (this.lang != other.lang) {
            return false;
        }
        if (!this.getPlatform().equals(other.getPlatform())) {
            return false;
        }
        if (!this.getHost().equals(other.getHost())) {
            return false;
        }
        IToolChain[] otherToolChains = other.getToolChains();
        if (this.toolChains.length != otherToolChains.length) {
            return false;
        }
        List thisTcIds = Arrays.stream(this.toolChains).map(IBuildObject::getId).collect(Collectors.toList());
        return thisTcIds.containsAll(otherTcIds = Arrays.stream(otherToolChains).map(IBuildObject::getId).collect(Collectors.toList()));
    }

    private static class DummyToolChain
    implements IToolChain {
        private final String ID;

        private DummyToolChain(String s) {
            this.ID = s;
        }

        public String getId() {
            return this.ID;
        }

        public String getName() {
            return this.ID;
        }

        public String getBaseId() {
            return this.ID;
        }

        public Version getVersion() {
            return new Version(this.ID);
        }

        public void setVersion(Version version) {
        }

        public String getManagedBuildRevision() {
            return this.ID;
        }

        public IOption createOption(IOption superClass, String Id2, String name, boolean isExtensionElement) {
            return null;
        }

        public void removeOption(IOption option) {
        }

        public IOption getOption(String id) {
            return null;
        }

        public IOption getOptionById(String id) {
            return null;
        }

        public IOption getOptionBySuperClassId(String id) {
            return null;
        }

        public IOption[] getOptions() {
            return null;
        }

        public IOptionCategory[] getChildCategories() {
            return null;
        }

        public void addOptionCategory(IOptionCategory category) {
        }

        public IOptionCategory getOptionCategory(String id) {
            return null;
        }

        public void createOptions(IHoldsOptions superClass) {
        }

        public IOption getOptionToSet(IOption option, boolean adjustExtension) throws BuildException {
            return null;
        }

        public boolean needsRebuild() {
            return false;
        }

        public void setRebuildState(boolean rebuild) {
        }

        public IConfiguration getParent() {
            return null;
        }

        public ITargetPlatform createTargetPlatform(ITargetPlatform superClass, String Id2, String name, boolean isExtensionElement) {
            return null;
        }

        public ITargetPlatform getTargetPlatform() {
            return null;
        }

        public void removeLocalTargetPlatform() {
        }

        public String getVersionsSupported() {
            return "";
        }

        public String getConvertToId() {
            return this.ID;
        }

        public void setVersionsSupported(String versionsSupported) {
        }

        public void setConvertToId(String convertToId) {
        }

        public IBuilder createBuilder(IBuilder superClass, String Id2, String name, boolean isExtensionElement) {
            return null;
        }

        public void removeLocalBuilder() {
        }

        public IBuilder getBuilder() {
            return null;
        }

        public ITool createTool(ITool superClass, String Id2, String name, boolean isExtensionElement) {
            return null;
        }

        public ITool[] getTools() {
            return null;
        }

        public ITool getTool(String id) {
            return null;
        }

        public ITool[] getToolsBySuperClassId(String id) {
            return null;
        }

        public IToolChain getSuperClass() {
            return null;
        }

        public boolean isAbstract() {
            return false;
        }

        public void setIsAbstract(boolean b) {
        }

        public String getUnusedChildren() {
            return null;
        }

        public String[] getOSList() {
            return null;
        }

        public void setOSList(String[] OSs) {
        }

        public String[] getArchList() {
            return null;
        }

        public void setArchList(String[] archs) {
        }

        public String getErrorParserIds() {
            return null;
        }

        public String getErrorParserIds(IConfiguration config) {
            return null;
        }

        public String[] getErrorParserList() {
            return null;
        }

        public void setErrorParserIds(String ids) {
        }

        public String getDefaultLanguageSettingsProviderIds() {
            return null;
        }

        public String getScannerConfigDiscoveryProfileId() {
            return null;
        }

        public void setScannerConfigDiscoveryProfileId(String profileId) {
        }

        public String getTargetToolIds() {
            return null;
        }

        public void setTargetToolIds(String targetToolIds) {
        }

        public String[] getTargetToolList() {
            return null;
        }

        public IOutputType[] getSecondaryOutputs() {
            return null;
        }

        public void setSecondaryOutputs(String ids) {
        }

        public boolean isDirty() {
            return false;
        }

        public void setDirty(boolean isDirty) {
        }

        public boolean isExtensionElement() {
            return false;
        }

        public boolean isSupported() {
            return false;
        }

        public IConfigurationEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
            return null;
        }

        public IConfigurationBuildMacroSupplier getBuildMacroSupplier() {
            return null;
        }

        public IOptionPathConverter getOptionPathConverter() {
            return null;
        }

        public IFolderInfo getParentFolderInfo() {
            return null;
        }

        public CTargetPlatformData getTargetPlatformData() {
            return null;
        }

        public boolean supportsBuild(boolean managed) {
            return false;
        }

        public boolean isSystemObject() {
            return false;
        }

        public boolean matches(IToolChain tc) {
            return false;
        }

        public String getUniqueRealName() {
            return this.ID;
        }

        public String toString() {
            return this.ID;
        }
    }
}

