/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.core.variables.VariablesPlugin;

public class Environment
implements IEnvironment {
    public static final IStringVariableManager SVM = VariablesPlugin.getDefault().getStringVariableManager();
    public static final String NONE = "-NONE-";
    public static final IValueVariableListener vvListener = new IValueVariableListener(){

        public void variablesRemoved(IValueVariable[] variables) {
            for (ISDK sdk : SDKUtils.filter(SDKUtils.NO_FILTER)) {
                IValueVariable[] iValueVariableArray = variables;
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    IValueVariable vv = iValueVariableArray[n2];
                    if (vv.getName().equals(sdk.getEnv())) {
                        try {
                            SVM.addVariables(new IValueVariable[]{vv});
                            SDKSupportPlugin.log(String.format(Messages.Environment_restored, vv.getName()));
                        }
                        catch (CoreException e) {
                            SDKSupportPlugin.error(e);
                        }
                    }
                    ++n2;
                }
            }
        }

        public void variablesChanged(IValueVariable[] variables) {
        }

        public void variablesAdded(IValueVariable[] variables) {
        }
    };
    private final String name;
    private final boolean isSystem;

    public Environment(String name, boolean isSystem) {
        this.name = name;
        this.isSystem = isSystem;
    }

    public Environment(IEnvironment environment) {
        this.name = environment != null ? environment.getName() : "";
        this.isSystem = environment != null ? environment.isSystem() : false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSystem() {
        return this.isSystem;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        IEnvironment other = (IEnvironment)obj;
        return this.name.equals(other.getName()) && this.isSystem == other.isSystem();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getValue() {
        if (this.isSystem()) {
            return System.getenv(this.getName());
        }
        IValueVariable vv = SVM.getValueVariable(this.getName());
        return vv != null ? vv.getValue() : NONE;
    }

    @Override
    public void setValue(String variableValue, String desc, boolean readOnly) {
        IValueVariable vv = SVM.getValueVariable(this.name);
        if (vv != null) {
            if (vv.isReadOnly() != readOnly) {
                this.removeValue();
                this.addValue(variableValue, desc, readOnly);
            } else {
                vv.setValue(variableValue);
            }
        } else {
            this.addValue(variableValue, desc, readOnly);
        }
        try {
            this.setupPathVariable(variableValue);
        }
        catch (CoreException e) {
            SDKSupportPlugin.error(e);
        }
    }

    private void setupPathVariable(String value) throws CoreException {
        IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        if (pathVariableManager.getURIValue(this.name) != null) {
            return;
        }
        IStringVariableManager vmng = VariablesPlugin.getDefault().getStringVariableManager();
        String substitutedValue = vmng.performStringSubstitution(value);
        URI resolvedURI = pathVariableManager.resolveURI(URIUtil.toURI((String)substitutedValue));
        if (resolvedURI.toString().isEmpty() || NONE.endsWith(resolvedURI.toString())) {
            SDKSupportPlugin.log(String.valueOf(Messages.Environment_unresolved) + this.name);
        } else {
            try {
                pathVariableManager.setURIValue(Environment.makePathVariableName(this.name), resolvedURI);
            }
            catch (Exception e) {
                SDKSupportPlugin.error(e);
            }
        }
    }

    @Override
    public void removeValue() {
        if (this.isSystem()) {
            SDKSupportPlugin.log(String.valueOf(Messages.Environment_cannot_remove) + this.name);
            return;
        }
        SVM.removeValueVariableListener(vvListener);
        IValueVariable vv = SVM.getValueVariable(this.name);
        if (vv != null) {
            SVM.removeVariables(new IValueVariable[]{vv});
        }
        SVM.addValueVariableListener(vvListener);
    }

    @Override
    public boolean exists() {
        return (this.isSystem ? System.getenv(this.getName()) : SVM.getValueVariable(this.getName())) != null;
    }

    private void addValue(String value, String description, boolean readOnly) {
        IValueVariable vv = SVM.newValueVariable(this.name, description, readOnly, value);
        try {
            SVM.addVariables(new IValueVariable[]{vv});
        }
        catch (CoreException e) {
            SDKSupportPlugin.error(e);
        }
    }

    public static String makePathVariableName(String envName) {
        return envName.replace(' ', '_').replace('.', '_');
    }

    public String toString() {
        return String.format("[Env %s = %s (%s %s)]", this.name, this.getValue(), this.isSystem ? "SYS" : "LOC", this.exists() ? "EXISTS" : "ABSENT");
    }

    public static void cleanVars(List<ISDK> sdks) {
        TreeSet<String> usedVars = new TreeSet<String>();
        for (ISDK sdk : sdks) {
            IEnvironment e = sdk.getEnv();
            if (e == null) {
                SDKSupportPlugin.log(String.format("Corrupted SDK: %s - no ENV var !", sdk.getId()));
                continue;
            }
            if (e.isSystem()) continue;
            if (usedVars.contains(e.getName())) {
                SDKSupportPlugin.log(String.valueOf(Messages.Environment_duplicate) + e);
                continue;
            }
            usedVars.add(e.getName());
        }
        ArrayList<IValueVariable> toDelete = new ArrayList<IValueVariable>();
        IValueVariable[] iValueVariableArray = SVM.getValueVariables();
        int n = iValueVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IValueVariable sv = iValueVariableArray[n2];
            if (!sv.isContributed() && (name = sv.getName()).endsWith("_PATH") && !usedVars.contains(name)) {
                SDKSupportPlugin.log(String.valueOf(Messages.Environment_removing) + sv.getName() + '=' + sv.getValue());
                toDelete.add(sv);
            }
            ++n2;
        }
        SVM.removeVariables(toDelete.toArray(new IValueVariable[toDelete.size()]));
    }
}

