/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.ProjectUpdater;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class ConflictedSDKsHandler {
    public static final ConflictedSDKsHandler INSTANCE = new ConflictedSDKsHandler();
    private static final String CONFLICT_SDK_MARKER_TYPE = "com.freescale.s32ds.cross.sdk.support.SDKConflictMarker";
    private static final String CONFLICT_SDK_MARKER_SDK_ID_ATTRIBUTE = "sdkId";
    private Map<IProject, Set<ISDK>> conflictedSDKs = new HashMap<IProject, Set<ISDK>>();

    public void addConflictedSdks(IProject project, List<ISDK> sdks) {
        Set<ISDK> sdksSet = this.conflictedSDKs.get(project);
        if (sdksSet == null) {
            sdksSet = new HashSet<ISDK>();
        }
        sdksSet.addAll(sdks);
        this.conflictedSDKs.put(project, sdksSet);
    }

    public Set<ISDK> getConflictedSdks(IProject project) {
        return this.conflictedSDKs.get(project);
    }

    public void handleConflictedSDKs(IProject project) {
        Set<ISDK> sdks = this.conflictedSDKs.get(project);
        this.handleProjectConflictedSDKs(project, sdks);
    }

    public void handleConflictedSDKs() {
        for (Map.Entry<IProject, Set<ISDK>> e : this.conflictedSDKs.entrySet()) {
            this.handleProjectConflictedSDKs(e.getKey(), e.getValue());
        }
    }

    public void cleanupConflictedSdks(IProject project) {
        this.conflictedSDKs.remove(project);
    }

    private void handleProjectConflictedSDKs(IProject project, Set<ISDK> sdks) {
        if (sdks == null || sdks.isEmpty()) {
            return;
        }
        for (ISDK sdk : sdks) {
            String sdkId = sdk.getId();
            if (project != null && project.isAccessible()) {
                String projectName = project.getName();
                String message = NLS.bind((String)Messages.ConflictedSDKsHandler_project_sdk_id_conflict, (Object[])new Object[]{projectName, sdkId});
                SDKSupportPlugin.log(message);
                this.createConflictedSdkMarker((IResource)project, message, sdkId);
                this.handleConflictedSDK(sdkId, project);
                continue;
            }
            SDKSupportPlugin.log(NLS.bind((String)Messages.ConflictedSDKsHandler_sdk_id_conflict, (Object)sdkId));
        }
    }

    private void handleConflictedSDK(String sdkId, IProject project) {
        if (project != null && project.isAccessible()) {
            IManagedProject mProject;
            IConfiguration[] configurations = null;
            IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null && (mProject = buildInfo.getManagedProject()) != null) {
                configurations = mProject.getConfigurations();
            }
            if (configurations != null) {
                ISDK sdk = SDKUtils.getSDKbyID(sdkId);
                IConfiguration[] iConfigurationArray = configurations;
                int n = configurations.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfiguration conf = iConfigurationArray[n2];
                    ProjectUpdater.updateOptions(conf, sdk, true);
                    ++n2;
                }
            }
        }
    }

    private void createConflictedSdkMarker(IResource resource, String message, String sdkId) {
        try {
            IMarker marker = SDKUtils.createErrorMarker(CONFLICT_SDK_MARKER_TYPE, resource, message);
            marker.setAttribute(CONFLICT_SDK_MARKER_SDK_ID_ATTRIBUTE, (Object)sdkId);
        }
        catch (CoreException ce) {
            SDKSupportPlugin.error(NLS.bind((String)Messages.ConflictedSDKsHandler_error_creating_conflict_marker, null), ce);
        }
    }
}

