/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.sdk.IProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.AbstractSmartFilter;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.utils.Platform;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class AvailableSDKFilter
extends AbstractSmartFilter {
    private final IProject project;

    public AvailableSDKFilter(IProject project) {
        this.project = project;
    }

    @Override
    public boolean accept(ISDK sdk) {
        if (sdk instanceof IProjectLocalSDK) {
            IProjectLocalSDK pll = (IProjectLocalSDK)sdk;
            return this.project != null && this.project.equals((Object)pll.getProject());
        }
        return true;
    }

    @Override
    public IFilterOptions options() {
        return AvailableSDKFilter.options(this.project);
    }

    public static IFilterOptions options(IProject proj) {
        IConfiguration[] projectConfigs = ManagedBuildManager.getBuildInfo((IResource)proj).getManagedProject().getConfigurations();
        ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
        IConfiguration[] iConfigurationArray = projectConfigs;
        int n = projectConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            IToolChain tc = config.getToolChain();
            if (FilterOptions.isDigitTail(tc.getId())) {
                tc = tc.getSuperClass();
            }
            tcs.add(tc);
            ++n2;
        }
        IToolChain[] toolChains = tcs.toArray(new IToolChain[0]);
        IFilterOptions options = AvailableSDKFilter.createFilterOptions(toolChains, proj);
        if (options == null) {
            options = AvailableSDKFilter.createCompatiableFilterOptions(toolChains, proj);
        }
        return options;
    }

    private static IFilterOptions createCompatiableFilterOptions(IToolChain[] toolChains, IProject project) {
        ProjectSettings ps = new ProjectSettings(project, "com.freescale.s32ds.cross.wizard");
        String processorId = ps.load("processor");
        String lang = ps.load("language");
        String coreTypeId = ps.load("coreType");
        String coreKindId = null;
        if (processorId.isEmpty() || coreTypeId.isEmpty()) {
            return null;
        }
        if (coreTypeId.toLowerCase().startsWith(processorId.toLowerCase())) {
            coreKindId = coreTypeId.substring(processorId.length() + 1);
        }
        if (coreKindId == null) {
            coreKindId = SDKUtils.unifyCoreKind(coreTypeId);
        }
        processorId = SDKUtils.unifyProcessor(processorId);
        IFilterOptions.ELang langs = lang.equalsIgnoreCase("c") ? IFilterOptions.ELang.C : (lang.equalsIgnoreCase("c++") ? IFilterOptions.ELang.CPP : IFilterOptions.ELang.UNKNOWN);
        String[] cores = new String[]{String.format("%s:%s", processorId, coreKindId)};
        return new FilterOptions(langs, toolChains, cores);
    }

    private static IFilterOptions createFilterOptions(IToolChain[] toolChains, IProject project) {
        ProjectContextSaver projectContext = new ProjectContextSaver(project);
        String deviceCoreId = projectContext.load("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String deviceId = projectContext.load("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        String coreId = projectContext.load("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        if (!(deviceId.isEmpty() && deviceCoreId.isEmpty() && coreId.isEmpty())) {
            String projectHardwareOptions = String.format("%s:%s:%s", deviceId, deviceCoreId, coreId);
            String langId = projectContext.load("com.nxp.s32ds.cle.runtime.lang.registry.lang.id");
            if (langId == null || langId.isEmpty()) {
                langId = new ProjectSettings(project, "com.freescale.s32ds.cross.wizard").load("language");
            }
            IFilterOptions.ELang langs = IFilterOptions.ELang.UNKNOWN;
            if ("c".equalsIgnoreCase(langId)) {
                langs = IFilterOptions.ELang.C;
            } else if ("c++".equalsIgnoreCase(langId)) {
                langs = IFilterOptions.ELang.CPP;
            }
            String platformTarget = projectContext.load("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id");
            String platformHost = Platform.getOS();
            return new FilterOptions(langs, toolChains, new String[]{projectHardwareOptions}, platformTarget, platformHost);
        }
        return null;
    }

    public static AvailableSDKFilter getNoOptionsFilter(IProject project) {
        return new AvailableSDKFilter(project){

            @Override
            public IFilterOptions options() {
                return null;
            }
        };
    }
}

