/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKSmartFilter;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.SDKFilteringUtils;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public abstract class AbstractSmartFilter
implements ISDKSmartFilter {
    public abstract IFilterOptions options();

    @Override
    public boolean acceptOptions(ISDK sdk) {
        IFilterOptions sdkFilterOptions;
        IFilterOptions filterOptions = this.options();
        if (this.skipOptionsCheck(filterOptions, sdkFilterOptions = sdk.getFilterOptions())) {
            return true;
        }
        if (!this.checkAvailability(filterOptions, sdk)) {
            return false;
        }
        if (!this.acceptPlatform(filterOptions, sdkFilterOptions)) {
            return false;
        }
        if (!this.acceptLanguages(filterOptions, sdkFilterOptions)) {
            return false;
        }
        if (!this.acceptToolchains(filterOptions, sdkFilterOptions)) {
            return false;
        }
        if (!this.acceptProcessorAndCores(filterOptions, sdkFilterOptions)) {
            return false;
        }
        return this.acceptModules(sdk);
    }

    protected boolean checkAvailability(IFilterOptions filterOptions, ISDK sdk) {
        return filterOptions.isCheckAvailability() ? sdk.isAvailable() : true;
    }

    protected boolean skipOptionsCheck(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        return sdkFilterOptions == null || filterOptions == null;
    }

    protected boolean acceptPlatform(IFilterOptions projectFilterOptions, IFilterOptions sdkFilterOptions) {
        boolean isAccepted = true;
        String sdkPlatformTarget = sdkFilterOptions.getPlatform();
        boolean bl = isAccepted = sdkPlatformTarget.isEmpty() || projectFilterOptions.getPlatform().equalsIgnoreCase(sdkPlatformTarget);
        if (isAccepted) {
            String sdkPlatformHost = sdkFilterOptions.getHost();
            isAccepted = sdkPlatformHost.isEmpty() || projectFilterOptions.getHost().startsWith(sdkPlatformHost);
        }
        return isAccepted;
    }

    protected boolean acceptLanguages(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        IFilterOptions.ELang sdkLang = sdkFilterOptions.getLang();
        return sdkLang.equals((Object)IFilterOptions.ELang.ALL) || sdkLang.equals((Object)IFilterOptions.ELang.UNKNOWN) || sdkLang.equals((Object)filterOptions.getLang());
    }

    protected boolean acceptToolchains(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        boolean isAccepted = true;
        IToolChain[] sdkToolChains = sdkFilterOptions.getToolChains();
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        IToolChain[] iToolChainArray = filterOptions.getToolChains();
        int n = iToolChainArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolChain tc = iToolChainArray[n2];
            isAccepted = checker.checkToolchainsCompatibility(sdkToolChains, tc);
            if (isAccepted) break;
            ++n2;
        }
        return isAccepted;
    }

    protected boolean acceptProcessorAndCores(IFilterOptions filterOptions, IFilterOptions sdkFilterOptions) {
        String projectCoreId;
        String projectDeviceCoreId;
        boolean isAccepted = true;
        String[] sdkCoreOptions = sdkFilterOptions.getCores();
        if (sdkCoreOptions.length == 0) {
            return true;
        }
        String[] projectCoreOptions = filterOptions.getCores();
        List<String> deviceIdList = SDKUtils.getDevicesbyOption(projectCoreOptions);
        List<String> deviceCoreIdList = SDKUtils.getDeviceCoresbyOption(projectCoreOptions);
        List<String> coreIdList = SDKUtils.getCoresbyOption(projectCoreOptions);
        String projectDeviceId = !deviceIdList.isEmpty() ? deviceIdList.get(0) : "";
        isAccepted = SDKFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdkCoreOptions, projectDeviceId, projectDeviceCoreId = !deviceCoreIdList.isEmpty() ? deviceCoreIdList.get(0) : "", projectCoreId = !coreIdList.isEmpty() ? coreIdList.get(0) : "");
        if (isAccepted) {
            return true;
        }
        CoreInfo expCoreInfo = new CoreInfo();
        CoreInfo sdkCoreInfo = new CoreInfo();
        String[] stringArray = filterOptions.getCores();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String expCoreString = stringArray[n2];
            expCoreInfo.init(expCoreString);
            if (Arrays.stream(sdkCoreOptions).anyMatch(sdkCoreString -> sdkCoreInfo.init(sdkCoreString).accept(expCoreInfo))) {
                return true;
            }
            ++n2;
        }
        return isAccepted;
    }

    protected boolean acceptModules(ISDK sdk) {
        Set<SdkModule> refModules = sdk.getModules().getRefModules();
        if (!refModules.isEmpty()) {
            List<ISDK> refModulesSdks = sdk.getModules().getRefModulesSdks();
            if (refModulesSdks.isEmpty()) {
                return false;
            }
            return refModulesSdks.stream().anyMatch(this::acceptOptions);
        }
        return true;
    }

    private class CoreInfo {
        private static final String PROC_CORE_SEPARATOR = ":";
        private static final String UNDEFINED = "$undefined$";
        private String procName;
        private String coreKind;

        private CoreInfo() {
        }

        private CoreInfo init(String coreString) {
            if (coreString != null && !coreString.isEmpty()) {
                String[] core = coreString.split(PROC_CORE_SEPARATOR);
                if (core.length == 1) {
                    this.procName = UNDEFINED;
                    this.coreKind = SDKUtils.unifyCoreKind(core[0]);
                } else {
                    this.procName = SDKUtils.unifyProcessor(core[0]);
                    this.coreKind = SDKUtils.unifyCoreKind(core[1]);
                }
            }
            return this;
        }

        private boolean accept(CoreInfo coreInfo) {
            return coreInfo.procName.equals(UNDEFINED) ? coreInfo.coreKind.equalsIgnoreCase(this.coreKind) : coreInfo.procName.equals(this.procName) && coreInfo.coreKind.equalsIgnoreCase(this.coreKind);
        }
    }
}

