/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.SDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.ISDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.SDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.ConflictedSDKsHandler;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.FilterOptions;
import com.freescale.s32ds.cross.sdk.internal.GitSDK;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKLoadException;
import com.freescale.s32ds.cross.sdk.internal.validation.SDKHeaderValidator;
import com.nxp.s32ds.cle.ide.sdk.core.SDKDescriptorParser;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModule;
import com.nxp.s32ds.cle.ide.sdk.core.modules.SdkModulesHolder;
import com.nxp.s32ds.cle.ide.sdk.core.resources.ProjectSourceFolder;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResource;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbol;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractSDK
implements ISDK {
    protected static final int FIELD_ID = 0;
    protected static final int FIELD_ALIAS = 1;
    protected IFilterOptions filterOptions;
    protected SDKHeader head;
    protected TCHolder root;
    protected TCHolder[] toolchains;
    protected SdkModulesHolder modulesHolder;
    protected static IValidator sdkHeaderValidator = new SDKHeaderValidator();
    protected ISDK.TYPE type;

    public AbstractSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions, TCHolder[] tcs) {
        this.head = Objects.requireNonNull(head);
        this.root = root;
        this.filterOptions = filterOptions;
        this.toolchains = tcs;
        this.modulesHolder = new SdkModulesHolder(this.getId(), this.getName(), this.getDescription());
    }

    @Override
    public SDKHeader getHeader() {
        return this.head;
    }

    @Override
    public void setHeader(SDKHeader head) {
        this.head = Objects.requireNonNull(head);
        this.modulesHolder = new SdkModulesHolder(this.getId(), this.getName(), this.getDescription());
    }

    @Override
    public TCHolder getRoot() {
        return this.root;
    }

    public String getName() {
        return this.head.getName();
    }

    public String getVersion() {
        return this.head.getVersion().toString();
    }

    public String getDescription() {
        String description = this.head.getDescription();
        return description == null ? "" : description;
    }

    @Override
    public IEnvironment getEnv() {
        return this.head.getEnv();
    }

    @Override
    public void setEnv(IEnvironment env) {
        this.head.setEnv(env);
    }

    @Override
    public TCHolder[] getToolchains() {
        return this.toolchains;
    }

    @Override
    public SdkModulesHolder getModules() {
        return this.modulesHolder;
    }

    @Override
    public void addModule(SdkModule module) {
        this.modulesHolder.addRefModule(module);
    }

    @Override
    public Set<String> getTags() {
        return this.head.getTags();
    }

    @Override
    public boolean isTaggedBy(String tag) {
        return this.head.isTaggedBy(tag);
    }

    @Override
    public String getTargetFolderName() {
        return this.head.getTargetFolderName();
    }

    @Override
    public String getTargetProjectTemplate() {
        return this.head.getTargetProjectTemplate();
    }

    @Override
    public String getExternalId() {
        return this.head.getExternalId();
    }

    @Override
    public String[] getIncludePaths(String toolchainId) {
        return this.getPaths(this.getHeaders(toolchainId));
    }

    @Override
    public String[] getBinariesPaths(String toolchainId) {
        return this.getPaths(this.getBinaries(toolchainId));
    }

    public String[] getBinariesPaths(ISDKFilter filter, String configToolChainId) {
        return this.getPaths(this.getResourcesPaths(this.root, 2, filter, configToolChainId));
    }

    @Override
    public String getPlatform() {
        return this.head.getPlatformTarget();
    }

    @Override
    public String getPlatformHost() {
        return this.head.getPlatformHost();
    }

    @Override
    public Map<String, Set<ProjectSourceFolder>> getProjectSourceFolders() {
        LinkedHashMap<String, Set<ProjectSourceFolder>> result = new LinkedHashMap<String, Set<ProjectSourceFolder>>();
        result.computeIfAbsent(this.root.getTCId(), s -> new LinkedHashSet()).addAll(this.root.getProjectStructure().getProjectSourceFolders());
        if (this.toolchains != null) {
            Arrays.stream(this.toolchains).forEach(tch -> {
                boolean bl = result.computeIfAbsent(tch.getTCId(), s -> new LinkedHashSet()).addAll(tch.getProjectStructure().getProjectSourceFolders());
            });
        }
        return result;
    }

    @Override
    public Set<ProjectSourceFolder> getProjectSourceFolders(String toolChainId) {
        LinkedHashSet<ProjectSourceFolder> result = new LinkedHashSet<ProjectSourceFolder>();
        result.addAll(this.root.getProjectStructure().getProjectSourceFolders());
        if (this.toolchains != null && toolChainId != null) {
            SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
            Arrays.stream(this.toolchains).filter(tch -> "all_toolchains".equals(toolChainId) || checker.checkToolchainsCompatibility(tch.getTCId(), toolChainId).isOK()).flatMap(tch -> tch.getProjectStructure().getProjectSourceFolders().stream()).forEach(result::add);
        }
        this.getModules().getRefModulesSdks().forEach(refSdk -> {
            boolean bl = result.addAll(refSdk.getProjectSourceFolders(toolChainId));
        });
        return result;
    }

    @Override
    public String[] getPaths(IExtendedPath[] paths) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Map<IEnvironment, Set<IExtendedPath>> pathsMap = this.modulesHolder.getPathsGroupByEnvironment(Arrays.asList(paths));
        for (Map.Entry<IEnvironment, Set<IExtendedPath>> e : pathsMap.entrySet()) {
            IEnvironment environment = e.getKey();
            IPath sdkBasePath = Path.fromOSString((String)SDKSupportPlugin.performStringSubstitution(environment.getValue(), null));
            String environmentName = environment.getName();
            for (IExtendedPath path : e.getValue()) {
                IExtendedPath parentPath = path.toFile().isDirectory() ? path : path.removeLastSegments(1);
                IPath relativePath = parentPath.makeRelativeTo(sdkBasePath);
                result.add(SDKResourcesHandler.INSTANCE.generateResourcePathString(relativePath, environmentName).replace('\\', '/'));
            }
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String[] getLocalPaths(IExtendedPath[] array, String local) {
        HashSet<String> paths = new HashSet<String>();
        String sdkdir = new Path(this.getEnv().getValue()).lastSegment();
        String prjpath = String.valueOf(local) + "/" + this.getName();
        IExtendedPath[] iExtendedPathArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String x;
            int n3;
            IExtendedPath p = iExtendedPathArray[n2];
            if (p.isCopy() && (n3 = (x = p.removeLastSegments(1).toOSString().replace('\\', '/')).indexOf(sdkdir)) >= 0) {
                paths.add(String.valueOf(prjpath) + x.substring(n3 + sdkdir.length()));
            }
            ++n2;
        }
        String[] res = new String[paths.size()];
        Iterator it = paths.iterator();
        int i = 0;
        while (i < res.length) {
            res[i] = ((String)it.next()).replace('\\', '/');
            ++i;
        }
        return res;
    }

    @Override
    public String[] getDefSymbols(String tcId) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.root.getDefSymbols());
        if (this.toolchains != null) {
            SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
            Stream.of(this.toolchains).filter(tch -> checker.checkToolchainsCompatibility(tch.getTCId(), tcId).isOK()).forEach(tch -> {
                boolean bl = result.addAll(tch.getDefSymbols());
            });
        }
        return result.toArray(new String[0]);
    }

    @Override
    public Map<String, SdkSymbolsHolder> getSymbols(String toolChainId) {
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        HashMap<String, SdkSymbolsHolder> result = new HashMap<String, SdkSymbolsHolder>();
        result.put(this.root.getTCId(), this.root.getSymbolsHolder());
        if (this.toolchains != null) {
            TCHolder[] tCHolderArray = this.toolchains;
            int n = this.toolchains.length;
            int n2 = 0;
            while (n2 < n) {
                TCHolder tcHolder = tCHolderArray[n2];
                if (toolChainId == null || "all_toolchains".equals(toolChainId) || checker.checkToolchainsCompatibility(tcHolder.getTCId(), toolChainId).isOK()) {
                    result.put(tcHolder.getTCId(), tcHolder.getSymbolsHolder());
                }
                ++n2;
            }
        }
        if (this.modulesHolder != null) {
            for (SdkModule module : this.modulesHolder.getRefModules()) {
                ISDK moduleSdk = SDKUtils.getSDKbyID(module.getSdkId());
                if (moduleSdk == null) continue;
                TCHolder moduleSdkRoot = moduleSdk.getRoot();
                String tcId = moduleSdkRoot.getTCId();
                SdkSymbolsHolder rootHolder = (SdkSymbolsHolder)result.get(tcId);
                if (rootHolder == null) {
                    result.put(tcId, moduleSdkRoot.getSymbolsHolder());
                } else {
                    Map<SdkSymbolTypes, List<SdkSymbol>> map = moduleSdkRoot.getSymbolsHolder().getSymbols();
                    for (Map.Entry<SdkSymbolTypes, List<SdkSymbol>> e : map.entrySet()) {
                        SdkSymbolTypes symbolType = e.getKey();
                        List<SdkSymbol> list = e.getValue();
                        list.stream().forEach(symbol -> rootHolder.addSymbol((SdkSymbol)symbol, symbolType));
                    }
                }
                TCHolder[] moduleSdkToolChains = moduleSdk.getToolchains();
                if (moduleSdkToolChains == null) continue;
                TCHolder[] tCHolderArray = moduleSdkToolChains;
                int n = moduleSdkToolChains.length;
                int n3 = 0;
                while (n3 < n) {
                    TCHolder tcHolder = tCHolderArray[n3];
                    if (this.isToolChainCompatible(toolChainId, tcHolder, checker)) {
                        SdkSymbolsHolder holder = (SdkSymbolsHolder)result.get(tcHolder.getTCId());
                        if (holder == null) {
                            result.put(tcHolder.getTCId(), tcHolder.getSymbolsHolder());
                        } else {
                            Map<SdkSymbolTypes, List<SdkSymbol>> map = tcHolder.getSymbolsHolder().getSymbols();
                            for (Map.Entry<SdkSymbolTypes, List<SdkSymbol>> e : map.entrySet()) {
                                SdkSymbolTypes symbolType = e.getKey();
                                List<SdkSymbol> list = e.getValue();
                                list.stream().forEach(symbol -> holder.addSymbol((SdkSymbol)symbol, symbolType));
                            }
                        }
                    }
                    ++n3;
                }
            }
        }
        return result;
    }

    private boolean isToolChainCompatible(String toolChainId, TCHolder tcHolder, ISDKCompatibilityChecker checker) {
        return toolChainId == null || "all_toolchains".equals(toolChainId) || checker.checkToolchainsCompatibility(tcHolder.getTCId(), toolChainId).isOK();
    }

    @Override
    public List<SdkSymbol> getDefinedSymbols() {
        return this.getSymbolsByType(SdkSymbolTypes.DEFINED);
    }

    @Override
    public List<SdkSymbol> getUndefinedSymbols() {
        return this.getSymbolsByType(SdkSymbolTypes.UNDEFINED);
    }

    private List<SdkSymbol> getSymbolsByType(SdkSymbolTypes type) {
        ArrayList<SdkSymbol> result = new ArrayList<SdkSymbol>();
        result.addAll(this.root.getSymbolsHolder().getSymbolsByType(type));
        if (this.toolchains != null) {
            Stream.of(this.toolchains).map(TCHolder::getSymbolsHolder).filter(Objects::nonNull).forEach(holder -> {
                boolean bl = result.addAll(holder.getSymbolsByType(type));
            });
        }
        return result;
    }

    @Override
    public IExtendedPath[] getSources(String toolchainId) {
        return this.union(this.root, this.toolchains, 0, toolchainId);
    }

    @Override
    public IExtendedPath[] getHeaders(String toolchainId) {
        return this.union(this.root, this.toolchains, 1, toolchainId);
    }

    @Override
    public IExtendedPath[] getBinaries(String toolchainId) {
        return this.union(this.root, this.toolchains, 2, toolchainId);
    }

    @Override
    public IExtendedPath[] getOtherResources(String toolchainId) {
        return this.union(this.root, this.toolchains, 3, toolchainId);
    }

    @Override
    public IExtendedPath[] getLinkerFiles(String toolchainId) {
        return this.union(this.root, this.toolchains, 4, toolchainId);
    }

    @Override
    public Map<String, List<IExtendedPath>> getIncludeFiles() {
        return SDKResourcesHandler.INSTANCE.getResourcesGroupByToolChainsIds(this, 5);
    }

    @Override
    public List<IExtendedPath> getIncludeFiles(String toolChainId) {
        Map<String, List<IExtendedPath>> allIncludeFiles = this.getIncludeFiles();
        if (allIncludeFiles == null || allIncludeFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IExtendedPath> resultIncludeFiles = new ArrayList<IExtendedPath>();
        List<IExtendedPath> rootIncludeFiles = allIncludeFiles.get(this.root.getTCId());
        if (rootIncludeFiles != null) {
            resultIncludeFiles.addAll(rootIncludeFiles);
        }
        if (this.toolchains == null || toolChainId == null) {
            return resultIncludeFiles;
        }
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        TCHolder[] tCHolderArray = this.toolchains;
        int n = this.toolchains.length;
        int n2 = 0;
        while (n2 < n) {
            TCHolder toolChainHolder = tCHolderArray[n2];
            String tcId = toolChainHolder.getTCId();
            List<IExtendedPath> tcFiles = allIncludeFiles.get(tcId);
            if (tcFiles != null && ("all_toolchains".equals(toolChainId) || checker.checkToolchainsCompatibility(tcId, toolChainId).isOK())) {
                resultIncludeFiles.addAll(tcFiles);
            }
            ++n2;
        }
        return resultIncludeFiles;
    }

    public Map<String, Set<IExtendedPath>> getBinaryFiles(ISDKFilter filter, String configToolChainId) {
        return this.getResourcesPaths(filter, configToolChainId, 2);
    }

    public String[] getIncludePaths(ISDKFilter filter, String configToolChainId) {
        return this.getPaths(this.getResourcesPaths(1, filter, configToolChainId, ""));
    }

    public String[] getIncludePaths(ISDKFilter filter, String configToolChainId, String langId) {
        return this.getPaths(this.getResourcesPaths(1, filter, configToolChainId, langId));
    }

    @Override
    public IExtendedPath[][] getResources(String tcId) {
        IExtendedPath[][] a = new IExtendedPath[][]{this.getSources(tcId), this.getBinaries(tcId), this.getHeaders(tcId), this.getOtherResources(tcId), this.getLinkerFiles(tcId)};
        return a;
    }

    @Override
    public IFilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    @Override
    public boolean isPex() {
        return this.head.isPEx();
    }

    @Override
    public String getStatusText() {
        return this.getStatus().toString();
    }

    public final String getId() {
        return this.head.getId();
    }

    public String toString() {
        IEnvironment ie = this.getEnv();
        return String.format("SDK[%s %s @ %s]", this.getName(), this.getVersion(), ie == null ? "NULL" : ie.getName());
    }

    @Override
    public void asXML(Document document, Element rootElement) throws ParserConfigurationException, UnsupportedEncodingException, TransformerException {
        IPath sdkPath = SDKSupportPlugin.getEclipsePath(this);
        if (sdkPath == null) {
            SDKSupportPlugin.log(String.format("NULL eclipse path for SDK: %s %s", this.getName(), this.getId()));
            Thread.dumpStack();
            return;
        }
        Element sdkElement = document.createElement("sdk");
        this.head.convertToXml(document, sdkElement, this.getToolChainIDs(), this.filterOptions);
        if (this.toolchains != null) {
            Arrays.stream(this.toolchains).forEach(tcHeader -> tcHeader.convertToXml(document, sdkElement, sdkPath));
        }
        this.root.convertResourcesToXml(document, sdkElement, sdkPath);
        this.modulesHolder.convertToXml(document, sdkElement);
        rootElement.appendChild(sdkElement);
    }

    public static IStatus parseSDKsString(String sdkDescriptors, IProject project, int origin, boolean isForceReload) {
        if (sdkDescriptors == null || sdkDescriptors.isEmpty()) {
            return Status.OK_STATUS;
        }
        try {
            List<ISDK> declaredSdkList = new SDKDescriptorParser().loadSDKs(sdkDescriptors, project, null, origin);
            List<ISDK> conflictSdkList = SDKUtils.add(declaredSdkList, isForceReload);
            if (conflictSdkList == null || conflictSdkList.isEmpty()) {
                return Status.OK_STATUS;
            }
            ConflictedSDKsHandler.INSTANCE.addConflictedSdks(project, conflictSdkList);
            SDKUtils.cleanUnusedSdkEnvironmentVariables();
        }
        catch (SDKLoadException sle) {
            SDKSupportPlugin.error((Throwable)((Object)sle));
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    public static void parseSDKsString(String sdksString, IProject project, int origin) {
        AbstractSDK.parseSDKsString(sdksString, project, origin, false);
    }

    public static List<ISDK> load(File f, int origin) {
        try {
            return AbstractSDK.loadXML(SDKUtils.toString(new FileInputStream(f)), null, f.getParent(), origin);
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
            return new ArrayList<ISDK>();
        }
    }

    public static List<ISDK> loadXML(String sdkString, IProject project, String alterEnvValue, int origin) throws SDKLoadException {
        ArrayList<ISDK> result = new ArrayList<ISDK>();
        if (sdkString == null || sdkString.length() == 0) {
            return result;
        }
        Element root = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(sdkString.getBytes("UTF-8"));
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(stream).getDocumentElement();
        }
        catch (Exception e) {
            SDKSupportPlugin.error(Messages.AbstractSDK_exception, e);
            return result;
        }
        if (!root.getNodeName().equals("sdks")) {
            SDKSupportPlugin.error(Messages.AbstractSDK_bad_format, null);
            return result;
        }
        NodeList list = root.getChildNodes();
        int i = 0;
        int numItems = list.getLength();
        while (i < numItems) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (!element.getNodeName().equals("sdk")) {
                    SDKSupportPlugin.error(String.format(Messages.AbstractSDK_bad_xml, node.getNodeName()), null);
                } else {
                    IStatus status = sdkHeaderValidator.validate((Object)element);
                    if (!status.isOK()) {
                        SDKSupportPlugin.log(status);
                    } else {
                        boolean createVar = origin != 3 && origin != 2;
                        SDKHeader hdr = new SDKHeader(createVar, element);
                        TCHolder rootHolder = new TCHolder(null);
                        rootHolder.setDefinedSymbols(element.getAttribute("symbols"));
                        if (hdr.getEnv() == null && createVar) {
                            hdr.setEnv(SDKSupportPlugin.createEnvironment(hdr.getName(), hdr.getVersion().toString(), false, true, alterEnvValue, hdr.getDescription()));
                        }
                        ArrayList<TCHolder> tclst = new ArrayList<TCHolder>();
                        NodeList children = element.getChildNodes();
                        int x = 0;
                        while (x < children.getLength()) {
                            Node n = children.item(x);
                            if (n.getNodeType() == 1) {
                                Element e;
                                String path = hdr.getBasePath();
                                if ((path == null || path.trim().isEmpty()) && hdr.getEnv() != null) {
                                    path = hdr.getEnv().getValue();
                                }
                                if ((e = (Element)n).getNodeName().equals("toolchain")) {
                                    TCHolder dht = new TCHolder(e, path, alterEnvValue);
                                    if (!dht.isEmpty()) {
                                        tclst.add(dht);
                                    }
                                } else {
                                    rootHolder.process(e, path, alterEnvValue);
                                }
                            }
                            ++x;
                        }
                        IFilterOptions filter = FilterOptions.createFilterOptions(hdr);
                        TCHolder[] tcs = null;
                        if (!tclst.isEmpty()) {
                            tcs = tclst.toArray(new TCHolder[tclst.size()]);
                            String s = String.join((CharSequence)",", AbstractSDK.getFields(tcs, 0));
                            filter = FilterOptions.createFilterOptions(hdr.getLangs(), s, hdr.getCores(), hdr.getPlatformTarget(), hdr.getPlatformHost());
                        }
                        switch (origin) {
                            case 2: 
                            case 3: 
                            case 6: {
                                result.add(new ImportSDK(hdr, rootHolder, filter, tcs, alterEnvValue));
                                break;
                            }
                            case 1: {
                                result.add(new GitSDK(hdr, rootHolder, filter, tcs));
                                break;
                            }
                            case 4: {
                                result.add(new ExternalSDK(hdr, rootHolder, filter));
                                break;
                            }
                            case 5: {
                                result.add(new ProjectLocalSDK(project, hdr, rootHolder, filter));
                                break;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static String getSDKsString(List<ISDK> sdks) {
        try {
            DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
            Document document = docBuilder.newDocument();
            Element rootElement = document.createElement("sdks");
            document.appendChild(rootElement);
            for (ISDK sdk : sdks) {
                sdk.asXML(document, rootElement);
            }
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            return s.toString("UTF8");
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            SDKSupportPlugin.error(Messages.AbstractSDK_exception_store, e);
            return "";
        }
    }

    @Override
    public ISDK.TYPE getType() {
        return this.type;
    }

    @Override
    public boolean isAvailable() {
        return new SDKAvailabilityChecker().checkAvailability(this.getId()).isOK();
    }

    @Override
    public String getBriefInfo() {
        return this.getName() + ' ' + this.getVersion() + ' ' + '@' + ' ' + this.getEnv().getName() + ' ' + '(' + this.getType().getName() + ')';
    }

    protected static String[] getFields(TCHolder[] tcs, int field) {
        if (tcs == null || tcs.length == 0) {
            return ZERO_ARR;
        }
        String[] res = new String[tcs.length];
        int i = 0;
        while (i < tcs.length) {
            switch (field) {
                case 0: {
                    res[i] = tcs[i].getTCId();
                    break;
                }
                case 1: {
                    res[i] = tcs[i].getTCAlias();
                    break;
                }
                default: {
                    SDKSupportPlugin.log(String.format(Messages.AbstractSDK_bad_field, field));
                }
            }
            ++i;
        }
        return res;
    }

    @Override
    public Map<String, Set<IExtendedPath>> getResourcesPaths(ISDKFilter filter, String toolChainId, int type) {
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        LinkedHashMap<String, Set<IExtendedPath>> result = new LinkedHashMap<String, Set<IExtendedPath>>();
        if (this.root != null) {
            Arrays.stream(this.root.get(type)).forEach(path -> {
                boolean bl = result.computeIfAbsent(this.getId(), s -> new LinkedHashSet()).add(path);
            });
        }
        result.computeIfAbsent(this.getId(), s -> new LinkedHashSet()).addAll(this.getToolChainResources(this.toolchains, toolChainId, checker, type));
        if (this.modulesHolder == null) {
            return result;
        }
        for (SdkModule module : this.modulesHolder.getRefModules(filter)) {
            ISDK refSdk = module.getSdk();
            if (refSdk == null) continue;
            String refSdkId = refSdk.getId();
            result.computeIfAbsent(refSdkId, s -> new LinkedHashSet()).addAll(refSdk.getResourcesPaths(filter, toolChainId, type).getOrDefault(refSdkId, Collections.emptySet()));
        }
        return result;
    }

    public Map<String, Set<IExtendedPath>> getResourcesPaths(ISDKFilter filter, String toolChainId, int type, String langId) {
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        LinkedHashMap<String, Set<IExtendedPath>> result = new LinkedHashMap<String, Set<IExtendedPath>>();
        if (this.root != null) {
            this.root.getResourceByType(type).stream().filter(res -> res.getLangId().equals(langId)).map(SdkResource::getPath).forEach(path -> {
                boolean bl = result.computeIfAbsent(this.getId(), s -> new LinkedHashSet()).add(path);
            });
        }
        result.computeIfAbsent(this.getId(), s -> new LinkedHashSet()).addAll(this.getToolChainResources(toolChainId, checker, type, langId));
        if (this.modulesHolder == null) {
            return result;
        }
        for (SdkModule module : this.modulesHolder.getRefModules(filter)) {
            AbstractSDK refSdk = (AbstractSDK)module.getSdk();
            if (refSdk == null) continue;
            String refSdkId = refSdk.getId();
            result.computeIfAbsent(refSdkId, s -> new LinkedHashSet()).addAll(refSdk.getResourcesPaths(filter, toolChainId, type, langId).getOrDefault(refSdkId, Collections.emptySet()));
        }
        return result;
    }

    protected IExtendedPath[] getResourcesPaths(TCHolder root, int type, ISDKFilter filter, String toolChainId) {
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        LinkedHashSet<IExtendedPath> result = new LinkedHashSet<IExtendedPath>();
        if (root != null) {
            Arrays.stream(root.get(type)).forEach(result::add);
        }
        result.addAll(this.getToolChainResources(this.toolchains, toolChainId, checker, type));
        if (this.modulesHolder != null) {
            for (SdkModule module : this.modulesHolder.getRefModules(filter)) {
                ISDK moduleSdk = SDKUtils.getSDKbyID(module.getSdkId());
                if (moduleSdk == null) continue;
                TCHolder moduleSdkRoot = moduleSdk.getRoot();
                if (moduleSdkRoot != null) {
                    Arrays.stream(moduleSdkRoot.get(type)).forEach(result::add);
                }
                result.addAll(this.getToolChainResources(moduleSdk.getToolchains(), toolChainId, checker, type));
            }
        }
        return result.toArray(new IExtendedPath[0]);
    }

    public IExtendedPath[] getResourcesPaths(int type, ISDKFilter filter, String toolChainId, String langId) {
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        LinkedHashSet<IExtendedPath> result = new LinkedHashSet<IExtendedPath>();
        if (this.root != null) {
            this.root.getResourceByType(type).stream().filter(resource -> resource.getLangId().equals(langId)).map(SdkResource::getPath).forEach(result::add);
        }
        result.addAll(this.getToolChainResources(toolChainId, checker, type, langId));
        if (this.modulesHolder != null) {
            for (SdkModule module : this.modulesHolder.getRefModules(filter)) {
                AbstractSDK moduleSdk = (AbstractSDK)module.getSdk();
                if (moduleSdk == null) continue;
                result.addAll(Arrays.asList(moduleSdk.getResourcesPaths(type, filter, toolChainId, langId)));
            }
        }
        return result.toArray(new IExtendedPath[0]);
    }

    private Set<IExtendedPath> getToolChainResources(TCHolder[] toolChainsHolders, String configToolChainId, ISDKCompatibilityChecker checker, int type) {
        if (toolChainsHolders == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(toolChainsHolders).filter(toolChainHolder -> this.isToolChainCompatible(configToolChainId, (TCHolder)toolChainHolder, checker)).flatMap(toolChainHolder -> Arrays.stream(toolChainHolder.get(type))).collect(Collectors.toSet());
    }

    private Set<IExtendedPath> getToolChainResources(String configToolChainId, ISDKCompatibilityChecker checker, int type, String langId) {
        if (this.toolchains == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(this.toolchains).filter(toolChainHolder -> this.isToolChainCompatible(configToolChainId, (TCHolder)toolChainHolder, checker)).flatMap(toolChainHolder -> toolChainHolder.getResourceByType(type).stream()).filter(r -> langId.equals(r.getLangId())).map(SdkResource::getPath).collect(Collectors.toSet());
    }

    protected IExtendedPath[] union(TCHolder root, TCHolder[] tcHolders, int type, String tc) {
        LinkedHashSet result = new LinkedHashSet();
        if (root != null) {
            Stream.of(root.get(type)).forEach(result::add);
        }
        SDKCompatibilityChecker checker = new SDKCompatibilityChecker();
        if (tcHolders != null && tc != null) {
            Stream.of(tcHolders).filter(tch -> "all_toolchains".equals(tc) || checker.checkToolchainsCompatibility(tch.getTCId(), tc).isOK()).flatMap(tch -> Stream.of(tch.get(type))).forEach(result::add);
        }
        if (this.modulesHolder != null) {
            for (SdkModule module : this.modulesHolder.getRefModules(tc)) {
                TCHolder[] moduleSdkToolChains;
                ISDK moduleSdk = SDKUtils.getSDKbyID(module.getSdkId());
                if (moduleSdk == null) continue;
                TCHolder moduleSdkRoot = moduleSdk.getRoot();
                if (moduleSdkRoot != null) {
                    Arrays.stream(moduleSdkRoot.get(type)).forEach(result::add);
                }
                if ((moduleSdkToolChains = moduleSdk.getToolchains()) == null) continue;
                Arrays.stream(moduleSdkToolChains).filter(tcHolder -> this.isToolChainCompatible(tc, (TCHolder)tcHolder, checker)).flatMap(tcHolder -> Arrays.stream(tcHolder.get(type))).forEach(result::add);
            }
        }
        return result.toArray(TCHolder.EMPTY_PATHS);
    }

    protected List<String> getSymbolsNames(String toolChainId, SdkSymbolTypes type) {
        return this.getSymbols(toolChainId).values().stream().map(v -> v.getSymbols().get((Object)type)).filter(Objects::nonNull).flatMap(Collection::stream).filter(SdkSymbol::isCommon).map(SdkSymbol::getSymbolName).collect(Collectors.toList());
    }
}

