/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.namechecker;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.checkers.sdk.namechecker.ISDKNameChecker;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SDKNameChecker
implements ISDKNameChecker {
    @Override
    public IStatus checkName(ISDK sdk, IProject project) {
        if (project != null) {
            IFile rootFile = project.getFile(sdk.getTargetFolderName());
            if (rootFile.exists()) {
                return ISDKAttachStatuses.ERROR_PROJECT_ROOT_FILE_CONFLICT;
            }
            IPath sdkFolderPath = project.getFolder(sdk.getTargetFolderName()).getFullPath();
            IResource resourceVariant = ((Resource)project).findExistingResourceVariant(sdkFolderPath);
            if (resourceVariant != null && !resourceVariant.getFullPath().equals((Object)sdkFolderPath)) {
                if (1 == resourceVariant.getType()) {
                    return ISDKAttachStatuses.ERROR_PROJECT_ROOT_FILE_CONFLICT;
                }
                if (2 == resourceVariant.getType()) {
                    return ISDKAttachStatuses.ERROR_PROJECT_FOLDER_EXIST;
                }
            }
        }
        return Status.OK_STATUS;
    }
}

