/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.ISDKFilesCheckerResult;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKConflictedFilesChecker;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKFilesCheckerResult;
import com.freescale.s32ds.cross.sdk.checkers.sdk.filechecker.SDKMissedFilesChecker;
import com.freescale.s32ds.cross.sdk.internal.AvailableSDKFilter;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public abstract class SDKFilesChecker
implements ISDKFilesChecker {
    private final ISDK sdk;
    private IPath sdkBasePath;
    private final IProject project;
    private static Map<String, Set<String>> sdkCheckDone = new HashMap<String, Set<String>>();

    protected SDKFilesChecker(ISDK sdk, IProject project) {
        this.sdk = Objects.requireNonNull(sdk, "SDK must not be null");
        this.sdkBasePath = Objects.requireNonNull(SDKSupportPlugin.getEclipsePath(sdk));
        this.project = Objects.requireNonNull(project, "Project must not be null");
    }

    public static ISDKFilesChecker getFilesChecker(ISDK sdk, IProject project, ISDKFilesChecker.Mode mode) {
        switch (mode) {
            case MISSED: {
                return new SDKMissedFilesChecker(sdk, project);
            }
            case CONFLICTED: {
                return new SDKConflictedFilesChecker(sdk, project);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public ISDKFilesCheckerResult checkFiles() {
        SDKFilesCheckerResult result = new SDKFilesCheckerResult();
        result.setResultFiles(this.findFiles(this.collectSDKFiles()));
        return result;
    }

    @Override
    public void setCheckDone(boolean isDone) {
        Set<String> sdks = sdkCheckDone.get(this.project.getName());
        if (isDone) {
            if (sdks == null) {
                sdks = new HashSet<String>();
            }
            sdks.add(this.sdk.getId());
            sdkCheckDone.put(this.project.getName(), sdks);
        } else if (sdks != null) {
            sdks.remove(this.sdk.getId());
            if (sdks.isEmpty()) {
                sdkCheckDone.remove(this.project.getName());
            }
        }
    }

    @Override
    public boolean isCheckDone() {
        Set<String> sdks = sdkCheckDone.get(this.project.getName());
        return sdks != null && sdks.contains(this.sdk.getId());
    }

    protected abstract boolean checkFile(IFile var1);

    protected boolean checkPathAndType(IExtendedPath path, ISDKFilesChecker.FileTypes type) {
        return true;
    }

    private Map<String, Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>>> collectSDKFiles() {
        String toolChainId = this.getDefaultToolChainId();
        if (toolChainId == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>>> sdkFiles = new LinkedHashMap<String, Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>>>();
        sdkFiles.put(this.sdk.getId(), this.getSdkResourcesPaths(this.sdk, toolChainId));
        AvailableSDKFilter filter = new AvailableSDKFilter(this.project);
        this.sdk.getModules().getRefModulesSdks(filter).stream().forEach(refSdk -> {
            Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>> map2 = sdkFiles.put(refSdk.getId(), this.getSdkResourcesPaths((ISDK)refSdk, toolChainId));
        });
        return sdkFiles;
    }

    private String getDefaultToolChainId() {
        IToolChain toolChain;
        IConfiguration defaultConfiguration;
        String toolChainId = null;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)this.project);
        if (buildInfo != null && (defaultConfiguration = buildInfo.getDefaultConfiguration()) != null && (toolChain = defaultConfiguration.getToolChain()) != null) {
            toolChainId = toolChain.getBaseId();
        }
        return toolChainId;
    }

    private Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>> getSdkResourcesPaths(ISDK refSdk, String toolchainId) {
        Map<Integer, List<IExtendedPath>> resources = SDKResourcesHandler.INSTANCE.getResources(refSdk, toolchainId);
        LinkedHashMap<ISDKFilesChecker.FileTypes, List<IExtendedPath>> sdkFiles = new LinkedHashMap<ISDKFilesChecker.FileTypes, List<IExtendedPath>>();
        sdkFiles.put(ISDKFilesChecker.FileTypes.SOURCE, resources.get(0));
        sdkFiles.put(ISDKFilesChecker.FileTypes.HEADER, resources.get(1));
        sdkFiles.put(ISDKFilesChecker.FileTypes.BINARY, resources.get(2));
        sdkFiles.put(ISDKFilesChecker.FileTypes.LINKER, resources.get(4));
        sdkFiles.put(ISDKFilesChecker.FileTypes.OTHERS, resources.get(3));
        return sdkFiles;
    }

    private Map<String, Set<IExtendedPath>> findFiles(Map<String, Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>>> pathMap) {
        LinkedHashMap<String, Set<IExtendedPath>> foundFiles = new LinkedHashMap<String, Set<IExtendedPath>>();
        for (Map.Entry<String, Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>>> pathsBySdkId : pathMap.entrySet()) {
            String sdkId = pathsBySdkId.getKey();
            Map<ISDKFilesChecker.FileTypes, List<IExtendedPath>> pathsByTypeMap = pathsBySdkId.getValue();
            for (Map.Entry<ISDKFilesChecker.FileTypes, List<IExtendedPath>> pathsByType : pathsByTypeMap.entrySet()) {
                ISDKFilesChecker.FileTypes fileType = pathsByType.getKey();
                pathsByType.getValue().stream().filter(path -> this.performCheck((IExtendedPath)path, sdkId, fileType)).forEach(path -> {
                    boolean bl = foundFiles.computeIfAbsent(sdkId, s -> new LinkedHashSet()).add(path);
                });
            }
        }
        return foundFiles;
    }

    private boolean performCheck(IExtendedPath path, String sdkId, ISDKFilesChecker.FileTypes fileType) {
        boolean result = false;
        if (!path.toFile().isDirectory() && this.checkPathAndType(path, fileType)) {
            if (this.sdkBasePath.isPrefixOf((IPath)path)) {
                if (this.sdk.getModules().hasModules()) {
                    return this.checkModuleSdksFiles(path, sdkId);
                }
                IFile file = SDKResourcesHandler.INSTANCE.getTargetFile(path, this.sdk, this.project);
                if (file == null || this.checkFile(file)) {
                    return true;
                }
            } else {
                return this.checkModuleSdksFiles(path, sdkId);
            }
        }
        return result;
    }

    private boolean checkModuleSdksFiles(IExtendedPath path, String sdkId) {
        IFile file;
        IPath refSdkBasePath;
        ISDK refSdk = this.sdk.getModules().getRefModulesSdks().stream().filter(s -> s.getId().equals(sdkId)).findFirst().orElse(null);
        return refSdk != null && (refSdkBasePath = SDKSupportPlugin.getEclipsePath(refSdk)) != null && refSdkBasePath.isPrefixOf((IPath)path) && ((file = (IFile)SDKResourcesHandler.INSTANCE.getTargetResource(path, refSdk, this.project, this.sdk)) == null || this.checkFile(file));
    }
}

