/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.compatibility.ISDKCompatibilityChecker;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.sdk.internal.SDKFilteringUtils;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class SDKCompatibilityChecker
implements ISDKCompatibilityChecker {
    private static final String EXT_POINT_ID = "tc_prefixes";
    private static final String CONFIG_ELEMENT = "tcprefix";
    private static final String PREFIX_ATTRIBUTE = "prefix";
    private static final String EMPTY = "";
    private static Set<String> prefixes;

    static {
        SDKCompatibilityChecker.loadToolchainsPrefixes();
    }

    @Override
    public Boolean[] checkToolchainsCompatibility(ISDK sdk, IProject project) {
        IConfiguration[] cfgs = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int configsCount = cfgs.length;
        Boolean[] states = new Boolean[configsCount];
        if (!this.checkCore(project, sdk)) {
            return states;
        }
        String[] sdkToolchainIds = sdk.getToolChainIDs();
        boolean sdkHasToolchains = this.hasToolchains(sdkToolchainIds);
        int i = 0;
        while (i < configsCount) {
            if (!sdkHasToolchains) {
                states[i] = SDKAttach.isAttached(project.getName(), cfgs[i].getName(), sdk.getId());
            } else {
                IToolChain tc = cfgs[i].getToolChain();
                if (this.matchToolchains(sdkToolchainIds, tc)) {
                    states[i] = SDKAttach.isAttached(project.getName(), cfgs[i].getName(), sdk.getId());
                }
            }
            ++i;
        }
        return states;
    }

    @Override
    public IStatus checkToolchainsCompatibility(ISDK sdk, IProject project, IConfiguration configuration) {
        String[] sdkToolchainIds = sdk.getToolChainIDs();
        return !this.hasToolchains(sdkToolchainIds) ? Status.OK_STATUS : (this.matchToolchains(sdkToolchainIds, configuration.getToolChain()) ? Status.OK_STATUS : ISDKAttachStatuses.ERROR_SDK_TOOLCHAIN);
    }

    @Override
    public IStatus checkToolchainsCompatibility(String sdkToolchainId, String configToolchainId) {
        String toolchainPrefix = this.matchToolchain(sdkToolchainId);
        return toolchainPrefix == null || !configToolchainId.matches(toolchainPrefix) ? ISDKAttachStatuses.ERROR_SDK_TOOLCHAIN : Status.OK_STATUS;
    }

    @Override
    public boolean checkToolchainsCompatibility(IToolChain[] toolchains, IToolChain tc) {
        String[] toolchainIds = (String[])Arrays.asList(toolchains).stream().map(IBuildObject::getId).toArray(String[]::new);
        return !this.hasToolchains(toolchainIds) ? true : this.matchToolchains(toolchainIds, tc);
    }

    private boolean hasToolchains(String[] tcIds) {
        if (tcIds != null && tcIds.length > 0) {
            String[] stringArray = tcIds;
            int n = tcIds.length;
            int n2 = 0;
            while (n2 < n) {
                String t = stringArray[n2];
                if (t != null && t.trim().length() > 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean matchToolchains(String[] toolchainIds, IToolChain tc) {
        if (prefixes.isEmpty()) {
            return true;
        }
        boolean result = false;
        String cfgToolchainId = tc.getId();
        String cfgToolchainBaseId = tc.getBaseId();
        IToolChain rtc = ManagedBuildManager.getRealToolChain((IToolChain)tc);
        String rtcId = rtc != null ? rtc.getBaseId() : "~";
        String[] stringArray = toolchainIds;
        int n = toolchainIds.length;
        int n2 = 0;
        while (n2 < n) {
            String sdkToolchainId = stringArray[n2];
            String toolchainIdPrefix = this.matchToolchain(sdkToolchainId);
            if (toolchainIdPrefix == null) {
                return false;
            }
            if (sdkToolchainId == null || sdkToolchainId.trim().isEmpty() || cfgToolchainId.matches(toolchainIdPrefix) || cfgToolchainBaseId.matches(toolchainIdPrefix) || rtcId.matches(toolchainIdPrefix)) {
                result = true;
                break;
            }
            ++n2;
        }
        return result;
    }

    private String matchToolchain(String toolchainId) {
        for (String prefix : prefixes) {
            if (prefix == null || !toolchainId.matches(prefix)) continue;
            return prefix;
        }
        return null;
    }

    private static void loadToolchainsPrefixes() {
        prefixes = new HashSet<String>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("com.freescale.s32ds.cross.sdk.support.tc_prefixes");
        if (ep != null) {
            IExtension[] iExtensionArray = ep.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    if (ce.getName().equals(CONFIG_ELEMENT)) {
                        prefixes.add(ce.getAttribute(PREFIX_ATTRIBUTE));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean checkCore(IProject proj, ISDK sdk) {
        ProjectContextSaver projectContext = new ProjectContextSaver(proj);
        String projectDeviceCoreId = projectContext.load("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String projectDeviceId = projectContext.load("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        String projectCoreId = projectContext.load("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        if (!(projectDeviceId.isEmpty() && projectDeviceCoreId.isEmpty() && projectCoreId.isEmpty())) {
            return SDKFilteringUtils.isSdkAcceptsProjectComponentHardwareIds(sdk, projectDeviceId, projectDeviceCoreId, projectCoreId);
        }
        return this.isSdkAcceptsProjectSettingHardwareIds(sdk, proj);
    }

    private boolean isSdkAcceptsProjectSettingHardwareIds(ISDK sdk, IProject proj) {
        String[] sdkCoreOptions = sdk.getFilterOptions().getCores();
        ProjectSettings ps = new ProjectSettings(proj, "com.freescale.s32ds.cross.wizard");
        String processorId = ps.load("processor");
        String coreId = ps.load("coreType");
        if (!processorId.isEmpty() && !coreId.isEmpty()) {
            if (coreId.toLowerCase().startsWith(processorId.toLowerCase())) {
                coreId = coreId.substring(processorId.length() + 1);
            }
            coreId = SDKUtils.unifyCoreKind(coreId);
            boolean fitsC = false;
            String[] stringArray = sdkCoreOptions;
            int n = sdkCoreOptions.length;
            int n2 = 0;
            while (n2 < n) {
                String coreSDK = stringArray[n2];
                if (SDKCompatibilityChecker.getCoreFromFilterData(coreSDK).equalsIgnoreCase(coreId)) {
                    fitsC = true;
                }
                ++n2;
            }
            if (!fitsC && sdkCoreOptions.length > 0) {
                return false;
            }
            processorId = SDKUtils.unifyProcessor(processorId);
            boolean fitsP = false;
            String[] stringArray2 = sdkCoreOptions;
            int n3 = sdkCoreOptions.length;
            n = 0;
            while (n < n3) {
                String coreSDK = stringArray2[n];
                if (SDKCompatibilityChecker.getProcFromFilterData(coreSDK).equalsIgnoreCase(processorId)) {
                    fitsP = true;
                    break;
                }
                ++n;
            }
            if (!fitsP && sdkCoreOptions.length > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public IStatus checkCore(ISDK sdk, IProject project) {
        return this.checkCore(project, sdk) ? Status.OK_STATUS : ISDKAttachStatuses.ERROR_SDK_PROCESSOR_CORE;
    }

    private static String getProcFromFilterData(String data) {
        if (data == null || data.isEmpty()) {
            return EMPTY;
        }
        int n = data.indexOf(58);
        return n > 0 ? SDKUtils.unifyProcessor(data.substring(0, n)) : EMPTY;
    }

    private static String getCoreFromFilterData(String data) {
        if (data == null || data.isEmpty()) {
            return EMPTY;
        }
        int n = data.indexOf(58);
        return SDKUtils.unifyCoreKind(n > 0 ? data.substring(++n) : data);
    }

    @Override
    public boolean checkLang(IProject proj, ISDK sdk) {
        ProjectSettings ps = new ProjectSettings(proj, "com.freescale.s32ds.cross.wizard");
        String lang = ps.load("language");
        IFilterOptions.ELang langPRJ = lang.equalsIgnoreCase("c") ? IFilterOptions.ELang.C : (lang.equalsIgnoreCase("c++") ? IFilterOptions.ELang.CPP : IFilterOptions.ELang.UNKNOWN);
        IFilterOptions.ELang langSDK = sdk.getFilterOptions().getLang();
        return (!langPRJ.equals((Object)IFilterOptions.ELang.C) || !langSDK.equals((Object)IFilterOptions.ELang.CPP)) && (!langPRJ.equals((Object)IFilterOptions.ELang.CPP) || !langSDK.equals((Object)IFilterOptions.ELang.C));
    }

    @Override
    public IStatus checkLanguage(ISDK sdk, IProject project) {
        return this.checkLang(project, sdk) ? Status.OK_STATUS : ISDKAttachStatuses.ERROR_SDK_LANGUAGE;
    }

    @Override
    public boolean checkTool(IProject proj, ISDK sdk, IToolChain tcCfg) {
        IToolChain[] tcsSDK = sdk.getFilterOptions().getToolChains();
        return tcCfg == null || tcsSDK == null || tcsSDK.length <= 0 || this.checkToolchainsCompatibility(tcsSDK, tcCfg);
    }

    @Override
    public IStatus checkPlatform(IProject project, ISDK sdk) {
        ProjectContextSaver projectContext = new ProjectContextSaver(project);
        String projectPlatformTarget = projectContext.load("com.nxp.s32ds.cle.runtime.component.registry.archetype.platform.id");
        String sdkPlatformTarget = sdk.getFilterOptions().getPlatform();
        if (sdkPlatformTarget.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (sdkPlatformTarget.equals(projectPlatformTarget.toLowerCase())) {
            return Status.OK_STATUS;
        }
        return ISDKAttachStatuses.ERROR_SDK_PLATFORM;
    }

    @Override
    public IStatus checkPlatformHost(IProject project, ISDK sdk) {
        String platformHost = Platform.getOS();
        String sdkPlatformHost = sdk.getFilterOptions().getHost();
        if (sdkPlatformHost.isEmpty()) {
            return Status.OK_STATUS;
        }
        if (platformHost.toLowerCase().startsWith(sdkPlatformHost)) {
            return Status.OK_STATUS;
        }
        return ISDKAttachStatuses.ERROR_SDK_PLATFORM;
    }
}

