/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.sdk.availability;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.checkers.sdk.availability.ISDKAvailabilityChecker;
import com.freescale.s32ds.cross.sdk.internal.attach.ISDKAttachStatuses;
import java.util.Arrays;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SDKAvailabilityChecker
implements ISDKAvailabilityChecker {
    @Override
    public IStatus checkAvailability(String sdkId) {
        ISDK sdk = SDKUtils.getSDKbyID(sdkId);
        if (sdk == null) {
            return ISDKAttachStatuses.ERROR_SDK_MISSED;
        }
        return this.isLocationIncorrect(sdk) ? ISDKAttachStatuses.ERROR_SDK_LOCATION : Status.OK_STATUS;
    }

    @Override
    public IStatus checkAvailability(ISDK sdk) {
        return this.checkAvailability(sdk.getId());
    }

    private boolean isLocationIncorrect(ISDK sdk) {
        IPath sdkPath = SDKSupportPlugin.getEclipsePath(sdk);
        return sdkPath == null || sdkPath.isEmpty() || !sdkPath.toFile().exists() || sdk.getModules().getRefModules().isEmpty() && !this.checkFilesPathsConsistency(sdk);
    }

    private boolean checkFilesPathsConsistency(ISDK sdk) {
        IPath sdkEnvPath = SDKSupportPlugin.getEclipsePath(sdk);
        if (!this.checkFilesPaths(sdk.getAll(2), sdkEnvPath)) {
            return false;
        }
        if (!this.checkFilesPaths(sdk.getAll(1), sdkEnvPath)) {
            return false;
        }
        if (!this.checkFilesPaths(sdk.getAll(4), sdkEnvPath)) {
            return false;
        }
        if (!this.checkFilesPaths(sdk.getAll(3), sdkEnvPath)) {
            return false;
        }
        return this.checkFilesPaths(sdk.getAll(0), sdkEnvPath);
    }

    private boolean checkFilesPaths(IExtendedPath[][] filesPaths, IPath sdkEnvPath) {
        if (filesPaths == null || filesPaths.length == 0) {
            return true;
        }
        return !Stream.of(filesPaths).flatMap(Arrays::stream).filter(ep -> !ep.isEmpty() && ep.isAbsolute()).anyMatch(ep -> !sdkEnvPath.isPrefixOf((IPath)ep));
    }
}

