/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker;

import com.freescale.s32ds.cross.sdk.checkers.cproject.UnsupportedProjectTypeException;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.IToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.ToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.ToolChainToolsFPChecker;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ToolChainFPCheckerFactory {
    private static final String GCC_PROJECT_TYPE = "com.freescale.s32ds.cross.gnu.arm.cortexm.exe";
    private static final String GCC_PROJECT_TYPE_LIB = "com.freescale.s32ds.cross.gnu.arm.cortexm.lib";
    private static final String GHS_PROJECT_TYPE = "ghs.managedmake.arm.executable";
    private static final String GHS_PROJECT_TYPE_LIB = "ghs.managedmake.arm.static_library";
    private static final String IAR_PROJECT_TYPE = "iar.arm.toolchain.project.exe.v5.4.0";
    private static final String IAR_PROJECT_TYPE_LIB = "iar.arm.toolchain.project.library.v5.4.0";
    private static final String ARM32_PROJECT_TYPE = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.exe";
    private static final String ARM32_PROJECT_TYPE_LIB = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.lib";
    private static final String GCC_FLOAT_ABI_OPTION_ID = "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.fpu.abi";
    private static final String GCC_FLOAT_ABI_VALUE_HARD_ID = "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.fpu.abi.hard";
    private static final String GCC_FPU_TYPE_VALUE_FPV4SPD16_ID = "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.fpu.unit.fpv4spd16";
    private static final String GCC_FPU_TYPE_OPTION_ID = "com.freescale.s32ds.cross.gnu.arm.cortexm.option.target.fpu.unit";
    private static final String ARM32_FLOAT_ABI_OPTION_ID = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.option.target.fpu.abi";
    private static final String ARM32_FLOAT_ABI_VALUE_HARD_ID = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.option.target.fpu.abi.hard";
    private static final String ARM32_FPU_TYPE_OPTION_ID = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.option.target.fpu.unit";
    private static final String ARM32_FPU_TYPE_VALUE_FP5D16_ID = "com.nxp.s32ds.cle.arm.mbs.arm32.bare.option.target.fpu.unit";
    private static final String IAR_FPU_OPTION_ID = "iar.arm.toolchain.option.fpu.v5.4.0";
    private static final String IAR_FPU_VALUE_VFP_V_4_ID = "iar.arm.toolchain.common.option.fpu.VFPv4.v5.5.0";
    private static final String GHS_CC_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cc_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cc_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CC_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cc_linker.target_floating_point.floating_point_mode";
    private static final String GHS_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cc_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CX_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cx_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cx_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_CX_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.executable.toolchain.cx_linker.target_floating_point.floating_point_mode";
    private static final String GHS_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.executable.toolchain.cx_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_LIB_CC_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cc_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_LIB_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cc_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_LIB_CX_COMPILER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cx_compiler.target_floating_point.floating_point_mode";
    private static final String GHS_LIB_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cx_compiler.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_LIB_CC_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cc_linker.target_floating_point.floating_point_mode";
    private static final String GHS_LIB_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cc_linker.target_floating_point.floating_point_mode.hardware_single_software_double";
    private static final String GHS_LIB_CX_LINKER_FP_COPROCESSOR_OPTION_ID = "ghs.managedmake.arm.static_library.toolchain.cx_linker.target_floating_point.floating_point_mode";
    private static final String GHS_LIB_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID = "ghs.managedmake.arm.static_library.toolchain.cx_linker.target_floating_point.floating_point_mode.hardware_single_software_double";

    public static IToolChainFPChecker getToolchainFPChecker(IManagedProject project) throws UnsupportedProjectTypeException, CoreException {
        String projectTypeId = "- unknown -";
        if (project == null) {
            throw new UnsupportedProjectTypeException(projectTypeId);
        }
        boolean isCppNatureProject = ToolChainFPCheckerFactory.isCppProject(project);
        IProjectType projectType = project.getProjectType();
        switch (projectTypeId = projectType.getId()) {
            case "com.freescale.s32ds.cross.gnu.arm.cortexm.exe": 
            case "com.freescale.s32ds.cross.gnu.arm.cortexm.lib": {
                return ToolChainFPCheckerFactory.getGCCToolChainFPChecker();
            }
            case "ghs.managedmake.arm.executable": {
                return ToolChainFPCheckerFactory.getGHSToolChainFPChecker(isCppNatureProject, false);
            }
            case "ghs.managedmake.arm.static_library": {
                return ToolChainFPCheckerFactory.getGHSToolChainFPChecker(isCppNatureProject, true);
            }
            case "iar.arm.toolchain.project.exe.v5.4.0": 
            case "iar.arm.toolchain.project.library.v5.4.0": {
                return ToolChainFPCheckerFactory.getIARToolChainFPChecker();
            }
            case "com.nxp.s32ds.cle.arm.mbs.arm32.bare.exe": 
            case "com.nxp.s32ds.cle.arm.mbs.arm32.bare.lib": {
                return ToolChainFPCheckerFactory.getARM32ToolChainFPChecker();
            }
        }
        throw new UnsupportedProjectTypeException(projectTypeId);
    }

    private static IToolChainFPChecker getGCCToolChainFPChecker() {
        ToolChainFPChecker checker = new ToolChainFPChecker();
        checker.addCheckOption(GCC_FLOAT_ABI_OPTION_ID, GCC_FLOAT_ABI_VALUE_HARD_ID);
        checker.addCheckOption(GCC_FPU_TYPE_OPTION_ID, GCC_FPU_TYPE_VALUE_FPV4SPD16_ID);
        return checker;
    }

    private static IToolChainFPChecker getGHSToolChainFPChecker(boolean isCppNatureProject, boolean isLibrary) {
        ToolChainToolsFPChecker checker = new ToolChainToolsFPChecker();
        if (isLibrary) {
            checker.addCheckOption(GHS_LIB_CC_COMPILER_FP_COPROCESSOR_OPTION_ID, GHS_LIB_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            if (isCppNatureProject) {
                checker.addCheckOption(GHS_LIB_CX_COMPILER_FP_COPROCESSOR_OPTION_ID, GHS_LIB_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
                checker.addCheckOption(GHS_LIB_CX_LINKER_FP_COPROCESSOR_OPTION_ID, GHS_LIB_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            } else {
                checker.addCheckOption(GHS_LIB_CC_LINKER_FP_COPROCESSOR_OPTION_ID, GHS_LIB_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            }
        } else {
            checker.addCheckOption(GHS_CC_COMPILER_FP_COPROCESSOR_OPTION_ID, GHS_CC_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            if (isCppNatureProject) {
                checker.addCheckOption(GHS_CX_COMPILER_FP_COPROCESSOR_OPTION_ID, GHS_CX_COMPILER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
                checker.addCheckOption(GHS_CX_LINKER_FP_COPROCESSOR_OPTION_ID, GHS_CX_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            } else {
                checker.addCheckOption(GHS_CC_LINKER_FP_COPROCESSOR_OPTION_ID, GHS_CC_LINKER_FP_COPROCESSOR_VALUE_HW_COPROCESSOR_ID);
            }
        }
        return checker;
    }

    private static IToolChainFPChecker getIARToolChainFPChecker() {
        ToolChainFPChecker checker = new ToolChainFPChecker();
        checker.addCheckOption(IAR_FPU_OPTION_ID, IAR_FPU_VALUE_VFP_V_4_ID);
        return checker;
    }

    private static IToolChainFPChecker getARM32ToolChainFPChecker() {
        ToolChainFPChecker checker = new ToolChainFPChecker();
        checker.addCheckOption(ARM32_FLOAT_ABI_OPTION_ID, ARM32_FLOAT_ABI_VALUE_HARD_ID);
        checker.addCheckOption("com.nxp.s32ds.cle.arm.mbs.arm32.bare.option.target.fpu.unit", "com.nxp.s32ds.cle.arm.mbs.arm32.bare.option.target.fpu.unit");
        return checker;
    }

    private static boolean isCppProject(IManagedProject mProject) throws CoreException {
        IProject project;
        IResource owner;
        return mProject != null && (owner = mProject.getOwner()) != null && (project = owner.getProject()) != null && project.getNature("org.eclipse.cdt.core.ccnature") != null;
    }
}

