/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker;

import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.IToolChainFPChecker;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class ToolChainFPChecker
implements IToolChainFPChecker {
    private Map<String, String> options = new LinkedHashMap<String, String>();

    ToolChainFPChecker() {
    }

    @Override
    public IStatus checkToolChainFPOptionsSet(IConfiguration configuration) {
        IToolChain tc = configuration.getToolChain();
        return this.checkToolChainFPOptionsSet((IHoldsOptions)tc, configuration);
    }

    void addCheckOption(String optionName, String optionValue) {
        this.options.put(optionName, optionValue);
    }

    IStatus checkToolChainFPOptionsSet(IHoldsOptions ho, IConfiguration configuration) {
        for (Map.Entry<String, String> option : this.options.entrySet()) {
            IStatus result = this.checkOptionValue(ho.getOptionBySuperClassId(option.getKey()), option.getValue(), configuration);
            if (result.isOK()) continue;
            return result;
        }
        return Status.OK_STATUS;
    }

    IStatus checkOptionValue(IOption fpOption, String fpExpectedValueId, IConfiguration configuration) {
        if (fpOption != null && !fpOption.getValue().equals(fpExpectedValueId)) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(configuration.getName()).append(':').append(' ').append(fpOption.getName(fpExpectedValueId));
                return new Status(2, "com.freescale.s32ds.cross.sdk.support", sb.toString());
            }
            catch (BuildException be) {
                return new Status(4, "com.freescale.s32ds.cross.sdk.support", be.getMessage(), (Throwable)be);
            }
        }
        return Status.OK_STATUS;
    }
}

