/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.IExtendedPath;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.ExtendedPath;
import com.nxp.s32ds.cle.ide.sdk.core.resources.ProjectStructure;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkBinaryFileResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkHeaderFileResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkHeaderFolderResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkIncludeFileResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResource;
import com.nxp.s32ds.cle.ide.sdk.core.resources.SdkResourcesHolder;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbol;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolTypes;
import com.nxp.s32ds.cle.ide.sdk.core.symbols.SdkSymbolsHolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TCHolder {
    public static final String SYMBOLS_ATTRIBUTE_TAG = "symbols";
    public static final String COMMON_SYMBOLS_ATTRIBUTE_TAG = "commonSymbols";
    public static final String C_SYMBOLS_ATTRIBUTE_TAG = "cCompilerSymbols";
    public static final String CPP_SYMBOLS_ATTRIBUTE_TAG = "cppCompilerSymbols";
    public static final String ASM_SYMBOLS_ATTRIBUTE_TAG = "assemblerSymbols";
    public static final String SOURCE_PATH_ATTRIBUTE_TAG = "path";
    public static final String SOURCE_COPY_ATTRIBUTE_TAG = "copy";
    public static final String SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG = "copyToProjectPath";
    public static final String RENAME_TO_ATTRIBUTE_TAG = "renameTo";
    public static final String IS_PUBLIC_ATTRIBUTE_TAG = "isPublic";
    public static final String TO_OPEN_ATTRIBUTE_TAG = "toOpen";
    public static final String SOURCE_FOLDER_ELEMENT_TAG = "sourceFolder";
    public static final String SOURCE_FILE_ELEMENT_TAG = "sourceFile";
    public static final String LINKER_FILE_ELEMENT_TAG = "linkerFile";
    public static final String BINARY_FILE_ELEMENT_TAG = "binaryFile";
    public static final String OTHER_FOLDER_ELEMENT_TAG = "resourceFolder";
    public static final String OTHER_FILE_ELEMENT_TAG = "resourceFile";
    public static final String ID_ATTRIBUTE_TAG = "id";
    public static final String ALIAS_ATTRIBUTE_TAG = "alias";
    public static final String VALUE_ATTRIBUTE_TAG = "value";
    private final String toolchainId;
    private final String alias;
    public static final int T_SOURCE = 0;
    public static final int T_HEADER = 1;
    public static final int T_BINARY = 2;
    public static final int T_OTHERS = 3;
    public static final int T_LINKER = 4;
    public static final int T_INCLUDE_FILES = 5;
    public static final IExtendedPath[] EMPTY_PATHS = new IExtendedPath[0];
    public List<IExtendedPath> srcs = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> hdrs = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> bins = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> oths = new ArrayList<IExtendedPath>();
    public List<IExtendedPath> ldfs = new ArrayList<IExtendedPath>();
    private ProjectStructure projectStructure;
    private SdkResourcesHolder resourcesHolder;
    private SdkSymbolsHolder symbolsHolder;

    public TCHolder(String tc) {
        this(tc, null);
    }

    private TCHolder(String toolchainId, String alias) {
        this.toolchainId = toolchainId;
        this.alias = alias;
        this.projectStructure = new ProjectStructure(toolchainId);
        this.resourcesHolder = new SdkResourcesHolder(toolchainId);
        this.symbolsHolder = new SdkSymbolsHolder(toolchainId);
    }

    public TCHolder(Element e, String path, String env) {
        this(e.getAttribute(ID_ATTRIBUTE_TAG), e.getAttribute(ALIAS_ATTRIBUTE_TAG));
        NodeList nlt = e.getChildNodes();
        int nltLen = nlt.getLength();
        int k = 0;
        while (k < nltLen) {
            Node n = nlt.item(k);
            if (n.getNodeType() == 1) {
                Element el = (Element)n;
                this.process(el, path, env);
            }
            ++k;
        }
    }

    public TCHolder(IConfigurationElement ce, IPath sdkRootPath) {
        String id = ce.getAttribute(ID_ATTRIBUTE_TAG);
        String al = ce.getAttribute(ALIAS_ATTRIBUTE_TAG);
        if (al == null || id == null) {
            id = null;
            al = null;
        }
        this.toolchainId = id;
        this.alias = al;
        this.resourcesHolder = new SdkResourcesHolder(this.toolchainId);
        this.symbolsHolder = new SdkSymbolsHolder(this.toolchainId);
        this.projectStructure = ProjectStructure.parse(ce, this.toolchainId);
        this.srcs = TCHolder.getPaths(ce, sdkRootPath, SOURCE_FOLDER_ELEMENT_TAG, SOURCE_FILE_ELEMENT_TAG, SDKSupportPlugin.sourcesMatcher);
        this.getResourcesHolder().setResources(ce, sdkRootPath);
        this.oths = TCHolder.getPaths(ce, sdkRootPath, OTHER_FOLDER_ELEMENT_TAG, OTHER_FILE_ELEMENT_TAG, SDKSupportPlugin.othersMatcher);
        this.ldfs = TCHolder.getPaths(ce, sdkRootPath, "", LINKER_FILE_ELEMENT_TAG, SDKSupportPlugin.ldMatcher);
        this.addSymbols(ce);
    }

    public String getTCId() {
        return this.toolchainId;
    }

    public String getTCAlias() {
        return this.alias;
    }

    public void addBinaryFile(SdkResource binaryFile) {
        this.getResourcesHolder().addResource(binaryFile);
    }

    public void addHeaderPath(IExtendedPath headerPath) {
        this.getResourcesHolder().addResource(headerPath.isDirectory() ? new SdkHeaderFolderResource(headerPath) : new SdkHeaderFileResource(headerPath));
    }

    public void addHeaderPath(SdkResource headerResource) {
        this.getResourcesHolder().addResource(headerResource);
    }

    public void addHeaderPaths(List<IExtendedPath> headerPaths) {
        if (headerPaths != null) {
            headerPaths.stream().map(p -> p.isDirectory() ? new SdkHeaderFolderResource((IExtendedPath)p) : new SdkHeaderFileResource((IExtendedPath)p)).forEach(this.getResourcesHolder()::addResource);
        }
    }

    public List<IExtendedPath> getHeaderPaths() {
        return this.getHeaders().stream().map(SdkResource::getPath).collect(Collectors.toList());
    }

    public Set<SdkResource> getHeaders() {
        return this.getResourcesHolder().getHeaders();
    }

    public List<IExtendedPath> getSources() {
        return this.srcs;
    }

    public void addSourcePath(IExtendedPath path) {
        this.srcs.add(path);
    }

    public List<IExtendedPath> getLinkerFiles() {
        return this.ldfs;
    }

    public void addLinkerFilePath(IExtendedPath path) {
        this.ldfs.add(path);
    }

    public List<IExtendedPath> getBinaries() {
        return this.getResourcesHolder().getBinaryFiles().stream().map(SdkResource::getPath).collect(Collectors.toList());
    }

    public void addBinaryFilePath(IExtendedPath path) {
        this.getResourcesHolder().addResource(new SdkBinaryFileResource(path));
    }

    public List<IExtendedPath> getUntypedResources() {
        return this.oths;
    }

    public void addUntypedFilePath(IExtendedPath path) {
        this.oths.add(path);
    }

    public void addPaths(List<IExtendedPath> paths, int resourceType) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        switch (resourceType) {
            case 2: {
                paths.stream().map(SdkBinaryFileResource::new).forEach(this.getResourcesHolder()::addResource);
                break;
            }
            case 1: {
                paths.stream().map(p -> p.isDirectory() ? new SdkHeaderFolderResource((IExtendedPath)p) : new SdkHeaderFileResource((IExtendedPath)p)).forEach(this.getResourcesHolder()::addResource);
                break;
            }
            case 4: {
                this.ldfs.addAll(paths);
                break;
            }
            case 3: {
                this.oths.addAll(paths);
                break;
            }
            case 0: {
                this.srcs.addAll(paths);
            }
        }
    }

    public void setPaths(List<IExtendedPath> paths, int resourceType) {
        switch (resourceType) {
            case 2: {
                this.getResourcesHolder().setResources(paths.stream().map(SdkBinaryFileResource::new).collect(Collectors.toList()));
                break;
            }
            case 1: {
                this.getResourcesHolder().setResources(paths.stream().map(p -> p.isDirectory() ? new SdkHeaderFolderResource((IExtendedPath)p) : new SdkHeaderFileResource((IExtendedPath)p)).collect(Collectors.toList()));
                break;
            }
            case 4: {
                this.ldfs.clear();
                this.ldfs.addAll(paths);
                break;
            }
            case 3: {
                this.oths.clear();
                this.oths.addAll(paths);
                break;
            }
            case 0: {
                this.srcs.clear();
                this.srcs.addAll(paths);
            }
        }
    }

    @Deprecated
    public List<String> getDefSymbols() {
        if (this.symbolsHolder == null) {
            return Collections.emptyList();
        }
        return this.symbolsHolder.getSymbolsByType(SdkSymbolTypes.DEFINED).stream().filter(SdkSymbol::isCommon).map(SdkSymbol::getSymbolName).collect(Collectors.toList());
    }

    public void setDefinedSymbols(String definedSymbolsString) {
        this.symbolsHolder.addSymbols(definedSymbolsString);
    }

    public void setSymbolsHolder(SdkSymbolsHolder symbolsHolder) {
        this.symbolsHolder = symbolsHolder;
    }

    public void addDefinedSymbols(String definedSymbolsString, String tagType) {
        this.symbolsHolder.addSymbols(definedSymbolsString, this.getSymbolLang(tagType), SdkSymbolTypes.DEFINED);
    }

    public void addSymbol(String symbolName, String langId, SdkSymbolTypes type) {
        this.symbolsHolder.addSymbols(symbolName, langId, type);
    }

    public void addDefinedSymbols(List<String> definedSymbols, String type) {
        this.symbolsHolder.addSymbols(definedSymbols, this.getSymbolLang(type), SdkSymbolTypes.DEFINED);
    }

    public void addSymbols(List<String> symbolNames, String tagType, SdkSymbolTypes type) {
        this.symbolsHolder.addSymbols(symbolNames, this.getSymbolLang(tagType), type);
    }

    public SdkSymbolsHolder getSymbolsHolder() {
        return this.symbolsHolder != null ? this.symbolsHolder : new SdkSymbolsHolder(this.toolchainId);
    }

    public SdkResourcesHolder getResourcesHolder() {
        return this.resourcesHolder != null ? this.resourcesHolder : new SdkResourcesHolder(this.toolchainId);
    }

    public ProjectStructure getProjectStructure() {
        return this.projectStructure != null ? this.projectStructure : new ProjectStructure(this.toolchainId);
    }

    public void addIncludeFile(IExtendedPath includeFilePath) {
        this.getResourcesHolder().addResource(new SdkIncludeFileResource(includeFilePath));
    }

    public void addIncludeFile(SdkResource includeFile) {
        this.getResourcesHolder().addResource(includeFile);
    }

    public void setIncludeFiles(List<IExtendedPath> includeFiles) {
        this.getResourcesHolder().setIncludeFiles(includeFiles != null ? (Collection)includeFiles.stream().map(SdkIncludeFileResource::new).collect(Collectors.toSet()) : new ArrayList<SdkResource>());
    }

    public Set<SdkResource> getIncludeFiles() {
        return this.getResourcesHolder().getIncludeFiles();
    }

    public void process(Element element, String path, String env) {
        String elementName;
        if (env == null) {
            env = path;
        }
        switch (elementName = element.getNodeName()) {
            case "binaryFile": 
            case "includeFile": 
            case "headerFolder": 
            case "headerFile": {
                this.getResourcesHolder().addResource(element, env);
                break;
            }
            case "linkerFile": {
                TCHolder.extractPath(element, env, this.ldfs, null);
                break;
            }
            case "resourceFile": {
                TCHolder.extractPath(element, env, this.oths, null);
                break;
            }
            case "resourceFolder": {
                TCHolder.extractPath(element, env, this.oths, SDKSupportPlugin.othersMatcher);
                break;
            }
            case "sourceFile": {
                TCHolder.extractPath(element, env, this.srcs, null);
                break;
            }
            case "sourceFolder": {
                TCHolder.extractPath(element, env, this.srcs, SDKSupportPlugin.sourcesMatcher);
                break;
            }
            case "projectStructure": {
                this.projectStructure = ProjectStructure.parse(element, this.toolchainId);
                break;
            }
        }
    }

    private static void extractPath(Element e, String newPath, Collection<IExtendedPath> lst, PathMatcher matcher) {
        String path = e.getAttribute(SOURCE_PATH_ATTRIBUTE_TAG);
        boolean copy = Boolean.valueOf(e.getAttribute(SOURCE_COPY_ATTRIBUTE_TAG));
        String copyToProjectPath = e.getAttribute(SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG);
        Boolean toOpen = Boolean.valueOf(e.getAttribute(TO_OPEN_ATTRIBUTE_TAG));
        Boolean isPublic = Boolean.valueOf(e.getAttribute(IS_PUBLIC_ATTRIBUTE_TAG));
        String renameTo = e.getAttribute(RENAME_TO_ATTRIBUTE_TAG);
        String fullPath = path;
        if (newPath != null) {
            String string = fullPath = path.startsWith(newPath) ? path : String.format("%s/%s", newPath, path).replace('\\', '/');
        }
        if (matcher != null) {
            IPath sourcePath = new Path(newPath).append(Path.fromOSString((String)path));
            TCHolder.processFolder(lst, sourcePath, copy, copyToProjectPath, renameTo, isPublic, toOpen, matcher);
        } else {
            lst.add(ExtendedPath.fromOSString(fullPath, copy, copyToProjectPath, renameTo, isPublic, toOpen, false));
        }
    }

    public boolean isEmpty() {
        return this.srcs.isEmpty() && this.oths.isEmpty() && this.ldfs.isEmpty() && this.getResourcesHolder().isEmpty() && this.getSymbolsHolder().isEmpty() && this.getProjectStructure().isEmpty();
    }

    public void convertResourcesToXml(Document document, Element sdkElement, IPath sdkPath) {
        this.getSymbolsHolder().convertToXml(document, sdkElement);
        this.getProjectStructure().convertToXml(document, sdkElement);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.srcs, SOURCE_FILE_ELEMENT_TAG);
        this.getResourcesHolder().convertToXml(document, sdkElement, sdkPath);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.oths, OTHER_FILE_ELEMENT_TAG);
        TCHolder.appendChildren(document, sdkElement, sdkPath, this.ldfs, LINKER_FILE_ELEMENT_TAG);
    }

    public void convertToXml(Document document, Element sdkElement, IPath sdkPath) {
        Element tcElement = document.createElement("toolchain");
        tcElement.setAttribute(ID_ATTRIBUTE_TAG, this.toolchainId);
        tcElement.setAttribute(ALIAS_ATTRIBUTE_TAG, this.alias);
        this.convertResourcesToXml(document, tcElement, sdkPath);
        sdkElement.appendChild(tcElement);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tool Chain Holder ALIAS = ").append(this.alias);
        sb.append(" TOOLCHAIN = ").append(this.toolchainId);
        sb.append(" SOURCES = ").append(Arrays.toString(this.srcs.toArray()));
        sb.append(this.getResourcesHolder().toString());
        sb.append(" RESOURCES = ").append(Arrays.toString(this.oths.toArray()));
        sb.append(" LINKER LD FILES = ").append(Arrays.toString(this.ldfs.toArray()));
        sb.append(this.getSymbolsHolder().toString());
        sb.append(this.getProjectStructure().toString());
        sb.append(" END.");
        return sb.toString();
    }

    private static void appendChildren(Document document, Element sdkElement, IPath sdkPath, Collection<IExtendedPath> paths, String fileTag) {
        for (IExtendedPath s : paths) {
            String renameTo;
            Element se = document.createElement(fileTag);
            IPath path = s.makeRelativeTo(sdkPath);
            se.setAttribute(SOURCE_PATH_ATTRIBUTE_TAG, path.toOSString());
            se.setAttribute(SOURCE_COPY_ATTRIBUTE_TAG, Boolean.toString(s.isCopy()));
            String copyPath = s.copyPath();
            if (copyPath != null && !copyPath.isEmpty()) {
                se.setAttribute(SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG, copyPath);
            }
            if ((renameTo = s.renameTo()) != null && !renameTo.isEmpty()) {
                se.setAttribute(RENAME_TO_ATTRIBUTE_TAG, renameTo);
            }
            sdkElement.appendChild(se);
        }
    }

    public void clear() {
        this.srcs.clear();
        this.oths.clear();
        this.ldfs.clear();
        this.getResourcesHolder().clear();
        this.getSymbolsHolder().clear();
        this.getProjectStructure().clear();
    }

    private static List<IExtendedPath> getPaths(IConfigurationElement ce, IPath sdkRootPath, String folderElementTag, String fileElementTag, PathMatcher matcher) {
        IConfigurationElement[] folders = ce.getChildren(folderElementTag);
        IConfigurationElement[] files = ce.getChildren(fileElementTag);
        IConfigurationElement[] srcs = new IConfigurationElement[folders.length + files.length];
        int foldersLength = folders.length;
        System.arraycopy(folders, 0, srcs, 0, foldersLength);
        System.arraycopy(files, 0, srcs, foldersLength, files.length);
        files = null;
        folders = null;
        ArrayList<IExtendedPath> sdkPaths = new ArrayList<IExtendedPath>();
        int i = 0;
        while (i < srcs.length) {
            IConfigurationElement sce = srcs[i];
            String path = sce.getAttribute(SOURCE_PATH_ATTRIBUTE_TAG);
            if (path != null) {
                while (path.length() > 1 && (path.charAt(0) == '/' || path.charAt(0) == '\\')) {
                    path = path.substring(1);
                }
            }
            boolean copy = Boolean.valueOf(sce.getAttribute(SOURCE_COPY_ATTRIBUTE_TAG));
            Boolean toOpen = Boolean.valueOf(sce.getAttribute(TO_OPEN_ATTRIBUTE_TAG));
            Boolean isPublic = Boolean.valueOf(sce.getAttribute(IS_PUBLIC_ATTRIBUTE_TAG));
            String renameTo = sce.getAttribute(RENAME_TO_ATTRIBUTE_TAG);
            String copyToProjectPath = sce.getAttribute(SOURCE_COPY_TO_PROJECT_PATH_ATTRIBUTE_TAG);
            IPath sourcePath = sdkRootPath.append(Path.fromOSString((String)path));
            if (i >= foldersLength) {
                sdkPaths.add(ExtendedPath.fromOSString(sourcePath.toOSString(), copy, copyToProjectPath, renameTo, isPublic, toOpen, false));
            } else {
                TCHolder.processFolder(sdkPaths, sourcePath, copy, copyToProjectPath, renameTo, isPublic, toOpen, matcher);
            }
            ++i;
        }
        return sdkPaths;
    }

    public static void processFolder(final Collection<IExtendedPath> paths, IPath src, final boolean copy, final String copyDest, final String renameTo, final boolean isPublic, final boolean toOpen, final PathMatcher matcher) {
        paths.add(ExtendedPath.fromOSString(src.toOSString(), copy, copyDest, renameTo, isPublic, toOpen, true));
        File file = src.toFile();
        if (file.exists()) {
            String absolutePath = file.getAbsolutePath();
            try {
                Files.walkFileTree(Paths.get(absolutePath, new String[0]), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                        if (matcher.matches(file.getFileName())) {
                            paths.add(ExtendedPath.fromOSString(file.toString(), copy, copyDest, renameTo, isPublic, toOpen, false));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                SDKSupportPlugin.error(e);
            }
        }
    }

    public Set<SdkResource> getResourceByType(int type) {
        switch (type) {
            case 1: {
                return this.getResourcesHolder().getHeaders();
            }
            case 5: {
                return this.getResourcesHolder().getIncludeFiles();
            }
        }
        return Collections.emptySet();
    }

    public IExtendedPath[] get(int type) {
        switch (type) {
            case 0: {
                return this.srcs.toArray(new IExtendedPath[0]);
            }
            case 1: {
                return this.getResourcesHolder().getHeaders().stream().map(SdkResource::getPath).collect(Collectors.toList()).toArray(new IExtendedPath[0]);
            }
            case 2: {
                return this.getResourcesHolder().getBinaryFiles().stream().map(SdkResource::getPath).collect(Collectors.toList()).toArray(new IExtendedPath[0]);
            }
            case 3: {
                return this.oths.toArray(new IExtendedPath[0]);
            }
            case 4: {
                return this.ldfs.toArray(new IExtendedPath[0]);
            }
            case 5: {
                return this.getResourcesHolder().getIncludeFiles().stream().map(SdkResource::getPath).collect(Collectors.toList()).toArray(new IExtendedPath[0]);
            }
        }
        return EMPTY_PATHS;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.toolchainId == null ? 0 : this.toolchainId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TCHolder other = (TCHolder)obj;
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        return !(this.toolchainId == null ? other.toolchainId != null : !this.toolchainId.equals(other.toolchainId));
    }

    private void addSymbols(IConfigurationElement holderElement) {
        this.addDefinedSymbols(holderElement.getAttribute(SYMBOLS_ATTRIBUTE_TAG), COMMON_SYMBOLS_ATTRIBUTE_TAG);
        this.addDefinedSymbols(holderElement, COMMON_SYMBOLS_ATTRIBUTE_TAG);
        this.addDefinedSymbols(holderElement, C_SYMBOLS_ATTRIBUTE_TAG);
        this.addDefinedSymbols(holderElement, CPP_SYMBOLS_ATTRIBUTE_TAG);
        this.addDefinedSymbols(holderElement, ASM_SYMBOLS_ATTRIBUTE_TAG);
        Arrays.stream(holderElement.getChildren(SYMBOLS_ATTRIBUTE_TAG)).filter(symbolsElement -> symbolsElement.getParent().equals(holderElement)).flatMap(symbolsElement -> Arrays.stream(symbolsElement.getChildren("symbol"))).forEach(this::addSymbol);
    }

    private void addDefinedSymbols(IConfigurationElement ce, String type) {
        IConfigurationElement[] elements = ce.getChildren(type);
        int i = 0;
        while (i < elements.length) {
            String symbolName = elements[i].getAttribute(VALUE_ATTRIBUTE_TAG);
            SdkSymbol symbol = new SdkSymbol(symbolName, this.getSymbolLang(type), this.symbolsHolder);
            this.symbolsHolder.addSymbol(symbol, SdkSymbolTypes.DEFINED);
            ++i;
        }
    }

    private void addSymbol(IConfigurationElement symbolElement) {
        String symbolName = symbolElement.getAttribute("name");
        String langId = symbolElement.getAttribute("langId");
        SdkSymbolTypes type = SdkSymbolTypes.byName(symbolElement.getAttribute("type"));
        this.addSymbol(symbolName, langId, type);
    }

    private String getSymbolLang(String tag) {
        switch (tag) {
            case "commonSymbols": {
                return "";
            }
            case "cCompilerSymbols": {
                return "c";
            }
            case "cppCompilerSymbols": {
                return "cpp";
            }
            case "assemblerSymbols": {
                return "asm";
            }
        }
        return "";
    }
}

