/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.IExternalSDK;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.ISDKSmartFilter;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import com.freescale.s32ds.cross.sdk.internal.ConflictedSDKsHandler;
import com.freescale.s32ds.cross.sdk.internal.ContributedSDK;
import com.freescale.s32ds.cross.sdk.internal.Environment;
import com.freescale.s32ds.cross.sdk.internal.ExternalSDK;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.ImportSDK;
import com.freescale.s32ds.cross.sdk.internal.ProjectLocalSDK;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import com.freescale.s32ds.cross.sdk.internal.SDKFilteringUtils;
import com.freescale.s32ds.cross.sdk.internal.SDKObserver;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentListenerManager;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventBuilder;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangePayload;
import com.nxp.s32ds.cle.ide.sdk.core.SDKResourcesHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public final class SDKUtils {
    private static final List<SDKObserver> OBSERVERS = new ArrayList<SDKObserver>();
    public static final String ERROR_COULD_NOT_REACH = "Couldn't reach here";
    public static final String EMPTY = "";
    private static final int HW_GROUP_ELEMENTS_COUNT = 3;
    private static final String SPLITTER = ":";
    public static final ISDKFilter NO_FILTER = new ISDKFilter(){

        @Override
        public boolean accept(ISDK sdk) {
            return true;
        }
    };
    private static final List<ISDK> sdks = new ArrayList<ISDK>();

    public static void addListener(SDKObserver sdkObserver) {
        OBSERVERS.add(sdkObserver);
    }

    public static void removeListener(SDKObserver sdkObserver) {
        OBSERVERS.remove(sdkObserver);
    }

    public static void notifySDKObserver() {
        OBSERVERS.stream().forEach(observe -> observe.change());
    }

    public static void notifySDKAttached(ISDK sdk, IProject project) {
        HashMap<String, Object> payLoadContent = new HashMap<String, Object>();
        payLoadContent.put("s32ds.project", project);
        payLoadContent.put("s32ds.project.sdk", sdk);
        ComponentChangeEventBuilder builder = ComponentChangeEventBuilder.builder();
        builder.archetypeId("com.nxp.s32ds.cle.ide.component.project");
        builder.componentId("s32ds.project");
        builder.actionId("s32ds.project.action.sdk.attach");
        ComponentChangePayload payLoadComponent = new ComponentChangePayload(payLoadContent);
        builder.payload((Object)payLoadComponent);
        ComponentChangeEvent sdkAttachedEvent = builder.build();
        if (sdkAttachedEvent != null) {
            ComponentListenerManager.INSTANCE.notifyComponentChange(sdkAttachedEvent);
        }
    }

    public static void notifySDKDetached(ISDK sdk, IProject project) {
        HashMap<String, Object> payLoadContent = new HashMap<String, Object>();
        payLoadContent.put("s32ds.project", project);
        payLoadContent.put("s32ds.project.sdk", sdk);
        ComponentChangeEventBuilder builder = ComponentChangeEventBuilder.builder();
        builder.archetypeId("com.nxp.s32ds.cle.ide.component.project");
        builder.componentId("s32ds.project");
        builder.actionId("s32ds.project.action.sdk.detach");
        ComponentChangePayload payLoadComponent = new ComponentChangePayload(payLoadContent);
        builder.payload((Object)payLoadComponent);
        ComponentChangeEvent sdkDetachedEvent = builder.build();
        if (sdkDetachedEvent != null) {
            ComponentListenerManager.INSTANCE.notifyComponentChange(sdkDetachedEvent);
        }
    }

    private SDKUtils() {
    }

    public static void init() {
        ContributedSDK.loadContributedSDKs();
        ExternalSDK.loadExternalPersistedSDKs();
        ProjectLocalSDK.loadProjectLocalPersistedSDKs();
        ImportSDK.loadImportSDKs();
        for (IProject project : SDKUtils.listProjects()) {
            SDKAttach.getAttachedVerbose(project);
        }
        Environment.cleanVars(sdks);
    }

    public static ISDK convert(ISDK sdk, ISDK.TYPE destinationType, Object ... args) {
        Objects.requireNonNull(sdk);
        if (destinationType == sdk.getType()) {
            return sdk;
        }
        AbstractSDK result = null;
        switch (destinationType) {
            case EXTERNAL: {
                result = new ExternalSDK(sdk.getHeader(), sdk.getRoot(), sdk.getFilterOptions());
                break;
            }
            case PROJECT: {
                if (!(args[0] instanceof IProject)) break;
                result = new ProjectLocalSDK((IProject)args[0], sdk.getHeader(), sdk.getRoot(), sdk.getFilterOptions());
                break;
            }
            case CONTRIBUTED: {
                result = new ContributedSDK(sdk.getHeader(), sdk.getRoot(), sdk.getFilterOptions(), sdk.getToolchains());
                break;
            }
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format(Messages.SDKUtils_cannot_convert_sdk, new Object[]{sdk, destinationType}));
        }
        SDKUtils.replace(sdk, result);
        return result;
    }

    public static List<ISDK> filter(ISDKFilter filter) {
        ArrayList<ISDK> filtered = new ArrayList<ISDK>();
        for (ISDK sdk : sdks) {
            if (filter instanceof ISDKSmartFilter && !((ISDKSmartFilter)filter).acceptOptions(sdk) || !filter.accept(sdk)) continue;
            filtered.add(sdk);
        }
        return filtered;
    }

    public static boolean exists(String id) {
        for (ISDK sdk : sdks) {
            if (!sdk.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean exists(String name, String version) {
        return sdks.stream().anyMatch(sdk -> sdk.getName().equalsIgnoreCase(name) && sdk.getVersion().equalsIgnoreCase(version));
    }

    public static void add(ISDK sdk, boolean isRewrite) {
        SDKUtils.add(sdk, isRewrite, true);
    }

    public static IStatus addVerbose(ISDK sdk, boolean isRewrite, boolean isCleanupEnv) {
        if (SDKUtils.exists(sdk.getId())) {
            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)Messages.ConflictedSDKsHandler_sdk_id_conflict, (Object)sdk.getId()));
        }
        SDKUtils.add(sdk, isRewrite, isCleanupEnv);
        return Status.OK_STATUS;
    }

    public static void add(ISDK sdk, boolean isRewrite, boolean isCleanupEnv) {
        sdks.add(sdk);
        if (!isRewrite) {
            return;
        }
        for (IProject p : SDKAttach.getAttached(sdk)) {
            SDKUtils.removeSources(p, sdk);
            for (IConfiguration cfg : SDKAttach.getAttached(p, sdk)) {
                SDKAttach.removeOptions(sdk, cfg);
                SDKAttach.removeResources(sdk, cfg);
                SDKAttach.addOptions(sdk, cfg);
                if (!SDKAttach.addResources(sdk, cfg)) continue;
                SDKUtils.addSources(p, sdk);
            }
        }
        SDKUtils.notifySDKObserver();
        if (isCleanupEnv) {
            Environment.cleanVars(sdks);
        }
    }

    public static List<ISDK> add(List<ISDK> sdkList, boolean isRewrite) {
        if (sdkList != null) {
            Iterator<ISDK> it = sdkList.iterator();
            while (it.hasNext()) {
                ISDK sdk = it.next();
                if (SDKUtils.exists(sdk.getId())) continue;
                SDKUtils.add(sdk, isRewrite, false);
                it.remove();
            }
        }
        return sdkList;
    }

    public static void cleanUnusedSdkEnvironmentVariables() {
        Environment.cleanVars(sdks);
    }

    public static void remove(ISDK sdk) {
        SDKUtils.remove(sdk, false);
        SDKUtils.notifySDKObserver();
        Environment.cleanVars(sdks);
    }

    public static void remove(ISDK sdk, boolean convert) {
        if (sdk instanceof IExternalSDK || sdk instanceof ImportSDK || ISDK.TYPE.CONTRIBUTED_EXTERNAL == sdk.getType() || ISDK.TYPE.INTERNAL == sdk.getType()) {
            for (IProject project : SDKUtils.listProjects()) {
                SDKAttach.detachFrom(sdk, SDKAttach.getAttached(project, sdk));
            }
            if (!convert) {
                SDKUtils.removeSDKEnv(sdk);
            }
            sdks.remove(sdk);
            sdk.getModules().getRefModulesSdks().stream().filter(refSdk -> ISDK.TYPE.INTERNAL == refSdk.getType()).forEach(SDKUtils::remove);
            SDKUtils.notifySDKObserver();
        }
    }

    public static void remove(ISDKFilter filter) {
        ArrayList<ISDK> filtered = new ArrayList<ISDK>();
        for (ISDK sdk : sdks) {
            if (!filter.accept(sdk)) continue;
            filtered.add(sdk);
        }
        for (ISDK sdk : filtered) {
            SDKUtils.remove(sdk);
        }
    }

    public static void remove(ISDK sdk, IProject project, boolean isDetach) {
        if (isDetach) {
            SDKAttach.detachFrom(sdk, SDKAttach.getAttached(project, sdk));
        }
        SDKUtils.removeSDKEnv(sdk);
        sdks.remove(sdk);
        SDKUtils.notifySDKObserver();
    }

    public static boolean openResources(ISDK sdk, IProject project) {
        IConfiguration defaultConfiguration;
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo != null && (defaultConfiguration = buildInfo.getDefaultConfiguration()) != null) {
            String toolChainId = defaultConfiguration.getToolChain().getBaseId();
            return SDKResourcesHandler.INSTANCE.openTargetResources(sdk, project, toolChainId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(ISDK oldSDK, ISDK newSDK) {
        if (oldSDK == null || newSDK == null || !oldSDK.getId().equals(newSDK.getId())) {
            throw new IllegalArgumentException(String.format(Messages.SDKUtils_cannot_replace, oldSDK, newSDK));
        }
        List<ISDK> list = sdks;
        synchronized (list) {
            sdks.remove(oldSDK);
            sdks.add(newSDK);
        }
    }

    public static String export(ISDK sdk) {
        return AbstractSDK.getSDKsString(Arrays.asList(sdk));
    }

    public static void addSources(IProject project, ISDK sdk) {
        SDKUtils.addSources(project, sdk, null);
    }

    public static void addSources(IProject project, ISDK sdk, IConfiguration conf) {
        try {
            SDKUtils.addSourcePathEntries(SDKUtils.getProjectSdkTargetFolder(sdk, project), project, conf);
            SDKUtils.getProjectSourceFolders(sdk, project, conf).forEach(f -> SDKUtils.addSourcePathEntries(f, project, conf));
        }
        catch (Exception e) {
            SDKSupportPlugin.log(e.getMessage());
        }
    }

    public static void removeSources(IProject project, ISDK sdk) {
        SDKUtils.removeSources(project, sdk, null);
    }

    public static void removeSources(IProject project, ISDK sdk, IConfiguration conf) {
        try {
            SDKUtils.removeSourcePathEntries(SDKUtils.getProjectSdkTargetFolder(sdk, project), project, conf);
            SDKUtils.getProjectSourceFolders(sdk, project, conf).forEach(f -> SDKUtils.removeSourcePathEntries(f, project, conf));
        }
        catch (Exception e) {
            SDKSupportPlugin.log(e.getMessage());
        }
    }

    private static IFolder getProjectSdkTargetFolder(ISDK sdk, IProject project) {
        return project.getFolder(sdk.getTargetFolderName());
    }

    private static Set<IFolder> getProjectSourceFolders(ISDK sdk, IProject project, IConfiguration conf) {
        return sdk.getProjectSourceFolders(conf.getToolChain().getBaseId()).stream().map(psf -> project.getFolder(Path.fromOSString((String)psf.getPath()).segment(0))).collect(Collectors.toSet());
    }

    private static void addSourcePathEntries(IFolder sourceFolder, IProject project, IConfiguration conf) {
        try {
            SDKUtils.updateSourceEntries(project, sourceFolder, conf, new ISourceEntriesUpdateCallback(){

                @Override
                public ICSourceEntry[] update(ICSourceEntry[] sources, IFolder base) {
                    String basePath = base.getFullPath().toString();
                    if (Arrays.stream(sources).noneMatch(se -> se.getName().equals(basePath))) {
                        ICSourceEntry[] newSources = new ICSourceEntry[sources.length + 1];
                        System.arraycopy(sources, 0, newSources, 0, sources.length);
                        newSources[sources.length] = new CSourceEntry(base, null, 0);
                        return newSources;
                    }
                    return sources;
                }
            });
        }
        catch (Exception e) {
            SDKSupportPlugin.log(e.getMessage());
        }
    }

    private static void removeSourcePathEntries(IFolder sourceFolder, IProject project, IConfiguration conf) {
        try {
            SDKUtils.updateSourceEntries(project, sourceFolder, conf, new ISourceEntriesUpdateCallback(){

                @Override
                public ICSourceEntry[] update(ICSourceEntry[] sources, IFolder base) {
                    ArrayList<ICSourceEntry> newSources = new ArrayList<ICSourceEntry>();
                    String basePath = base.getFullPath().toString();
                    ICSourceEntry[] iCSourceEntryArray = sources;
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICSourceEntry se = iCSourceEntryArray[n2];
                        if (!(se.getName().equals(basePath) || se.getName().equals(base.getFullPath().toString()) && base.isVirtual())) {
                            newSources.add(se);
                        }
                        ++n2;
                    }
                    return newSources.toArray(new ICSourceEntry[newSources.size()]);
                }
            });
        }
        catch (Exception e) {
            SDKSupportPlugin.log(e.getMessage());
        }
    }

    private static void updateSourceEntries(IProject project, IFolder parent, IConfiguration conf, ISourceEntriesUpdateCallback cb) throws CoreException {
        ICConfigurationDescription[] configurations;
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configurations = projectDescription.getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry[] sources;
            ICSourceEntry[] newSources;
            boolean isUpdateSources;
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            boolean bl = conf == null ? true : (isUpdateSources = cfg.getName().equals(conf.getName()));
            if (isUpdateSources && (newSources = cb.update(sources = cfg.getSourceEntries(), parent)) != sources) {
                cfg.setSourceEntries(newSources);
            }
            ++n2;
        }
        CoreModel.getDefault().setProjectDescription(project, projectDescription);
    }

    public static String toString(InputStream stream) throws IOException {
        return ((StringBuilder)new AtomicReference<StringBuilder>(new StringBuilder(), stream){
            {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    ((StringBuilder)this.get()).append(line);
                }
            }
        }.get()).toString();
    }

    public static void rmdir(File f) {
        if (f == null) {
            return;
        }
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File ff = fileArray[n2];
            if (ff.isDirectory()) {
                SDKUtils.rmdir(ff);
            }
            ff.delete();
            ++n2;
        }
    }

    public static String unifyProcessor(String id) {
        return id.toUpperCase().replace("SKEAZ", "KEAZ");
    }

    public static String unifyCoreKind(String id) {
        id = id.replace("+", "plus");
        return SDKFilteringUtils.getCoreKind(id);
    }

    public static boolean getBoolean(String s, boolean def) {
        if (s == null || s.trim().isEmpty()) {
            return def;
        }
        return "true".equalsIgnoreCase(s.trim()) || "yes".equalsIgnoreCase(s.trim());
    }

    public static ISDK getSDKbyID(String id) {
        for (ISDK sdk : sdks) {
            if (!sdk.getId().equals(id)) continue;
            return sdk;
        }
        return null;
    }

    public static List<IProject> listProjects() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                if (SDKUtils.isProjectValid(p)) {
                    result.add(p);
                }
            }
            catch (CoreException e) {
                SDKSupportPlugin.error(e);
            }
            ++n2;
        }
        return result;
    }

    public static boolean isProjectValid(IProject project) throws CoreException {
        return project.isAccessible() && !"RemoteSystemsTempFiles".equals(project.getName()) && (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature")) && project.hasNature(ManagedCProjectNature.MNG_NATURE_ID);
    }

    public static void removeSDKEnv(IEnvironment env) {
        if (env != null && !env.isSystem()) {
            env.removeValue();
        }
    }

    public static boolean restoreSDKFolder(IFolder sdkFolder, List<IConfiguration> cfgs) throws CoreException {
        if (sdkFolder.exists()) {
            return false;
        }
        final IFolder[] matchedFolder = new IFolder[1];
        IPath sdkFullPath = sdkFolder.getFullPath();
        final String sdkFolderPath = sdkFullPath.toOSString();
        sdkFolder.getProject().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IFolder f;
                String fldFullPath;
                if (resource instanceof IFolder && matchedFolder[0] == null && (fldFullPath = (f = (IFolder)resource).getFullPath().toOSString()).equalsIgnoreCase(sdkFolderPath) && !fldFullPath.equals(sdkFolderPath)) {
                    matchedFolder[0] = f;
                    return false;
                }
                return true;
            }
        });
        IFolder mFolder = matchedFolder[0];
        if (mFolder != null) {
            String mFolderName = mFolder.getFullPath().lastSegment();
            for (IConfiguration cfg : cfgs) {
                ArrayList<ICSourceEntry> updatedSources = new ArrayList<ICSourceEntry>();
                ICSourceEntry[] iCSourceEntryArray = cfg.getSourceEntries();
                int n = iCSourceEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICSourceEntry se = iCSourceEntryArray[n2];
                    if (!se.getFullPath().toString().equals(mFolderName)) {
                        updatedSources.add(se);
                    }
                    ++n2;
                }
                cfg.setSourceEntries(updatedSources.toArray(new ICSourceEntry[updatedSources.size()]));
            }
            mFolder.move(sdkFullPath, 1, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        return false;
    }

    public static IMarker createErrorMarker(String type, IResource resource, String message) throws CoreException {
        return SDKUtils.createMarker(type, 2, resource, message);
    }

    public static IMarker createMarker(String type, int severity, IResource resource, String message) throws CoreException {
        IMarker marker = resource.createMarker(type);
        marker.setAttribute("severity", severity);
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("location", (Object)resource.getLocation().toString());
        return marker;
    }

    private static void removeSDKEnv(ISDK sdk) {
        SDKUtils.removeSDKEnv(sdk.getEnv());
    }

    public static int calculateFilesCount(java.nio.file.Path startPath, final int limit) {
        final int[] counter = new int[1];
        try {
            Files.walkFileTree(startPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes ba) throws IOException {
                    return this.getCountCheckResult();
                }

                @Override
                public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                    return this.getCountCheckResult();
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path path, IOException exc) throws IOException {
                    return FileVisitResult.SKIP_SUBTREE;
                }

                private FileVisitResult getCountCheckResult() {
                    counter[0] = counter[0] + 1;
                    return counter[0] > limit ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {}
        if (counter[0] > 0 && counter[0] <= limit) {
            counter[0] = counter[0] - 1;
        }
        return counter[0];
    }

    public static IStatus deleteFolder(File folder) {
        final MultiStatus result = new MultiStatus("com.freescale.s32ds.cross.sdk.support", 0, EMPTY, null);
        if (!folder.isDirectory()) {
            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Unable to delete {0}: not a folder", (Object)folder));
        }
        java.nio.file.Path folderPath = folder.toPath();
        try {
            Files.walkFileTree(folderPath, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path path, BasicFileAttributes ba) throws IOException {
                    path.toFile().delete();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                    dir.toFile().delete();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path path, IOException exc) throws IOException {
                    result.add((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Unable to delete {0}: error occured", (Object)path), (Throwable)exc));
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
        }
        catch (IOException ioe) {
            return new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Unable to delete {0}: error occured", (Object)folder), (Throwable)ioe);
        }
        return result.getChildren().length == 0 ? Status.OK_STATUS : result;
    }

    public static void refreshProjectResources(IProject project) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        try {
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            SDKSupportPlugin.log((IStatus)new Status(2, "com.freescale.s32ds.cross.sdk.support", "Internal error while project refresh", (Throwable)e));
        }
    }

    public static void handleConflictedSdks() {
        ConflictedSDKsHandler.INSTANCE.handleConflictedSDKs();
    }

    public static void handleConflictedSdks(IProject project) {
        ConflictedSDKsHandler.INSTANCE.handleConflictedSDKs(project);
    }

    public static void cleanupProjectRelatedData(IProject project) {
        SDKAttach.cleanProjectAttachData(project);
        ConflictedSDKsHandler.INSTANCE.cleanupConflictedSdks(project);
    }

    public static List<IConfiguration> getProjectConfigurations(IProject project) {
        if (project == null) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", "Project is null."));
            return null;
        }
        if (!project.isAccessible()) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Project {0} is inaccessible.", (Object)project.getName())));
            return null;
        }
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Cannot retrive Managed Build Info for project {0}.", (Object)project.getName())));
            return null;
        }
        IManagedProject managedProject = buildInfo.getManagedProject();
        if (managedProject == null) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Cannot retrive Managed Project for project {0}.", (Object)project.getName())));
            return null;
        }
        IConfiguration[] configurations = managedProject.getConfigurations();
        if (configurations == null) {
            SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", NLS.bind((String)"Cannot retrive configurations for project {0}.", (Object)project.getName())));
            return null;
        }
        return Stream.of(configurations).collect(Collectors.toList());
    }

    public static List<String> getCoresbyOption(String[] coreOptions) {
        ArrayList<String> cores = new ArrayList<String>();
        String[] stringArray = coreOptions;
        int n = coreOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String[] hardwareGroups;
            String coreOption = stringArray[n2];
            String[] stringArray2 = hardwareGroups = coreOption.split(",");
            int n3 = hardwareGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                String hardwareGroup = stringArray2[n4];
                String[] hardwareOptions = hardwareGroup.split(SPLITTER);
                int i = 2;
                while (i < hardwareOptions.length) {
                    String coreId = hardwareOptions[i].trim();
                    if (!coreId.isEmpty()) {
                        cores.add(coreId);
                    }
                    i += 3;
                }
                ++n4;
            }
            ++n2;
        }
        return cores;
    }

    public static List<String> getDeviceCoresbyOption(String[] coreOptions) {
        ArrayList<String> deviceCores = new ArrayList<String>();
        String[] stringArray = coreOptions;
        int n = coreOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String[] hardwareGroups;
            String coreOption = stringArray[n2];
            String[] stringArray2 = hardwareGroups = coreOption.split(",");
            int n3 = hardwareGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                String hardwareGroup = stringArray2[n4];
                String[] hardwareOptions = hardwareGroup.split(SPLITTER);
                int i = 1;
                while (i < hardwareOptions.length) {
                    String deviceCoreId = hardwareOptions[i].trim();
                    if (!deviceCoreId.isEmpty()) {
                        deviceCores.add(deviceCoreId);
                    }
                    i += 3;
                }
                ++n4;
            }
            ++n2;
        }
        return deviceCores;
    }

    public static List<String> getDevicesbyOption(String[] coreOptions) {
        ArrayList<String> device = new ArrayList<String>();
        String[] stringArray = coreOptions;
        int n = coreOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String[] hardwareGroups;
            String coreOption = stringArray[n2];
            String[] stringArray2 = hardwareGroups = coreOption.split(",");
            int n3 = hardwareGroups.length;
            int n4 = 0;
            while (n4 < n3) {
                String hardwareGroup = stringArray2[n4];
                String[] hardwareOptions = hardwareGroup.split(SPLITTER);
                int i = 0;
                while (i < hardwareOptions.length) {
                    String deviceId = hardwareOptions[i].trim();
                    if (!deviceId.isEmpty()) {
                        device.add(deviceId);
                    }
                    i += 3;
                }
                ++n4;
            }
            ++n2;
        }
        return device;
    }

    public static Map<String, List<ISDK>> groupSdksByTag(List<ISDK> sdks) {
        HashMap<String, List<ISDK>> sdksGroupByTags = new HashMap<String, List<ISDK>>();
        for (ISDK sdk : sdks) {
            sdk.getTags().stream().forEach(sdkTag -> {
                boolean bl = sdksGroupByTags.computeIfAbsent((String)sdkTag, s -> new ArrayList()).add(sdk);
            });
        }
        return sdksGroupByTags;
    }

    public static Map<String, List<ISDK>> groupSdksByTargetProjectTemplateId(List<ISDK> sdks) {
        HashMap<String, List<ISDK>> sdksGroupByTargetProjectTemplateId = new HashMap<String, List<ISDK>>();
        sdks.stream().forEach(sdk -> {
            boolean bl = sdksGroupByTargetProjectTemplateId.computeIfAbsent(sdk.getTargetProjectTemplate(), s -> new ArrayList()).add(sdk);
        });
        return sdksGroupByTargetProjectTemplateId;
    }

    public static Map<String, List<ISDK>> groupSdksByPlatformId(List<ISDK> sdks) {
        HashMap<String, List<ISDK>> sdksGroupByPlatformId = new HashMap<String, List<ISDK>>();
        sdks.stream().forEach(sdk -> {
            boolean bl = sdksGroupByPlatformId.computeIfAbsent(sdk.getPlatform(), s -> new ArrayList()).add(sdk);
        });
        return sdksGroupByPlatformId;
    }

    static interface ISourceEntriesUpdateCallback {
        public ICSourceEntry[] update(ICSourceEntry[] var1, IFolder var2);
    }
}

