/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ProjectChangeListener;
import com.freescale.s32ds.cross.sdk.SDKAttachListener;
import com.freescale.s32ds.cross.sdk.internal.Environment;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SDKSupportPlugin
extends AbstractUIPlugin {
    public static final String START_VAR = "${";
    public static final String SRC_XML = "sources.xml";
    public static final int INTERNAL_ERROR = 1200;
    public static final String PLUGIN_ID = "com.freescale.s32ds.cross.sdk.support";
    private static final String HEADER_FILES_REGEX = "regex:([ \\S]+(\\.(h|hpp|hxx|hh))$)";
    public static final PathMatcher headersMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(h|hpp|hxx|hh))$)");
    private static final String BINARY_FILES_REGEX = "regex:([ \\S]+(\\.(a|so|la))$)";
    public static final PathMatcher binariesMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(a|so|la))$)");
    private static final String SOURCE_FILES_REGEX = "regex:([ \\S]+(\\.(c|cpp|cc|C|cxx))$)";
    public static final PathMatcher sourcesMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(c|cpp|cc|C|cxx))$)");
    private static final String LINKER_FILES_REGEX = "regex:([ \\S]+(\\.(ld|lcf))$)";
    public static final PathMatcher ldMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(\\.(ld|lcf))$)");
    private static final String OTHERS_FILES_REGEX = "regex:([ \\S]+(?<!(\\.c$|\\.cpp$|\\.cc$|\\.C$|\\.cxx$|\\.h$|\\.hpp$|\\.hxx$|\\.hh$|\\.a$|\\.so$|\\.la$|\\.ld$|\\.lcf$|\\\\$)))";
    public static final PathMatcher othersMatcher = FileSystems.getDefault().getPathMatcher("regex:([ \\S]+(?<!(\\.c$|\\.cpp$|\\.cc$|\\.C$|\\.cxx$|\\.h$|\\.hpp$|\\.hxx$|\\.hh$|\\.a$|\\.so$|\\.la$|\\.ld$|\\.lcf$|\\\\$)))");
    public static final String BLANK_ICON = "BLANK_ICON";
    public static final String CHIP_ICON = "CHIP_ICON";
    public static final String DUPL_ICON = "DUPL_ICON";
    public static final String FILE_ICON = "FILE_ICON";
    public static final String FONT_ICON = "FONT_ICON";
    public static final String TOOL_ICON = "TOOL_ICON";
    public static final String NONE_ICON = "NONE_ICON";
    public static final String PLUS_ICON = "PLUS_ICON";
    public static final String CROSS_ICON = "CROSS_ICON";
    public static final String ERROR_ICON = "ERROR_ICON";
    public static final String ERROR_PLATFORM_ICON = "ERROR_PLATFORM_ICON";
    private static final String BLANK_ICON_PATH = "icons/blank.png";
    private static final String CHIP_ICON_PATH = "icons/err_chip.png";
    private static final String DUPL_ICON_PATH = "icons/err_dupl.png";
    private static final String FILE_ICON_PATH = "icons/err_file.png";
    private static final String FONT_ICON_PATH = "icons/err_font.png";
    private static final String TOOL_ICON_PATH = "icons/err_tool.png";
    private static final String NONE_ICON_PATH = "icons/err_none.png";
    private static final String ERROR_PLATFORM_ICON_PATH = "icons/err_platform.png";
    private static SDKSupportPlugin plugin;
    private ProjectChangeListener projectChangeListener;
    private SDKAttachListener sdkAttachListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.addListeners();
    }

    public void stop(BundleContext context) throws Exception {
        this.removeListeners();
        plugin = null;
        super.stop(context);
    }

    public static ICProject findCProject(IProject project) {
        return CoreModel.getDefault().create(project);
    }

    public static IEnvironment createEnvironment(String name, String ver, boolean isSystem, boolean readOnly, String initialPath, String desc) {
        String newname = name.toUpperCase() + "_" + ver + "_PATH";
        return SDKSupportPlugin.createEnvironment(newname, isSystem, readOnly, initialPath, desc);
    }

    public static IEnvironment createEnvironment(String name, boolean isSystem, boolean readOnly, String initialPath, String desc) {
        Environment env = new Environment(name, isSystem);
        if (!env.isSystem() && initialPath != null) {
            env.setValue(initialPath, desc, readOnly);
        }
        return env;
    }

    public static IEnvironment getEnvironment(String name, String ver) {
        String newname = name.toUpperCase().trim() + '_' + ver.trim() + "_PATH";
        return SDKSupportPlugin.getEnvironment(newname);
    }

    public static IEnvironment getEnvironment(String name) {
        return new Environment(name, false);
    }

    public static IPath getEclipsePath(ISDK sdk) {
        String path = sdk.getEnv().getValue();
        if (path == null) {
            return null;
        }
        String name = sdk.getEnv().getName();
        path = SDKSupportPlugin.performStringSubstitution(path, name);
        return Path.fromOSString((String)path);
    }

    public static String generateVariableExpression(String varName) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, null);
    }

    public static boolean isVariableExists(String name) {
        return SDKSupportPlugin.getVariable(name) != null;
    }

    public static IValueVariable getVariable(String name) {
        return VariablesPlugin.getDefault().getStringVariableManager().getValueVariable(name);
    }

    public static String performStringSubstitution(String path, String name) {
        try {
            path = SDKSupportPlugin.substituteSystemVars(path, name, false);
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
        }
        catch (CoreException e) {
            SDKSupportPlugin.log(e.getStatus());
            return "";
        }
    }

    public static String substituteSystemVars(String s) throws CoreException {
        return SDKSupportPlugin.substituteSystemVars(s, null, true);
    }

    public static String substituteSystemVars(String s, String variableName) throws CoreException {
        return SDKSupportPlugin.substituteSystemVars(s, variableName, true);
    }

    private static String substituteSystemVars(String s, String variableName, boolean doThrow) throws CoreException {
        int n = s.indexOf(START_VAR);
        while (n >= 0) {
            int m = s.indexOf(125, n);
            if (m <= 0) {
                SDKSupportPlugin.error("Not correct variable in string: " + s, null);
                break;
            }
            String key = s.substring(n + START_VAR.length(), m);
            if (variableName != null && key.equals(variableName)) {
                String msg = NLS.bind((String)"Recursive declaration for variable {0}", (Object)variableName);
                throw new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
            }
            String txt = START_VAR + key + '}';
            String val = System.getenv().get(key);
            if (val == null) {
                IStringVariable[] iStringVariableArray = StringVariableManager.getDefault().getVariables();
                int n2 = iStringVariableArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    IStringVariable v = iStringVariableArray[n3];
                    if (v.getName().equals(key)) {
                        if (v instanceof IDynamicVariable) {
                            try {
                                val = ((IDynamicVariable)v).getValue(null);
                            }
                            catch (CoreException e) {
                                SDKSupportPlugin.error(e);
                            }
                            break;
                        }
                        if (v instanceof IValueVariable) {
                            val = ((IValueVariable)v).getValue();
                            break;
                        }
                        val = v.getName();
                        break;
                    }
                    ++n3;
                }
            }
            if (val != null) {
                s = s.replace(txt, val);
            } else {
                n += txt.length();
                if (doThrow) {
                    String msg = NLS.bind((String)"Reference to undefined variable: {0}", (Object)key);
                    throw new CoreException((IStatus)new Status(4, PLUGIN_ID, msg));
                }
            }
            n = s.indexOf(START_VAR, n);
        }
        return s;
    }

    public static SDKSupportPlugin getDefault() {
        return plugin;
    }

    public static void error(Throwable t) {
        SDKSupportPlugin.log((IStatus)new Status(4, SDKSupportPlugin.getUniqueIdentifier(), 1200, "Error logged from SDK Support Core: ", t));
    }

    public static void error(String message, Throwable throwable) {
        SDKSupportPlugin.log((IStatus)new Status(4, SDKSupportPlugin.getUniqueIdentifier(), 1200, message, throwable));
    }

    public static void log(String message) {
        SDKSupportPlugin.log((IStatus)new Status(1, SDKSupportPlugin.getUniqueIdentifier(), 0, message, null));
    }

    public static void log(IStatus status) {
        SDKSupportPlugin.getDefault().getLog().log(status);
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public void addResourceChangeListeners() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.projectChangeListener = new ProjectChangeListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.projectChangeListener, 1);
        this.sdkAttachListener = new SDKAttachListener();
        workspace.addResourceChangeListener((IResourceChangeListener)this.sdkAttachListener, 32);
    }

    public static Image getImage(String path) {
        return SDKSupportPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path).createImage();
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(BLANK_ICON, SDKSupportPlugin.getImage(BLANK_ICON_PATH));
        reg.put(CHIP_ICON, SDKSupportPlugin.getImage(CHIP_ICON_PATH));
        reg.put(DUPL_ICON, SDKSupportPlugin.getImage(DUPL_ICON_PATH));
        reg.put(FILE_ICON, SDKSupportPlugin.getImage(FILE_ICON_PATH));
        reg.put(FONT_ICON, SDKSupportPlugin.getImage(FONT_ICON_PATH));
        reg.put(TOOL_ICON, SDKSupportPlugin.getImage(TOOL_ICON_PATH));
        reg.put(NONE_ICON, SDKSupportPlugin.getImage(NONE_ICON_PATH));
        reg.put(ERROR_PLATFORM_ICON, SDKSupportPlugin.getImage(ERROR_PLATFORM_ICON_PATH));
        reg.put(PLUS_ICON, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        reg.put(CROSS_ICON, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_REMOVE_DISABLED"));
        reg.put(ERROR_ICON, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
    }

    private void addListeners() {
        VariablesPlugin.getDefault().getStringVariableManager().addValueVariableListener(Environment.vvListener);
    }

    private void removeListeners() {
        VariablesPlugin.getDefault().getStringVariableManager().removeValueVariableListener(Environment.vvListener);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.projectChangeListener != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this.projectChangeListener);
        }
        if (this.sdkAttachListener != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this.sdkAttachListener);
        }
    }
}

