/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.internal.IEnvironment;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.SDKVersion;
import com.nxp.s32ds.cle.ide.sdk.core.platform.SdkPlatform;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SDKHeader {
    public static final String NAME_ATTRIBUTE_TAG = "name";
    public static final String VERSION_ATTRIBUTE_TAG = "version";
    public static final String BASE_PATH_ATTRIBUTE_TAG = "basePath";
    public static final String INTERNAL_PATH_ATTRIBUTE_TAG = "internalPath";
    public static final String LANGS_ATTRIBUTE_TAG = "langs";
    public static final String CORES_ATTRIBUTE_TAG = "cores";
    public static final String DESC_ATTRIBUTE_TAG = "description";
    public static final String GIT_PATH_ATTRIBUTE_TAG = "gitPath";
    public static final String GIT_BRANCH_ATTRIBUTE_TAG = "gitBranch";
    public static final String GIT_LABEL_ATTRIBUTE_TAG = "gitLabel";
    public static final String PEX_ATTRIBUTE_TAG = "pex";
    public static final String ENV_ELEMENT_TAG = "env";
    public static final String ENV_NAME_ATTRIBUTE_TAG = "name";
    public static final String ENV_VALUE_ATTRIBUTE_TAG = "value";
    public static final String ENV_IS_SYSTEM_ATTRIBUTE_TAG = "isSystem";
    public static final String OBSOLETE_TCS_ATTRIBUTE_TAG = "toolchains";
    public static final String TAGS_ATTRIBUTE = "tags";
    public static final String TARGET_FOLDER_NAME_ATTRIBUTE = "targetFolderName";
    public static final String TARGET_PROJECT_TEMPLATE_ATTRIBUTE = "targetProjectTemplate";
    public static final String PLATFORM_ATTRIBUTE = "platform";
    public static final String EXTERNAL_ID_ATTRIBUTE = "externalId";
    private final String name;
    private SDKVersion version;
    private final String description;
    private IEnvironment env;
    private final String id;
    private final boolean isPex;
    private final String cores;
    private final String langs;
    private final String basePath;
    private final boolean isInternal;
    public final String gitpath;
    public final String gitbranch;
    public final String gitlabel;
    private String obsoleteToolchainIds;
    private Set<String> tags;
    private String targetFolderName;
    private String targetProjectTemplate;
    private SdkPlatform platform;
    private String externalId;

    public SDKHeader(String name, String vers, String desc, String path, String langs, String cores, boolean isPex, boolean isInternal, IEnvironment env) {
        this.name = name;
        this.version = SDKVersion.createVersion(vers);
        this.description = desc;
        this.basePath = path;
        this.cores = cores;
        this.env = env;
        this.isPex = isPex;
        this.langs = isPex ? "c" : langs;
        this.isInternal = isInternal;
        this.id = SDKHeader.makeId(name, vers);
        this.obsoleteToolchainIds = null;
        this.gitlabel = null;
        this.gitbranch = null;
        this.gitpath = null;
    }

    public SDKHeader(SdkHeaderParameters parameters) {
        this.name = parameters.getName();
        this.version = SDKVersion.createVersion(parameters.getVersion());
        this.id = SDKHeader.makeId(this.name, parameters.getVersion());
        this.description = parameters.getDescription();
        this.basePath = parameters.getSdkPath();
        this.cores = parameters.getCores();
        this.langs = parameters.getLangs();
        this.isInternal = parameters.isInternal();
        this.isPex = parameters.isPex();
        this.env = parameters.getEnvironment();
        this.tags = parameters.getTags();
        this.targetFolderName = parameters.getTargetFolderName();
        this.targetProjectTemplate = parameters.getTargetProjectTemplate();
        this.platform = parameters.getPlatform();
        this.externalId = parameters.getExternalId();
        this.obsoleteToolchainIds = null;
        this.gitlabel = null;
        this.gitbranch = null;
        this.gitpath = null;
    }

    public SDKHeader(String name, String vers, SDKHeader copy) {
        this.name = name;
        this.version = SDKVersion.createVersion(vers);
        this.description = copy.getDescription();
        this.basePath = copy.getBasePath();
        this.cores = copy.cores;
        this.env = copy.getEnv();
        this.isPex = copy.isPex;
        this.langs = this.isPex ? "c" : copy.langs;
        this.isInternal = copy.isInternal;
        this.id = SDKHeader.makeId(name, vers);
        this.gitlabel = null;
        this.gitbranch = null;
        this.gitpath = null;
        this.obsoleteToolchainIds = copy.obsoleteToolchainIds;
        this.tags = copy.getTags();
        this.targetFolderName = copy.getTargetFolderName();
        this.targetProjectTemplate = copy.getTargetProjectTemplate();
        this.platform = copy.getPlatform();
        this.externalId = copy.getExternalId();
    }

    public SDKHeader(boolean createVar, Element e) {
        this(e, createVar);
    }

    public SDKHeader(IConfigurationElement e) {
        this(e, true);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SDKVersion getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isPEx() {
        return this.isPex;
    }

    public String getLangs() {
        return this.langs;
    }

    public String getCores() {
        return this.cores;
    }

    public String getObsoleteToolchainIds() {
        if (this.obsoleteToolchainIds != null) {
            String tcIds = this.obsoleteToolchainIds.trim();
            return !tcIds.isEmpty() ? tcIds : null;
        }
        return null;
    }

    public Set<String> getObsoleteToolchainIdsSet() {
        String tcIds = this.getObsoleteToolchainIds();
        return tcIds != null ? Arrays.stream(tcIds.split(",")).map(String::trim).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public IEnvironment getEnv() {
        return this.env;
    }

    public void setEnv(IEnvironment env) {
        this.env = env;
    }

    public Set<String> getTags() {
        return this.tags != null ? this.tags : Collections.emptySet();
    }

    public String getTagsAttributeValue() {
        if (this.tags == null || this.tags.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)",", this.tags);
    }

    public boolean isTaggedBy(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public String getTargetFolderName() {
        return this.targetFolderName != null && !this.targetFolderName.isEmpty() ? this.targetFolderName : this.name;
    }

    public String getTargetProjectTemplate() {
        return this.targetProjectTemplate;
    }

    public SdkPlatform getPlatform() {
        return this.platform;
    }

    public String getPlatformTarget() {
        return this.platform != null ? this.platform.getTarget() : "";
    }

    public String getPlatformHost() {
        return this.platform != null ? this.platform.getHost() : "";
    }

    public String getExternalId() {
        return this.externalId != null ? this.externalId : "";
    }

    private SDKHeader(Object holderElement, boolean createVar) {
        this.name = SDKHeader.get(holderElement, "name");
        this.version = SDKVersion.createVersion(SDKHeader.get(holderElement, VERSION_ATTRIBUTE_TAG));
        this.description = SDKHeader.get(holderElement, DESC_ATTRIBUTE_TAG);
        this.obsoleteToolchainIds = SDKHeader.get(holderElement, OBSOLETE_TCS_ATTRIBUTE_TAG);
        this.isPex = SDKUtils.getBoolean(SDKHeader.get(holderElement, PEX_ATTRIBUTE_TAG), false);
        this.langs = this.isPex ? "c" : SDKHeader.get(holderElement, LANGS_ATTRIBUTE_TAG);
        this.cores = SDKHeader.get(holderElement, CORES_ATTRIBUTE_TAG);
        this.id = SDKHeader.makeId(this.name, this.version.toString());
        this.basePath = SDKHeader.get(holderElement, BASE_PATH_ATTRIBUTE_TAG);
        this.isInternal = Boolean.valueOf(SDKHeader.get(holderElement, INTERNAL_PATH_ATTRIBUTE_TAG));
        this.gitpath = SDKHeader.get(holderElement, GIT_PATH_ATTRIBUTE_TAG);
        this.gitbranch = SDKHeader.get(holderElement, GIT_BRANCH_ATTRIBUTE_TAG);
        this.gitlabel = SDKHeader.get(holderElement, GIT_LABEL_ATTRIBUTE_TAG);
        this.setTags(holderElement);
        this.setTargetFolderName(holderElement);
        this.setTargetProjectTemplate(holderElement);
        this.setPlatform(holderElement);
        this.setExternalId(holderElement);
        if (createVar) {
            this.env = this.getEnv(holderElement, this.basePath);
        }
    }

    private void setTags(Object holderElement) {
        String tagsAttributeValue = SDKHeader.get(holderElement, TAGS_ATTRIBUTE);
        this.tags = tagsAttributeValue == null ? Collections.emptySet() : Arrays.stream(tagsAttributeValue.split(",")).map(String::trim).map(String::toLowerCase).filter(tag -> !tag.isEmpty()).collect(Collectors.toSet());
    }

    private void setTargetFolderName(Object holderElement) {
        String targetFolderNameAttributeValue = SDKHeader.get(holderElement, TARGET_FOLDER_NAME_ATTRIBUTE);
        this.targetFolderName = targetFolderNameAttributeValue == null || targetFolderNameAttributeValue.isEmpty() ? this.name : targetFolderNameAttributeValue;
    }

    private void setTargetProjectTemplate(Object holderElement) {
        String targetProjectTemplateAttributeValue = SDKHeader.get(holderElement, TARGET_PROJECT_TEMPLATE_ATTRIBUTE);
        if (targetProjectTemplateAttributeValue != null && !targetProjectTemplateAttributeValue.isEmpty()) {
            this.targetProjectTemplate = targetProjectTemplateAttributeValue;
        }
    }

    private void setPlatform(Object holderElement) {
        SdkPlatform sdkPlatform = SdkPlatform.parseElement(holderElement);
        if (sdkPlatform == null) {
            String platformAttributeValue = SDKHeader.get(holderElement, PLATFORM_ATTRIBUTE);
            if (platformAttributeValue != null && !platformAttributeValue.isEmpty()) {
                this.platform = new SdkPlatform(platformAttributeValue, "");
            }
        } else {
            this.platform = sdkPlatform;
        }
    }

    private void setExternalId(Object holderElement) {
        String externalIdAttributeValue = SDKHeader.get(holderElement, EXTERNAL_ID_ATTRIBUTE);
        if (externalIdAttributeValue != null && !(externalIdAttributeValue = externalIdAttributeValue.trim()).isEmpty()) {
            this.externalId = externalIdAttributeValue;
        }
    }

    private static String get(Object x, String tag) {
        if (x instanceof Element) {
            return ((Element)x).getAttribute(tag);
        }
        if (x instanceof IConfigurationElement) {
            return ((IConfigurationElement)x).getAttribute(tag);
        }
        SDKSupportPlugin.log("Bad class: " + x);
        return "";
    }

    public boolean isGit() {
        return this.gitpath != null && this.gitpath.length() > 0;
    }

    public static String makeId(String n, String v) {
        if (n == null) {
            n = "";
        }
        if (v == null) {
            v = "";
        }
        return String.valueOf(n) + '_' + v + "_PATH";
    }

    private IEnvironment getEnv(Object x, String path) {
        if (x instanceof Element) {
            Element e0 = (Element)x;
            NodeList nl = e0.getElementsByTagName(ENV_ELEMENT_TAG);
            if (nl == null || nl.getLength() == 0) {
                return null;
            }
            Element e = (Element)nl.item(0);
            String envName = e.getAttribute("name");
            String envValue = e.getAttribute(ENV_VALUE_ATTRIBUTE_TAG);
            boolean isSystem = Boolean.valueOf(e.getAttribute(ENV_IS_SYSTEM_ATTRIBUTE_TAG));
            path = path != null && path.trim().length() > 0 ? path : envValue;
            return SDKSupportPlugin.createEnvironment(envName, isSystem, true, path, envName);
        }
        if (x instanceof IConfigurationElement) {
            return null;
        }
        SDKSupportPlugin.log("Bad class: " + x);
        return null;
    }

    public void convertToXml(Document document, Element sdkElement, String[] tcIds, IFilterOptions filterOptions) {
        String tagsAttributeValue;
        sdkElement.setAttribute("id", SDKHeader.makeId(this.getName(), this.version.toString()));
        sdkElement.setAttribute("name", this.name);
        sdkElement.setAttribute(VERSION_ATTRIBUTE_TAG, this.version.toString());
        if (this.description != null) {
            sdkElement.setAttribute(DESC_ATTRIBUTE_TAG, this.description);
        }
        if (tcIds != null) {
            sdkElement.setAttribute(OBSOLETE_TCS_ATTRIBUTE_TAG, String.join((CharSequence)",", tcIds));
        }
        if ((tagsAttributeValue = this.getTagsAttributeValue()) != null) {
            sdkElement.setAttribute(TAGS_ATTRIBUTE, tagsAttributeValue);
        }
        sdkElement.setAttribute(TARGET_FOLDER_NAME_ATTRIBUTE, this.getTargetFolderName());
        if (this.targetProjectTemplate != null && !this.targetProjectTemplate.isEmpty()) {
            sdkElement.setAttribute(TARGET_PROJECT_TEMPLATE_ATTRIBUTE, this.targetProjectTemplate);
        }
        Element envElement = document.createElement(ENV_ELEMENT_TAG);
        envElement.setAttribute("name", this.env.getName());
        envElement.setAttribute(ENV_VALUE_ATTRIBUTE_TAG, this.env.getValue());
        envElement.setAttribute(ENV_IS_SYSTEM_ATTRIBUTE_TAG, String.valueOf(this.env.isSystem()));
        sdkElement.appendChild(envElement);
        if (this.platform != null) {
            this.platform.convertToXml(document, sdkElement);
        }
        if (filterOptions != null) {
            sdkElement.setAttribute(LANGS_ATTRIBUTE_TAG, IFilterOptions.lang2strMap.get((Object)filterOptions.getLang()));
            sdkElement.setAttribute(CORES_ATTRIBUTE_TAG, String.join((CharSequence)",", filterOptions.getCores()));
        } else {
            sdkElement.setAttribute(LANGS_ATTRIBUTE_TAG, IFilterOptions.lang2strMap.get((Object)IFilterOptions.ELang.UNKNOWN));
            sdkElement.setAttribute(CORES_ATTRIBUTE_TAG, "");
        }
        sdkElement.setAttribute(BASE_PATH_ATTRIBUTE_TAG, this.env.getValue());
        if (this.isPex) {
            sdkElement.setAttribute(PEX_ATTRIBUTE_TAG, String.valueOf(this.isPex));
        }
        if (this.externalId != null && !this.externalId.isEmpty()) {
            sdkElement.setAttribute(EXTERNAL_ID_ATTRIBUTE, this.externalId);
        }
    }

    public static SdkHeaderParameters newSdkHeaderParameters() {
        return new SdkHeaderParameters();
    }

    public SdkHeaderParameters getSdkHeaderParameters() {
        SdkHeaderParameters parameters = new SdkHeaderParameters();
        parameters.setName(this.getName());
        parameters.setVersion(this.getVersion().toString());
        parameters.setDescription(this.getDescription());
        parameters.setTargetFolderName(this.getTargetFolderName());
        parameters.setSdkPath(this.getBasePath());
        parameters.setLangs(this.getLangs());
        parameters.setCores(this.getCores());
        parameters.setPex(this.isPEx());
        parameters.setInternal(this.isInternal());
        parameters.setEnvironment(this.getEnv());
        return parameters;
    }

    public static class SdkHeaderParameters {
        private String name;
        private String version;
        private String description;
        private String sdkPath;
        private String langs;
        private String cores;
        private boolean isInternal = false;
        private boolean isPex = false;
        private IEnvironment environment;
        private String targetFolderName;
        private String targetProjectTemplate;
        private Set<String> tags;
        private SdkPlatform platform;
        private String externalId;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getTargetFolderName() {
            return this.targetFolderName;
        }

        public void setTargetFolderName(String targetFolderName) {
            this.targetFolderName = targetFolderName;
        }

        public String getSdkPath() {
            return this.sdkPath;
        }

        public void setSdkPath(String sdkPath) {
            this.sdkPath = sdkPath;
        }

        public String getLangs() {
            return this.isPex() ? "c" : this.langs;
        }

        public void setLangs(String langs) {
            this.langs = this.isPex() ? "c" : langs;
        }

        public String getCores() {
            return this.cores;
        }

        public void setCores(String cores) {
            this.cores = cores;
        }

        public SdkPlatform getPlatform() {
            return this.platform;
        }

        public void setPlatform(SdkPlatform platform) {
            this.platform = platform;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public void setInternal(boolean isInternal) {
            this.isInternal = isInternal;
        }

        public boolean isPex() {
            return this.isPex;
        }

        public void setPex(boolean isPex) {
            this.isPex = isPex;
        }

        public IEnvironment getEnvironment() {
            return this.environment;
        }

        public void setEnvironment(IEnvironment environment) {
            this.environment = environment;
        }

        public String getTargetProjectTemplate() {
            return this.targetProjectTemplate;
        }

        public void setTargetProjectTemplate(String targetProjectTemplate) {
            this.targetProjectTemplate = targetProjectTemplate;
        }

        public Set<String> getTags() {
            return this.tags != null ? this.tags : Collections.emptySet();
        }

        public void setTags(Set<String> tags) {
            this.tags = tags;
        }

        public String getExternalId() {
            return this.externalId;
        }

        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }
    }
}

