/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SDKContextUtil {
    public static boolean isPex(CProjectContext projectContext) {
        return projectContext.getSdkList().stream().filter(modelSdk -> modelSdk instanceof ISDK).map(modelSdk -> (ISDK)modelSdk).anyMatch(ISDK::isPex);
    }

    public static Map<String, List<ISDK>> getSdksGroupByTags(CProjectContext projectContext) {
        return SDKUtils.groupSdksByTag(projectContext.getSdkList().stream().filter(modelSdk -> modelSdk instanceof ISDK).map(modelSdk -> (ISDK)modelSdk).collect(Collectors.toList()));
    }

    public static Map<String, List<ISDK>> getSdksTargetProjectTemplateIds(CProjectContext projectContext) {
        return SDKUtils.groupSdksByTargetProjectTemplateId(projectContext.getSdkList().stream().filter(modelSdk -> modelSdk instanceof ISDK).map(modelSdk -> (ISDK)modelSdk).collect(Collectors.toList()));
    }

    public static Map<String, List<ISDK>> getSdksGroupByPlatformId(CProjectContext projectContext) {
        return SDKUtils.groupSdksByPlatformId(projectContext.getSdkList().stream().filter(modelSdk -> modelSdk instanceof ISDK).map(modelSdk -> (ISDK)modelSdk).collect(Collectors.toList()));
    }
}

