/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.checkers.cproject.UnsupportedProjectTypeException;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.IToolChainFPChecker;
import com.freescale.s32ds.cross.sdk.checkers.cproject.toolchain.fpchecker.ToolChainFPCheckerFactory;
import com.freescale.s32ds.cross.sdk.internal.SDKAttach;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SDKCheckFPProjectSettingRequiredHook
implements ISDKHook {
    private static final int MODE = 517;

    @Override
    public void stateChange(int mode, ISDK sdk, Object cfg, String path) {
        if (mode == 517) {
            try {
                List<IStatus> checkResults = this.checkFPProjectSettings(sdk, ((IConfiguration)cfg).getManagedProject(), path);
                if (!checkResults.isEmpty()) {
                    String message = NLS.bind((String)Messages.SDKCheckFPProjectSetting_warning_message, (Object)sdk.getId(), (Object)path);
                    StringBuilder sb = new StringBuilder(message);
                    for (IStatus checkResult : checkResults) {
                        sb.append(checkResult.getMessage()).append('\n');
                    }
                    this.showMessage(sb.toString());
                }
            }
            catch (Exception e) {
                Status status = new Status(4, "com.freescale.s32ds.cross.sdk.support", e.getMessage(), (Throwable)e);
                SDKSupportPlugin.log((IStatus)status);
            }
        }
    }

    private List<IStatus> checkFPProjectSettings(ISDK sdk, IManagedProject managedProject, String projectName) throws UnsupportedProjectTypeException, CoreException {
        IToolChainFPChecker tcChecker = ToolChainFPCheckerFactory.getToolchainFPChecker(managedProject);
        ArrayList<IStatus> checkResults = new ArrayList<IStatus>();
        IConfiguration[] iConfigurationArray = managedProject.getConfigurations();
        int n = iConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status;
            IConfiguration config = iConfigurationArray[n2];
            if (SDKAttach.isAttached(projectName, config.getName(), sdk.getId()) && !(status = tcChecker.checkToolChainFPOptionsSet(config)).isOK()) {
                checkResults.add(status);
            }
            ++n2;
        }
        return checkResults;
    }

    private void showMessage(final String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SDKCheckFPProjectSetting_warning_title, (String)message);
            }
        });
    }
}

