/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.processors.KExProcessorsProvider;
import com.nxp.swtools.provider.toolchainproject.ISdkComponentInProject;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectChangeListener;
import com.nxp.swtools.provider.toolchainproject.IToolchainProjectInfo;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;

public interface IToolchainProjectWithSdk
extends IToolchainProjectInfo {
    default public @NonNull String getProjectReference() {
        String path = this.getProjectRoot().toString();
        return path.isEmpty() ? this.getProjectName() : path;
    }

    default public boolean wasProjectDetected() {
        return this.getToolchain() != null;
    }

    public @Nullable String getProjectDetectionProblem();

    public @Nullable String getToolchainId();

    public @Nullable String getToolchain();

    public @Nullable ISdkComponentInProject getSdkComponent(@NonNull String var1);

    public @Nullable String getProcessor();

    public @Nullable String getPartNumber();

    public @Nullable String getCoreId();

    public @NonNull List<@NonNull Path> getIncludePaths();

    public boolean canAddAdditionalComponents();

    public boolean addComponent(@NonNull String var1);

    public boolean addComponents(@NonNull List<@NonNull String> var1);

    public void addChangeListener(@NonNull IToolchainProjectChangeListener var1);

    public void removeChangeListener(@NonNull IToolchainProjectChangeListener var1);

    public boolean isProjectAccessible();

    public void close();

    public @Nullable IProject getEclipseProject();

    default public boolean existsProcessor(@NonNull String processor) {
        String sdkVersion = SWToolsPlatform.getSdkVersionForProcessor(processor);
        return KExProcessorsProvider.checkOrDownloadProcessor(processor, sdkVersion, false).isProcessorPresent();
    }

    default public void logProblemsInSdkComponentDetection() {
    }

    public @NonNull Collection<@NonNull ISdkComponentInProject> getRteComponents();

    public boolean deleteFile(@NonNull Path var1);

    public boolean deleteFileSafe(@NonNull Path var1);

    default public void updateProjectSettings(@NonNull ISharedConfiguration shrdConfig) {
    }
}

