/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.toolchainproject.ProjectFileContentCache;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.regex.Pattern;

public interface IToolchainProjectInfo
extends IProjectFileAccess {
    public @NonNull String getProjectName();

    public @NonNull Path getProjectRoot();

    public @Nullable Path findSourceFileRelPath(@NonNull String var1);

    public @NonNull Collection<@NonNull Path> listProjectSources(@NonNull String var1);

    public @NonNull Collection<@NonNull Path> listProjectSourcesByRegEx(@NonNull Pattern var1);

    public @Nullable InputStream openSourceFile(@NonNull Path var1);

    default public @Nullable String getSourceFile_AsCachedString(@NonNull Path relPath) {
        long prjModificationStamp;
        Path prjPath = this.getProjectRoot();
        if (SWToolsPlatform.isRunningAsRcp() && prjPath.toString().isEmpty()) {
            return null;
        }
        Path absPath = prjPath.resolve(relPath);
        String result = ProjectFileContentCache.getPrjFileContentAsString(absPath, prjModificationStamp = this.getSourceModificationStamp(relPath));
        if (result != null) {
            return result;
        }
        if (prjModificationStamp <= 0L) {
            return ProjectFileContentCache.readToString(this.openSourceFile(relPath));
        }
        try {
            Throwable throwable = null;
            Object var8_8 = null;
            try (InputStream iStrm = this.openSourceFile(relPath);){
                result = ProjectFileContentCache.readToString(iStrm);
                if (result != null) {
                    ProjectFileContentCache.putProjectFileContentToCache(absPath, prjModificationStamp, result);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    default public @Nullable InputStream getSourceFile_AsCachedStream(@NonNull Path relPath) {
        long prjModificationStamp;
        Path absPath = this.getProjectRoot().resolve(relPath);
        InputStream result = ProjectFileContentCache.getPrjFileContentAsInpStream(absPath, prjModificationStamp = this.getSourceModificationStamp(relPath));
        if (result != null) {
            return result;
        }
        if (prjModificationStamp <= 0L) {
            return this.openSourceFile(relPath);
        }
        String content = this.getSourceFile_AsCachedString(relPath);
        return content == null ? null : new ByteArrayInputStream(content.getBytes(StandardCharsets.US_ASCII));
    }

    public long getSourceModificationStamp(@NonNull Path var1);
}

